/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;

public class ColorUtil {
    private static final Map<Integer, float[]> colorCache = new HashMap<Integer, float[]>();
    private static final Map<String, Integer> stringColorCache = new HashMap<String, Integer>();

    public static Integer getCacheColor(String color) {
        if (!stringColorCache.containsKey(color)) {
            stringColorCache.put(color, TextColor.m_131268_((String)color).m_131265_());
        }
        return stringColorCache.get(color);
    }

    public static float[] getCacheColor(int color) {
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, ColorUtil.getComponents(color));
        }
        return colorCache.get(color);
    }

    public static float[] getComponents(int color) {
        float[] f = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return f;
    }

    public static float[] getCycleColor(int color, int color2, int tickCount, float partialTicks) {
        float f3 = ((float)(tickCount % 25) + partialTicks) / 25.0f;
        float[] afloat1 = ColorUtil.getCacheColor(color);
        float[] afloat2 = ColorUtil.getCacheColor(color2);
        float f = afloat1[0] * (1.0f - f3) + afloat2[0] * f3;
        float f1 = afloat1[1] * (1.0f - f3) + afloat2[1] * f3;
        float f2 = afloat1[2] * (1.0f - f3) + afloat2[2] * f3;
        return new float[]{f, f1, f2};
    }

    public static ChatFormatting getBeeTypeColor(String type) {
        return switch (type) {
            case "hive" -> ChatFormatting.YELLOW;
            case "solitary" -> ChatFormatting.GRAY;
            default -> ChatFormatting.WHITE;
        };
    }

    public static ChatFormatting getAttributeColor(int level) {
        return switch (level) {
            case -3 -> ChatFormatting.GOLD;
            case -2 -> ChatFormatting.DARK_RED;
            case -1 -> ChatFormatting.YELLOW;
            case 1 -> ChatFormatting.BLUE;
            case 2 -> ChatFormatting.LIGHT_PURPLE;
            case 3 -> ChatFormatting.RED;
            default -> ChatFormatting.GREEN;
        };
    }
}

