/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.machines.interdiction;

import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.permutated.pylons.ModRegistry;
import net.permutated.pylons.item.MobFilterCard;
import net.permutated.pylons.machines.base.AbstractPylonTile;
import net.permutated.pylons.util.SpawnManager;

public class InterdictionPylonTile
extends AbstractPylonTile {
    private boolean dirty = true;

    public InterdictionPylonTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModRegistry.INTERDICTION_PYLON_TILE.get(), pos, state);
    }

    @Override
    protected byte[] getRange() {
        return new byte[]{1, 3, 5};
    }

    @Override
    protected boolean isItemValid(ItemStack stack) {
        return stack.m_41720_() instanceof MobFilterCard;
    }

    @Override
    public void tick() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.canTick(20) && this.dirty) {
                HashSet<String> filters = new HashSet<String>();
                for (int i = 0; i < this.itemStackHandler.getSlots(); ++i) {
                    CompoundTag tag;
                    ItemStack stack = this.itemStackHandler.getStackInSlot(i);
                    if (stack.m_41619_() || !(stack.m_41720_() instanceof MobFilterCard) || (tag = stack.m_41737_("pylons")) == null || !tag.m_128441_("registry")) continue;
                    filters.add(tag.m_128461_("registry"));
                }
                SpawnManager.register(serverLevel, this.f_58858_, this.range, filters);
                this.dirty = false;
            }
        }
    }

    @Override
    public void removeChunkloads() {
        super.removeChunkloads();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SpawnManager.unregister(serverLevel, this.f_58858_);
        }
    }

    public void m_6596_() {
        super.m_6596_();
        this.dirty = true;
    }
}

