/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.BaseContainerType;
import com.supermartijn642.rechiseled.chiseling.ChiselingEntry;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipe;
import com.supermartijn642.rechiseled.chiseling.ChiselingRecipes;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public abstract class BaseChiselingContainer
extends BaseContainer {
    public ChiselingRecipe currentRecipe = null;
    public ChiselingEntry currentEntry = null;
    public boolean connecting = false;

    public BaseChiselingContainer(BaseContainerType<?> type, Player player) {
        super(type, player);
        this.addSlots();
    }

    protected void addSlots(Player playerEntity) {
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (slot == 0) {
                    BaseChiselingContainer.this.setCurrentStack(stack);
                    BaseChiselingContainer.this.updateRecipe();
                }
            }

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return slot == 0 ? BaseChiselingContainer.this.getCurrentStack() : ItemStack.f_41583_;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (slot != 0 || stack.m_41619_()) {
                    return stack.m_41777_();
                }
                ItemStack currentStack = BaseChiselingContainer.this.getCurrentStack();
                if (!currentStack.m_41619_() && !ItemStack.m_41728_((ItemStack)currentStack, (ItemStack)stack)) {
                    return stack.m_41777_();
                }
                int count = Math.min(stack.m_41613_(), stack.m_41741_() - currentStack.m_41613_());
                if (!simulate) {
                    ItemStack newStack = stack.m_41777_();
                    newStack.m_41764_(currentStack.m_41613_() + count);
                    BaseChiselingContainer.this.setCurrentStack(newStack);
                }
                stack = stack.m_41777_();
                stack.m_41774_(count);
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot != 0 || amount <= 0) {
                    return ItemStack.f_41583_;
                }
                ItemStack currentStack = BaseChiselingContainer.this.getCurrentStack();
                int count = Math.min(amount, currentStack.m_41613_());
                if (!simulate) {
                    ItemStack newStack = currentStack.m_41777_();
                    newStack.m_41774_(count);
                    BaseChiselingContainer.this.setCurrentStack(newStack);
                    BaseChiselingContainer.this.updateRecipe();
                }
                currentStack = currentStack.m_41777_();
                currentStack.m_41764_(count);
                return currentStack;
            }

            public int getSlotLimit(int slot) {
                if (slot != 0) {
                    return 0;
                }
                ItemStack currentStack = BaseChiselingContainer.this.getCurrentStack();
                return currentStack.m_41619_() ? 64 : currentStack.m_41741_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return slot == 0 && ChiselingRecipes.getRecipe(stack) != null;
            }
        }, 0, 154, 102));
        this.addPlayerSlots(31, 144);
    }

    public boolean m_6875_(Player playerIn) {
        return !this.shouldBeClosed();
    }

    protected void updateRecipe() {
        ItemStack stack = this.getCurrentStack();
        if (stack.m_41619_()) {
            this.currentRecipe = null;
            this.currentEntry = null;
            this.connecting = false;
        } else {
            this.currentRecipe = ChiselingRecipes.getRecipe(stack);
            if (this.currentRecipe != null) {
                for (ChiselingEntry entry : this.currentRecipe.getEntries()) {
                    if (entry.hasRegularItem() && entry.getRegularItem() == stack.m_41720_()) {
                        this.currentEntry = entry;
                        this.connecting = false;
                        return;
                    }
                    if (!entry.hasConnectingItem() || entry.getConnectingItem() != stack.m_41720_()) continue;
                    this.currentEntry = entry;
                    this.connecting = true;
                    return;
                }
            } else {
                this.currentEntry = null;
                this.connecting = false;
            }
        }
    }

    public void setCurrentEntry(int index) {
        if (this.currentRecipe == null || index >= this.currentRecipe.getEntries().size()) {
            return;
        }
        ChiselingEntry entry = this.currentRecipe.getEntries().get(index);
        Item item = this.connecting && entry.hasConnectingItem() || !entry.hasRegularItem() ? entry.getConnectingItem() : entry.getRegularItem();
        ItemStack stack = new ItemStack((ItemLike)item, this.getCurrentStack().m_41613_());
        this.setCurrentStack(stack);
        this.updateRecipe();
    }

    public void toggleConnecting() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.connecting) {
            if (this.currentEntry.hasRegularItem()) {
                ItemStack stack = new ItemStack((ItemLike)this.currentEntry.getRegularItem(), this.getCurrentStack().m_41613_());
                this.setCurrentStack(stack);
                this.updateRecipe();
            }
        } else if (this.currentEntry.hasConnectingItem()) {
            ItemStack stack = new ItemStack((ItemLike)this.currentEntry.getConnectingItem(), this.getCurrentStack().m_41613_());
            this.setCurrentStack(stack);
            this.updateRecipe();
        }
    }

    public void chiselAll() {
        if (this.currentRecipe == null) {
            return;
        }
        Inventory inventory = this.player.m_150109_();
        for (int index = 0; index < inventory.m_6643_(); ++index) {
            Item item;
            ItemStack stack = inventory.m_8020_(index);
            Item item2 = item = this.connecting ? this.currentEntry.getConnectingItem() : this.currentEntry.getRegularItem();
            if (stack.m_41613_() > item.m_41459_()) continue;
            for (ChiselingEntry entry : this.currentRecipe.getEntries()) {
                if (stack.m_41782_() && !stack.m_41783_().m_128456_() || (!entry.hasConnectingItem() || stack.m_41720_() != entry.getConnectingItem()) && (!entry.hasRegularItem() || stack.m_41720_() != entry.getRegularItem())) continue;
                stack = new ItemStack((ItemLike)item, stack.m_41613_());
                inventory.m_6836_(index, stack);
            }
        }
    }

    public abstract ItemStack getCurrentStack();

    public abstract void setCurrentStack(ItemStack var1);

    public abstract boolean shouldBeClosed();

    public ItemStack m_7648_(Player player, int index) {
        ItemStack stack = this.m_38853_(index).m_7993_();
        if (stack.m_41619_()) {
            return stack;
        }
        if (index == 0 ? !this.m_38903_(stack, 1, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, 1, true)) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            ((Slot)this.f_38839_.get(index)).m_5852_(stack);
        }
        return stack;
    }

    protected boolean m_38903_(ItemStack stack, int minSlot, int maxSlot, boolean reversed) {
        ItemStack slotStack;
        Slot slot;
        boolean changed = false;
        int index = minSlot;
        if (reversed) {
            index = maxSlot - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (Slot)this.f_38839_.get(index);
                slotStack = slot.m_7993_();
                if (!slotStack.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)slotStack)) {
                    int maxSize;
                    int sumCount = slotStack.m_41613_() + stack.m_41613_();
                    if (sumCount <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        slotStack.m_41764_(sumCount);
                        slot.m_5852_(slotStack);
                        changed = true;
                    } else if (slotStack.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - slotStack.m_41613_());
                        slotStack.m_41764_(maxSize);
                        slot.m_5852_(slotStack);
                        changed = true;
                    }
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        if (!stack.m_41619_()) {
            index = reversed ? maxSlot - 1 : minSlot;
            while (!(!reversed ? index >= maxSlot : index < minSlot)) {
                slot = (Slot)this.f_38839_.get(index);
                slotStack = slot.m_7993_();
                if (slotStack.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41613_() > slot.m_6641_()) {
                        slot.m_5852_(stack.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    changed = true;
                    break;
                }
                if (reversed) {
                    --index;
                    continue;
                }
                ++index;
            }
        }
        return changed;
    }
}

