/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.Main;
import com.talhanation.recruits.RecruitEvents;
import com.talhanation.recruits.client.gui.DisbandScreen;
import com.talhanation.recruits.client.gui.MessengerScreen;
import com.talhanation.recruits.client.gui.ScoutScreen;
import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.widgets.ScrollDropDownMenu;
import com.talhanation.recruits.compat.SmallShips;
import com.talhanation.recruits.compat.workers.IVillagerWorker;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.BowmanEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.CrossBowmanEntity;
import com.talhanation.recruits.entities.HorsemanEntity;
import com.talhanation.recruits.entities.ICompanion;
import com.talhanation.recruits.entities.MessengerEntity;
import com.talhanation.recruits.entities.NomadEntity;
import com.talhanation.recruits.entities.PatrolLeaderEntity;
import com.talhanation.recruits.entities.RecruitEntity;
import com.talhanation.recruits.entities.RecruitShieldmanEntity;
import com.talhanation.recruits.entities.ScoutEntity;
import com.talhanation.recruits.inventory.RecruitInventoryMenu;
import com.talhanation.recruits.network.MessageAggroGui;
import com.talhanation.recruits.network.MessageClearTargetGui;
import com.talhanation.recruits.network.MessageClearUpkeepGui;
import com.talhanation.recruits.network.MessageDismountGui;
import com.talhanation.recruits.network.MessageFollowGui;
import com.talhanation.recruits.network.MessageGroup;
import com.talhanation.recruits.network.MessageListen;
import com.talhanation.recruits.network.MessageMountEntityGui;
import com.talhanation.recruits.network.MessageOpenSpecialScreen;
import de.maxhenkel.recruits.corelib.inventory.ScreenBase;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ExtendedButton;

@OnlyIn(value=Dist.CLIENT)
public class RecruitInventoryScreen
extends ScreenBase<RecruitInventoryMenu> {
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/recruit_gui.png");
    private static final MutableComponent TEXT_HEALTH = Component.m_237115_((String)"gui.recruits.inv.health");
    private static final MutableComponent TEXT_LEVEL = Component.m_237115_((String)"gui.recruits.inv.level");
    private static final MutableComponent TEXT_KILLS = Component.m_237115_((String)"gui.recruits.inv.kills");
    private static final MutableComponent TEXT_DISBAND = Component.m_237115_((String)"gui.recruits.inv.text.disband");
    private static final MutableComponent TEXT_INFO_FOLLOW = Component.m_237115_((String)"gui.recruits.inv.info.text.follow");
    private static final MutableComponent TEXT_INFO_WANDER = Component.m_237115_((String)"gui.recruits.inv.info.text.wander");
    private static final MutableComponent TEXT_INFO_HOLD_POS = Component.m_237115_((String)"gui.recruits.inv.info.text.hold_pos");
    private static final MutableComponent TEXT_INFO_PASSIVE = Component.m_237115_((String)"gui.recruits.inv.info.text.passive");
    private static final MutableComponent TEXT_INFO_NEUTRAL = Component.m_237115_((String)"gui.recruits.inv.info.text.neutral");
    private static final MutableComponent TEXT_INFO_AGGRESSIVE = Component.m_237115_((String)"gui.recruits.inv.info.text.aggressive");
    private static final MutableComponent TEXT_INFO_LISTEN = Component.m_237115_((String)"gui.recruits.inv.info.text.listen");
    private static final MutableComponent TEXT_INFO_IGNORE = Component.m_237115_((String)"gui.recruits.inv.info.text.ignore");
    private static final MutableComponent TEXT_INFO_RAID = Component.m_237115_((String)"gui.recruits.inv.info.text.raid");
    private static final MutableComponent TEXT_INFO_PROTECT = Component.m_237115_((String)"gui.recruits.inv.info.text.protect");
    private static final MutableComponent TEXT_INFO_WORKING = Component.m_237115_((String)"gui.recruits.inv.info.text.working");
    private static final MutableComponent TEXT_DISMOUNT = Component.m_237115_((String)"gui.recruits.inv.text.dismount");
    private static final MutableComponent TEXT_BACK_TO_MOUNT = Component.m_237115_((String)"gui.recruits.inv.text.backToMount");
    private static final MutableComponent TOOLTIP_DISMOUNT = Component.m_237115_((String)"gui.recruits.inv.tooltip.dismount");
    private static final MutableComponent TOOLTIP_FOLLOW = Component.m_237115_((String)"gui.recruits.inv.tooltip.follow");
    private static final MutableComponent TOOLTIP_WANDER = Component.m_237115_((String)"gui.recruits.inv.tooltip.wander");
    private static final MutableComponent TOOLTIP_HOLD_MY_POS = Component.m_237115_((String)"gui.recruits.inv.tooltip.holdMyPos");
    private static final MutableComponent TOOLTIP_HOLD_POS = Component.m_237115_((String)"gui.recruits.inv.tooltip.holdPos");
    private static final MutableComponent TOOLTIP_BACK_TO_POS = Component.m_237115_((String)"gui.recruits.inv.tooltip.backToPos");
    private static final MutableComponent TOOLTIP_CLEAR_TARGET = Component.m_237115_((String)"gui.recruits.inv.tooltip.clearTargets");
    private static final MutableComponent TOOLTIP_MOUNT = Component.m_237115_((String)"gui.recruits.inv.tooltip.mount");
    private static final MutableComponent TOOLTIP_PASSIVE = Component.m_237115_((String)"gui.recruits.inv.tooltip.passive");
    private static final MutableComponent TOOLTIP_NEUTRAL = Component.m_237115_((String)"gui.recruits.inv.tooltip.neutral");
    private static final MutableComponent TOOLTIP_AGGRESSIVE = Component.m_237115_((String)"gui.recruits.inv.tooltip.aggressive");
    private static final MutableComponent TOOLTIP_RAID = Component.m_237115_((String)"gui.recruits.inv.tooltip.raid");
    private static final MutableComponent TOOLTIP_BACK_TO_MOUNT = Component.m_237115_((String)"gui.recruits.inv.tooltip.backToMount");
    private static final MutableComponent TOOLTIP_CLEAR_UPKEEP = Component.m_237115_((String)"gui.recruits.inv.tooltip.clearUpkeep");
    private static final MutableComponent TEXT_FOLLOW = Component.m_237115_((String)"gui.recruits.inv.text.follow");
    private static final MutableComponent TEXT_WANDER = Component.m_237115_((String)"gui.recruits.inv.text.wander");
    private static final MutableComponent TEXT_HOLD_MY_POS = Component.m_237115_((String)"gui.recruits.inv.text.holdMyPos");
    private static final MutableComponent TEXT_HOLD_POS = Component.m_237115_((String)"gui.recruits.inv.text.holdPos");
    private static final MutableComponent TEXT_BACK_TO_POS = Component.m_237115_((String)"gui.recruits.inv.text.backToPos");
    private static final MutableComponent TEXT_PASSIVE = Component.m_237115_((String)"gui.recruits.inv.text.passive");
    private static final MutableComponent TEXT_NEUTRAL = Component.m_237115_((String)"gui.recruits.inv.text.neutral");
    private static final MutableComponent TEXT_AGGRESSIVE = Component.m_237115_((String)"gui.recruits.inv.text.aggressive");
    private static final MutableComponent TEXT_RAID = Component.m_237115_((String)"gui.recruits.inv.text.raid");
    private static final MutableComponent TEXT_CLEAR_TARGET = Component.m_237115_((String)"gui.recruits.inv.text.clearTargets");
    private static final MutableComponent TEXT_MOUNT = Component.m_237115_((String)"gui.recruits.command.text.mount");
    private static final MutableComponent TEXT_CLEAR_UPKEEP = Component.m_237115_((String)"gui.recruits.inv.text.clearUpkeep");
    private static final MutableComponent TEXT_PROMOTE = Component.m_237115_((String)"gui.recruits.inv.text.promote");
    private static final MutableComponent TEXT_SPECIAL = Component.m_237115_((String)"gui.recruits.inv.text.special");
    private static final MutableComponent TOOLTIP_PROMOTE = Component.m_237115_((String)"gui.recruits.inv.tooltip.promote");
    private static final MutableComponent TOOLTIP_DISABLED_PROMOTE = Component.m_237115_((String)"gui.recruits.inv.tooltip.promote_disabled");
    private static final MutableComponent TOOLTIP_SPECIAL = Component.m_237115_((String)"gui.recruits.inv.tooltip.special");
    private static final int fontColor = 0x404040;
    private final AbstractRecruitEntity recruit;
    private final Inventory playerInventory;
    public static List<RecruitsGroup> groups;
    private RecruitsGroup currentGroup;
    private int follow;
    private int aggro;
    private Button clearUpkeep;
    private boolean canPromote;
    private boolean buttonsSet;
    private ScrollDropDownMenu<RecruitsGroup> groupSelectionDropDownMenu;

    public RecruitInventoryScreen(RecruitInventoryMenu recruitContainer, Inventory playerInventory, Component title) {
        super(RESOURCE_LOCATION, recruitContainer, playerInventory, (Component)Component.m_237113_((String)""));
        this.recruit = recruitContainer.getRecruit();
        this.playerInventory = playerInventory;
        this.f_97726_ = 176;
        this.f_97727_ = 223;
    }

    protected void m_7856_() {
        super.m_7856_();
        int zeroLeftPos = this.f_97735_ + 180;
        int zeroTopPos = this.f_97736_ + 10;
        int topPosGab = 5;
        this.canPromote = this.recruit.getXpLevel() >= 3;
        this.m_169413_();
        ExtendedButton buttonPassive = new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 0, 80, 20, (Component)TEXT_PASSIVE, button -> {
            this.aggro = this.recruit.getState();
            if (this.aggro != 3) {
                this.aggro = 3;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggroGui(this.aggro, this.recruit.m_20148_()));
            }
        });
        buttonPassive.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_PASSIVE));
        this.m_142416_((GuiEventListener)buttonPassive);
        ExtendedButton buttonNeutral = new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 1, 80, 20, (Component)TEXT_NEUTRAL, button -> {
            this.aggro = this.recruit.getState();
            if (this.aggro != 0) {
                this.aggro = 0;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggroGui(this.aggro, this.recruit.m_20148_()));
            }
        });
        buttonNeutral.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_NEUTRAL));
        this.m_142416_((GuiEventListener)buttonNeutral);
        ExtendedButton buttonAggressive = new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 2, 80, 20, (Component)TEXT_AGGRESSIVE, button -> {
            this.aggro = this.recruit.getState();
            if (this.aggro != 1) {
                this.aggro = 1;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggroGui(this.aggro, this.recruit.m_20148_()));
            }
        });
        buttonAggressive.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_AGGRESSIVE));
        this.m_142416_((GuiEventListener)buttonAggressive);
        ExtendedButton buttonRaid = new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 3, 80, 20, (Component)TEXT_RAID, button -> {
            this.aggro = this.recruit.getState();
            if (this.aggro != 2) {
                this.aggro = 2;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageAggroGui(this.aggro, this.recruit.m_20148_()));
            }
        });
        buttonRaid.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_RAID));
        this.m_142416_((GuiEventListener)buttonRaid);
        ExtendedButton buttonClearTarget = new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 4, 80, 20, (Component)TEXT_CLEAR_TARGET, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageClearTargetGui(this.playerInventory.f_35978_.m_20148_(), this.recruit.m_20148_())));
        buttonClearTarget.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_CLEAR_TARGET));
        this.m_142416_((GuiEventListener)buttonClearTarget);
        ExtendedButton buttonMount = new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 5, 80, 20, (Component)TEXT_MOUNT, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMountEntityGui(this.recruit.m_20148_(), false)));
        buttonMount.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_MOUNT));
        this.m_142416_((GuiEventListener)buttonMount);
        ExtendedButton buttonWander = new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 0, 80, 20, (Component)TEXT_WANDER, button -> {
            this.follow = this.recruit.getFollowState();
            if (this.follow != 0) {
                this.follow = 0;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.follow, this.recruit.m_20148_()));
            }
        });
        buttonWander.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_WANDER));
        this.m_142416_((GuiEventListener)buttonWander);
        ExtendedButton buttonFollow = new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 1, 80, 20, (Component)TEXT_FOLLOW, button -> {
            this.follow = this.recruit.getFollowState();
            if (this.follow != 1) {
                this.follow = 1;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.follow, this.recruit.m_20148_()));
            }
        });
        buttonFollow.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_FOLLOW));
        this.m_142416_((GuiEventListener)buttonFollow);
        ExtendedButton buttonHoldPos = new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 2, 80, 20, (Component)TEXT_HOLD_POS, button -> {
            this.follow = this.recruit.getFollowState();
            if (this.follow != 2) {
                this.follow = 2;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.follow, this.recruit.m_20148_()));
            }
        });
        buttonHoldPos.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_HOLD_POS));
        this.m_142416_((GuiEventListener)buttonHoldPos);
        ExtendedButton buttonBackToPos = new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 3, 80, 20, (Component)TEXT_BACK_TO_POS, button -> {
            this.follow = this.recruit.getFollowState();
            if (this.follow != 3) {
                this.follow = 3;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.follow, this.recruit.m_20148_()));
            }
        });
        buttonBackToPos.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACK_TO_POS));
        this.m_142416_((GuiEventListener)buttonBackToPos);
        ExtendedButton buttonHoldMyPos = new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 4, 80, 20, (Component)TEXT_HOLD_MY_POS, button -> {
            this.follow = this.recruit.getFollowState();
            if (this.follow != 4) {
                this.follow = 4;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageFollowGui(this.follow, this.recruit.m_20148_()));
            }
        });
        buttonHoldMyPos.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_HOLD_MY_POS));
        this.m_142416_((GuiEventListener)buttonHoldMyPos);
        ExtendedButton buttonDismount = new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 5, 80, 20, (Component)TEXT_DISMOUNT, button -> {
            this.follow = this.recruit.getFollowState();
            if (this.follow != 4) {
                this.follow = 4;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageDismountGui(this.playerInventory.f_35978_.m_20148_(), this.recruit.m_20148_()));
            }
        });
        buttonDismount.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_DISMOUNT));
        this.m_142416_((GuiEventListener)buttonDismount);
        ExtendedButton backToMount = (ExtendedButton)this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 6, 80, 20, (Component)TEXT_BACK_TO_MOUNT, button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageMountEntityGui(this.recruit.m_20148_(), true))));
        backToMount.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_BACK_TO_MOUNT));
        this.m_142416_((GuiEventListener)backToMount);
        this.clearUpkeep = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos - 270, zeroTopPos + (20 + topPosGab) * 6, 80, 20, (Component)TEXT_CLEAR_UPKEEP, button -> {
            Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageClearUpkeepGui(this.recruit.m_20148_()));
            this.clearUpkeep.f_93623_ = false;
        }));
        this.clearUpkeep.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_CLEAR_UPKEEP));
        this.clearUpkeep.f_93623_ = this.recruit.hasUpkeep();
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 77, this.f_97736_ + 100, 12, 12, (Component)Component.m_237113_((String)"<"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageListen(!this.recruit.getListen(), this.recruit.m_20148_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 77 + 81, this.f_97736_ + 100, 12, 12, (Component)Component.m_237113_((String)">"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageListen(!this.recruit.getListen(), this.recruit.m_20148_()))));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 77 + 55, this.f_97736_ + 4, 40, 12, (Component)Component.m_237113_((String)"..."), button -> this.f_96541_.m_91152_((Screen)new DisbandScreen((Screen)this, this.recruit, this.playerInventory.f_35978_))));
        if (this.recruit instanceof ICompanion || this.recruit instanceof IVillagerWorker) {
            Button promoteButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 8, 80, 20, (Component)TEXT_SPECIAL, button -> {
                IVillagerWorker worker;
                AbstractRecruitEntity patt17569$temp = this.recruit;
                if (patt17569$temp instanceof ScoutEntity) {
                    ScoutEntity scout = (ScoutEntity)patt17569$temp;
                    this.f_96541_.m_91152_((Screen)new ScoutScreen(scout, (Player)this.getMinecraft().f_91074_));
                    return;
                }
                AbstractRecruitEntity patt17807$temp = this.recruit;
                if (patt17807$temp instanceof MessengerEntity) {
                    MessengerEntity messenger = (MessengerEntity)patt17807$temp;
                    this.f_96541_.m_91152_((Screen)new MessengerScreen(messenger, (Player)this.getMinecraft().f_91074_));
                    return;
                }
                AbstractRecruitEntity patt18061$temp = this.recruit;
                if (patt18061$temp instanceof IVillagerWorker && (worker = (IVillagerWorker)((Object)patt18061$temp)).hasOnlyScreen()) {
                    this.f_96541_.m_91152_(worker.getSpecialScreen(this.recruit, (Player)this.getMinecraft().f_91074_));
                    return;
                }
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenSpecialScreen(this.playerInventory.f_35978_, this.recruit.m_20148_()));
                this.m_7379_();
            }));
            promoteButton.m_257544_(Tooltip.m_257550_((Component)TOOLTIP_SPECIAL));
            promoteButton.f_93623_ = this.canPromote;
        } else {
            Button promoteButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(zeroLeftPos, zeroTopPos + (20 + topPosGab) * 8, 80, 20, (Component)TEXT_PROMOTE, button -> {
                RecruitEvents.openPromoteScreen(this.playerInventory.f_35978_, this.recruit);
                this.m_7379_();
            }));
            promoteButton.m_257544_(Tooltip.m_257550_((Component)(this.canPromote ? TOOLTIP_PROMOTE : TOOLTIP_DISABLED_PROMOTE)));
            promoteButton.f_93623_ = this.canPromote;
        }
    }

    protected void m_181908_() {
        super.m_181908_();
        if (groups != null && !groups.isEmpty() && !this.buttonsSet) {
            groups.sort(Comparator.comparingInt(RecruitsGroup::getId));
            this.currentGroup = this.getCurrentGroup(this.recruit.getGroup());
            this.groupSelectionDropDownMenu = new ScrollDropDownMenu<RecruitsGroup>(this.currentGroup, this.f_97735_ + 77, this.f_97736_ + 114, 93, 12, groups, RecruitsGroup::getName, selected -> {
                this.currentGroup = selected;
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageGroup(this.currentGroup.getId(), this.recruit.m_20148_()));
            });
            this.groupSelectionDropDownMenu.setBgFillSelected(FastColor.ARGB32.m_13660_((int)255, (int)139, (int)139, (int)139));
            this.groupSelectionDropDownMenu.f_93624_ = Minecraft.m_91087_().f_91074_.m_20148_().equals(this.recruit.getOwnerUUID());
            this.m_142416_((GuiEventListener)this.groupSelectionDropDownMenu);
            this.buttonsSet = true;
        }
    }

    private RecruitsGroup getCurrentGroup(int x) {
        RecruitsGroup group = null;
        for (RecruitsGroup recruitsGroup : groups) {
            if (recruitsGroup.getId() != x) continue;
            group = recruitsGroup;
            break;
        }
        return group;
    }

    public void m_94757_(double x, double y) {
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.onMouseMove(x, y);
        }
        super.m_94757_(x, y);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.groupSelectionDropDownMenu != null && this.groupSelectionDropDownMenu.m_5953_(mouseX, mouseY)) {
            this.groupSelectionDropDownMenu.onMouseClick(mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double x, double y, double d) {
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.m_6050_(x, y, d);
        }
        return super.m_6050_(x, y, d);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.groupSelectionDropDownMenu != null) {
            this.groupSelectionDropDownMenu.m_87963_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280003_(guiGraphics, mouseX, mouseY);
        int health = Mth.m_14167_((float)this.recruit.m_21223_());
        int hunger = Mth.m_14167_((float)this.recruit.getHunger());
        int moral = Mth.m_14167_((float)this.recruit.getMorale());
        this.follow = this.recruit.getFollowState();
        this.aggro = this.recruit.getState();
        int k = 79;
        int l = 19;
        guiGraphics.m_280649_(this.f_96547_, this.recruit.m_5446_().m_7532_(), 8, 5, 0x404040, false);
        guiGraphics.m_280649_(this.f_96547_, this.playerInventory.m_5446_().m_7532_(), 8, this.f_97727_ - 96 + 2, 0x404040, false);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.7f, 0.7f, 1.0f);
        k = 112;
        l = 32;
        int gap = 42;
        guiGraphics.m_280056_(this.f_96547_, "Health:", k, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + health, k + gap, l, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Lvl.:", k, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getXpLevel(), k + gap, l + 10, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Exp.:", k, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getXp(), k + gap, l + 20, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Kills:", k, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + this.recruit.getKills(), k + gap, l + 30, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Morale:", k, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + moral, k + gap, l + 40, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "Hunger:", k, l + 50, 0x404040, false);
        guiGraphics.m_280056_(this.f_96547_, "" + hunger, k + gap, l + 50, 0x404040, false);
        guiGraphics.m_280168_().m_85849_();
        k = 79;
        l = 19;
        String follow = switch (this.follow) {
            case 0 -> TEXT_INFO_WANDER.getString();
            case 1 -> TEXT_INFO_FOLLOW.getString();
            case 2, 3, 4 -> TEXT_INFO_HOLD_POS.getString();
            case 5 -> TEXT_INFO_PROTECT.getString();
            case 6 -> TEXT_INFO_WORKING.getString();
            default -> throw new IllegalStateException("Unexpected value: " + this.follow);
        };
        guiGraphics.m_280056_(this.f_96547_, follow, k + 15, l + 58 + 0, 0x404040, false);
        String aggro = switch (this.aggro) {
            case 0 -> TEXT_INFO_NEUTRAL.getString();
            case 1 -> TEXT_INFO_AGGRESSIVE.getString();
            case 2 -> TEXT_INFO_RAID.getString();
            case 3 -> TEXT_INFO_PASSIVE.getString();
            default -> throw new IllegalStateException("Unexpected value: " + this.aggro);
        };
        int fnt = this.aggro == 3 ? 0xFF5555 : 0x404040;
        guiGraphics.m_280056_(this.f_96547_, aggro, k + 15, l + 56 + 15, fnt, false);
        String listen = this.recruit.getListen() ? TEXT_INFO_LISTEN.getString() : TEXT_INFO_IGNORE.getString();
        int fnt2 = this.recruit.getListen() ? 0x404040 : 0xFF5555;
        guiGraphics.m_280056_(this.f_96547_, listen, k + 15, l + 56 + 28, fnt2, false);
        ItemStack profItem1 = null;
        ItemStack profItem2 = null;
        if (this.recruit instanceof HorsemanEntity) {
            profItem1 = Items.f_42383_.m_7968_();
            profItem2 = Items.f_42450_.m_7968_();
        } else if (this.recruit instanceof NomadEntity) {
            profItem1 = Items.f_42411_.m_7968_();
            profItem2 = Items.f_42450_.m_7968_();
        } else if (this.recruit instanceof RecruitShieldmanEntity) {
            profItem1 = Items.f_42383_.m_7968_();
            profItem2 = Items.f_42740_.m_7968_();
        } else if (this.recruit instanceof RecruitEntity) {
            profItem1 = Items.f_42383_.m_7968_();
        } else if (this.recruit instanceof BowmanEntity) {
            profItem1 = Items.f_42411_.m_7968_();
        } else if (this.recruit instanceof CrossBowmanEntity) {
            profItem1 = Items.f_42717_.m_7968_();
        } else if (this.recruit instanceof MessengerEntity) {
            profItem1 = Items.f_42402_.m_7968_();
            profItem2 = Items.f_42516_.m_7968_();
        } else if (this.recruit instanceof PatrolLeaderEntity) {
            profItem1 = Items.f_42383_.m_7968_();
            profItem2 = Items.f_220219_.m_7968_();
        } else if (this.recruit instanceof CaptainEntity) {
            profItem1 = SmallShips.getSmallShipsItem();
        } else {
            RecruitInventoryScreen recruitInventoryScreen = this;
            if (recruitInventoryScreen instanceof IVillagerWorker) {
                IVillagerWorker worker = (IVillagerWorker)((Object)recruitInventoryScreen);
                profItem1 = worker.getCustomProfessionItem();
            }
        }
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(0.8f, 0.8f, 1.0f);
        if (profItem2 != null) {
            guiGraphics.m_280203_(profItem2, 90, 4);
        }
        if (profItem1 != null) {
            guiGraphics.m_280203_(profItem1, 80, 4);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    @Override
    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(guiGraphics, partialTicks, mouseX, mouseY);
        RenderSystem.clearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        InventoryScreen.m_274545_((GuiGraphics)guiGraphics, (int)(i + 50), (int)(j + 82), (int)30, (float)((float)(i + 50) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.recruit);
    }
}

