/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.group;

import com.mojang.blaze3d.systems.RenderSystem;
import com.talhanation.recruits.client.gui.group.RecruitsGroup;
import com.talhanation.recruits.client.gui.group.RecruitsGroupList;
import com.talhanation.recruits.client.gui.group.RecruitsGroupListScreen;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class EditOrAddGroupScreen
extends Screen {
    private static final int fontColor = 0x404040;
    private EditBox groupNameField;
    private final RecruitsGroupListScreen parent;
    private final RecruitsGroup groupToEdit;
    private int leftPos;
    private int topPos;
    private int imageWidth;
    private int imageHeight;
    private static final ResourceLocation RESOURCE_LOCATION = new ResourceLocation("recruits", "textures/gui/gui_small.png");
    private static final MutableComponent TEXT_CANCEL = Component.m_237115_((String)"gui.recruits.groups.cancel");
    private static final MutableComponent TEXT_SAVE = Component.m_237115_((String)"gui.recruits.groups.save");
    private static final MutableComponent TEXT_ADD = Component.m_237115_((String)"gui.recruits.groups.add");
    private static final MutableComponent TEXT_SPLIT = Component.m_237115_((String)"gui.recruits.groups.split");
    private static final MutableComponent TEXT_EDIT_TITLE = Component.m_237115_((String)"gui.recruits.groups.edit_title");
    private static final MutableComponent TEXT_ADD_TITLE = Component.m_237115_((String)"gui.recruits.groups.add_title");

    public EditOrAddGroupScreen(RecruitsGroupListScreen parent) {
        this(parent, null);
    }

    public EditOrAddGroupScreen(RecruitsGroupListScreen parent, RecruitsGroup groupToEdit) {
        super((Component)Component.m_237113_((String)""));
        this.parent = parent;
        this.groupToEdit = groupToEdit;
        this.imageWidth = 250;
        this.imageHeight = 83;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.groupNameField = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 20, 220, 20, (Component)Component.m_237113_((String)""));
        if (this.groupToEdit != null) {
            this.groupNameField.m_94144_(this.groupToEdit.getName());
        }
        this.m_142416_((GuiEventListener)this.groupNameField);
        this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 10, this.topPos + 55, 60, 20, (Component)(this.groupToEdit == null ? TEXT_ADD : TEXT_SAVE), button -> {
            if (this.groupToEdit == null) {
                this.addGroup();
            } else {
                this.editGroup();
            }
        }));
        this.m_142416_((GuiEventListener)new ExtendedButton(this.leftPos + 170, this.topPos + 55, 60, 20, (Component)TEXT_CANCEL, button -> this.f_96541_.m_91152_((Screen)this.parent)));
    }

    private void addGroup() {
        String groupName = this.groupNameField.m_94155_();
        if (!groupName.isEmpty()) {
            int newId = this.getNewID(RecruitsGroupList.groups);
            RecruitsGroup newGroup = new RecruitsGroup(newId, groupName, false);
            RecruitsGroupList.groups.add(newGroup);
            RecruitsGroupList.saveGroups(false);
            this.f_96541_.m_91152_((Screen)this.parent);
        }
    }

    private int getNewID(List<RecruitsGroup> groups) {
        int newId = 0;
        for (RecruitsGroup group : groups) {
            if (group.getId() <= newId) continue;
            newId = group.getId();
        }
        return newId + 1;
    }

    private void editGroup() {
        String newName = this.groupNameField.m_94155_();
        if (!newName.isEmpty() && this.groupToEdit != null) {
            RecruitsGroup copy = this.groupToEdit;
            RecruitsGroupList.groups.remove(this.groupToEdit);
            copy.setName(newName);
            RecruitsGroupList.groups.add(copy);
            RecruitsGroupList.saveGroups(false);
            this.f_96541_.m_91152_((Screen)this.parent);
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.groupNameField.m_94120_();
    }

    private void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280614_(this.f_96547_, (Component)(this.groupToEdit == null ? TEXT_ADD_TITLE : TEXT_EDIT_TITLE), this.leftPos + 10, this.topPos + 5, 0x404040, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(RESOURCE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.m_88315_(guiGraphics, mouseX, mouseY, delta);
        this.renderForeground(guiGraphics, mouseX, mouseY, delta);
    }

    public boolean m_7043_() {
        return false;
    }
}

