/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class ScrollDropDownMenu<T>
extends AbstractWidget {
    private int bgFill = FastColor.ARGB32.m_13660_((int)255, (int)60, (int)60, (int)60);
    private int bgFillHovered = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    private int bgFillSelected = FastColor.ARGB32.m_13660_((int)255, (int)10, (int)10, (int)10);
    private int displayColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private int optionTextColor = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    private int scrollbarColor = FastColor.ARGB32.m_13660_((int)255, (int)100, (int)100, (int)100);
    private int scrollbarHandleColor = FastColor.ARGB32.m_13660_((int)255, (int)150, (int)150, (int)150);
    private final List<T> options;
    private final Consumer<T> onSelect;
    private final Function<T, String> optionTextGetter;
    private T selectedOption;
    private boolean isOpen;
    private final int optionHeight;
    private int scrollOffset = 0;
    private int maxVisibleOptions;
    private boolean isScrolling = false;
    private int scrollbarWidth = 6;
    private int scrollbarHandleHeight;

    public ScrollDropDownMenu(T selectedOption, int x, int y, int width, int height, List<T> options, Function<T, String> optionTextGetter, Consumer<T> onSelect) {
        super(x, y, width, height, (Component)Component.m_237113_((String)""));
        this.selectedOption = selectedOption;
        this.options = options;
        this.onSelect = onSelect;
        this.optionTextGetter = optionTextGetter;
        this.optionHeight = height;
        this.maxVisibleOptions = Math.min(5, options.size());
        this.scrollbarHandleHeight = Math.max(10, (int)((float)this.maxVisibleOptions / (float)options.size() * (float)(height * this.maxVisibleOptions)));
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (!this.f_93624_) {
            return;
        }
        if (this.isMouseOverDisplay(mouseX, mouseY)) {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.bgFillHovered);
        } else {
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, this.bgFillSelected);
        }
        guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, this.getSelectedText(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, this.displayColor);
        if (this.isOpen) {
            int dropdownHeight = this.maxVisibleOptions * this.optionHeight;
            guiGraphics.m_280509_(this.m_252754_(), this.m_252907_() + this.f_93619_, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_ + dropdownHeight, this.bgFill);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
            RenderSystem.enableScissor((int)((int)((double)this.m_252754_() * Minecraft.m_91087_().m_91268_().m_85449_())), (int)((int)((double)Minecraft.m_91087_().m_91268_().m_85442_() - (double)(this.m_252907_() + this.f_93619_ + dropdownHeight) * Minecraft.m_91087_().m_91268_().m_85449_())), (int)((int)((double)this.f_93618_ * Minecraft.m_91087_().m_91268_().m_85449_())), (int)((int)((double)dropdownHeight * Minecraft.m_91087_().m_91268_().m_85449_())));
            for (int i = 0; i < this.options.size(); ++i) {
                int optionY = this.m_252907_() + this.f_93619_ + (i - this.scrollOffset) * this.optionHeight;
                if (this.isMouseOverOption(mouseX, mouseY, optionY)) {
                    guiGraphics.m_280509_(this.m_252754_(), optionY, this.m_252754_() + this.f_93618_, optionY + this.optionHeight, this.bgFillHovered);
                } else {
                    guiGraphics.m_280509_(this.m_252754_(), optionY, this.m_252754_() + this.f_93618_, optionY + this.optionHeight, this.bgFill);
                }
                String text = this.optionTextGetter.apply(this.options.get(i));
                guiGraphics.m_280137_(Minecraft.m_91087_().f_91062_, text, this.m_252754_() + this.f_93618_ / 2, optionY + (this.optionHeight - 8) / 2, this.optionTextColor);
            }
            RenderSystem.disableScissor();
            if (this.options.size() > this.maxVisibleOptions) {
                int scrollbarX = this.m_252754_() + this.f_93618_ - this.scrollbarWidth;
                int scrollbarY = this.m_252907_() + this.f_93619_ + (int)((float)this.scrollOffset / (float)this.options.size() * (float)dropdownHeight);
                int scrollbarHeight = (int)((float)this.maxVisibleOptions / (float)this.options.size() * (float)dropdownHeight);
                guiGraphics.m_280509_(scrollbarX, this.m_252907_() + this.f_93619_, scrollbarX + this.scrollbarWidth, this.m_252907_() + this.f_93619_ + dropdownHeight, this.scrollbarColor);
                guiGraphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + this.scrollbarWidth, scrollbarY + scrollbarHeight, this.scrollbarHandleColor);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void m_5716_(double mouseX, double mouseY) {
    }

    public void onMouseClick(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return;
        }
        if (this.isOpen) {
            if (this.isMouseOverScrollbar((int)mouseX, (int)mouseY)) {
                this.isScrolling = true;
                return;
            }
            for (int i = 0; i < this.options.size(); ++i) {
                int optionY = this.m_252907_() + this.f_93619_ + (i - this.scrollOffset) * this.optionHeight;
                if (!this.isMouseOverOption((int)mouseX, (int)mouseY, optionY)) continue;
                this.selectOption(this.options.get(i));
                return;
            }
        }
        this.isOpen = this.isMouseOverDisplay((int)mouseX, (int)mouseY) ? !this.isOpen : false;
    }

    public void onMouseMove(double mouseX, double mouseY) {
        if (!this.f_93624_) {
            return;
        }
        if (this.isOpen) {
            boolean isOverDropdown = this.isMouseOverDropdown((int)mouseX, (int)mouseY);
            boolean isOverDisplay = this.isMouseOverDisplay((int)mouseX, (int)mouseY);
            if (!isOverDropdown && !isOverDisplay) {
                this.isOpen = false;
            }
        }
        if (this.isScrolling) {
            int dropdownHeight = this.maxVisibleOptions * this.optionHeight;
            int scrollbarY = (int)mouseY - (this.m_252907_() + this.f_93619_);
            this.scrollOffset = (int)((float)scrollbarY / (float)dropdownHeight * (float)this.options.size());
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.options.size() - this.maxVisibleOptions));
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        if (this.isOpen) {
            this.scrollOffset -= (int)delta;
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.options.size() - this.maxVisibleOptions));
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (!this.f_93624_) {
            return false;
        }
        if (this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return false;
    }

    private boolean isMouseOverScrollbar(int mouseX, int mouseY) {
        if (!this.isOpen || this.options.size() <= this.maxVisibleOptions) {
            return false;
        }
        int scrollbarX = this.m_252754_() + this.f_93618_ - this.scrollbarWidth;
        int scrollbarY = this.m_252907_() + this.f_93619_;
        int scrollbarHeight = this.maxVisibleOptions * this.optionHeight;
        return mouseX >= scrollbarX && mouseX <= scrollbarX + this.scrollbarWidth && mouseY >= scrollbarY && mouseY <= scrollbarY + scrollbarHeight;
    }

    private boolean isMouseOverDisplay(int mouseX, int mouseY) {
        return mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY <= this.m_252907_() + this.f_93619_;
    }

    private boolean isMouseOverDropdown(int mouseX, int mouseY) {
        if (!this.isOpen) {
            return false;
        }
        int dropdownStartX = this.m_252754_();
        int dropdownStartY = this.m_252907_() + this.f_93619_;
        int dropdownEndX = dropdownStartX + this.f_93618_;
        int dropdownEndY = dropdownStartY + this.maxVisibleOptions * this.optionHeight;
        return mouseX >= dropdownStartX && mouseX <= dropdownEndX && mouseY >= dropdownStartY && mouseY <= dropdownEndY;
    }

    private boolean isMouseOverOption(int mouseX, int mouseY, int optionY) {
        return mouseX >= this.m_252754_() && mouseX <= this.m_252754_() + this.f_93618_ && mouseY >= optionY && mouseY <= optionY + this.optionHeight;
    }

    public boolean m_5953_(double x, double y) {
        return this.isMouseOverDisplay((int)x, (int)y) || this.isMouseOverDropdown((int)x, (int)y) || this.isMouseOverScrollbar((int)x, (int)y) || super.m_5953_(x, y);
    }

    protected void m_168797_(NarrationElementOutput p_259858_) {
    }

    private void selectOption(T option) {
        this.selectedOption = option;
        this.onSelect.accept(option);
        this.isOpen = false;
    }

    private String getSelectedText() {
        return this.selectedOption != null ? this.optionTextGetter.apply(this.selectedOption) : "";
    }

    public void setBgFill(int bgFill) {
        this.bgFill = bgFill;
    }

    public void setBgFillHovered(int bgFillHovered) {
        this.bgFillHovered = bgFillHovered;
    }

    public void setBgFillSelected(int bgFillSelected) {
        this.bgFillSelected = bgFillSelected;
    }

    public void setDisplayColor(int displayColor) {
        this.displayColor = displayColor;
    }

    public void setOptionTextColor(int optionTextColor) {
        this.optionTextColor = optionTextColor;
    }
}

