/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.controller;

import com.talhanation.recruits.entities.AbstractLeaderEntity;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.ai.controller.IAttackController;
import com.talhanation.recruits.util.FormationUtils;
import com.talhanation.recruits.util.NPCArmy;
import com.talhanation.recruits.util.RecruitCommanderUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class PatrolLeaderAttackController
implements IAttackController {
    public final AbstractLeaderEntity leader;
    public int timeOut = 1000;
    public Vec3 initPos;

    public PatrolLeaderAttackController(AbstractLeaderEntity recruit) {
        this.leader = recruit;
    }

    public void start() {
        if (!this.leader.m_20193_().m_5776_() && this.leader.enemyArmy != null && this.leader.army != null) {
            double distanceToTarget = this.leader.army.getPosition().m_82557_(this.leader.enemyArmy.getPosition());
            this.leader.army.updateArmy();
            this.leader.enemyArmy.updateArmy();
            if (this.leader.enemyArmy.size() == 0) {
                this.leader.enemyArmy = null;
                return;
            }
            if (this.initPos != null && this.initPos.m_82557_(this.leader.army.getPosition()) > 5000.0) {
                this.leader.enemyArmy = null;
                return;
            }
            RecruitCommanderUtil.setRecruitsAggroState(this.leader.army.getAllRecruitUnits(), this.leader.getState());
            RecruitCommanderUtil.setRecruitsMoveSpeed(this.leader.army.getAllRecruitUnits(), 1.0f);
            this.setRecruitsTargets();
            if (distanceToTarget < 2500.0) {
                if (this.isArmyScattered()) {
                    this.regroupArmy();
                    return;
                }
                this.leader.commandCooldown = 400;
                this.commandArmy(this.leader.army, this.leader.enemyArmy);
            } else {
                if (this.leader.getOwner() != null) {
                    this.leader.getOwner().m_213846_((Component)Component.m_237113_((String)(this.leader.m_7755_().getString() + ": Enemy contact! Im advancing, their size is " + this.leader.enemyArmy.size())));
                }
                this.forwarding();
                this.leader.commandCooldown = 250;
            }
        }
    }

    @Override
    public void tick() {
        if (this.leader.commandCooldown == 0) {
            this.leader.commandCooldown = 400;
            this.start();
        }
    }

    @Override
    public void setInitPos(Vec3 pos) {
        this.initPos = pos;
    }

    @Override
    public boolean isTargetInRange() {
        return false;
    }

    private boolean isArmyScattered() {
        List<AbstractRecruitEntity> recruits = this.leader.army.getAllRecruitUnits();
        if (recruits.isEmpty()) {
            return false;
        }
        Vec3 commanderPos = this.leader.m_20182_();
        double maxDistance = 500.0;
        int scatteredCount = 0;
        for (AbstractRecruitEntity recruit : recruits) {
            double distance = recruit.m_20182_().m_82557_(commanderPos);
            if (!(distance > maxDistance)) continue;
            ++scatteredCount;
        }
        return scatteredCount >= recruits.size() / 2;
    }

    public void commandArmy(NPCArmy playerArmy, NPCArmy enemyArmy) {
        double distance = playerArmy.getPosition().m_82554_(enemyArmy.getPosition());
        int ownArmySize = playerArmy.getTotalUnits();
        int enemyArmySize = enemyArmy.getTotalUnits();
        double ownMorale = playerArmy.getAverageMorale();
        double enemyMorale = enemyArmy.getAverageMorale();
        int ownRangedUnits = playerArmy.getRanged().size();
        int enemyRangedUnits = enemyArmy.getRanged().size();
        int ownCavalry = playerArmy.getCavalry().size();
        int enemyCavalry = enemyArmy.getCavalry().size();
        int ownShieldmen = playerArmy.getShieldmen().size();
        int enemyShieldmen = enemyArmy.getShieldmen().size();
        double ownAverageHealth = playerArmy.getAverageHealth();
        double enemyAverageHealth = enemyArmy.getAverageHealth();
        if (ownArmySize >= 2 * enemyArmySize || ownAverageHealth > 50.0) {
            this.sendToOwner("We have overwhelming advantage! Charging!");
            if (distance < 1000.0) {
                this.charge();
            } else {
                this.forwarding();
            }
        } else if (ownMorale > 70.0 && enemyMorale < 30.0) {
            this.sendToOwner("We have a morale advantage! Advancing!");
            this.forwarding();
        } else if (enemyArmySize >= 2 * ownArmySize || ownMorale < 20.0 || enemyAverageHealth > 50.0) {
            this.sendToOwner("We are at a disadvantage! Retreating!");
            this.back();
        } else if (enemyRangedUnits > ownCavalry + ownShieldmen) {
            this.sendToOwner("Enemy has ranged superiority! Need assistance!");
            this.back();
        } else {
            this.sendToOwner("Default attacking!");
            if (distance < 1000.0) {
                this.defaultAttack();
            } else {
                this.forwarding();
            }
        }
        if (distance < 200.0) {
            RecruitCommanderUtil.setRecruitsShields(this.leader.army.getRecruitShieldmen(), false);
        } else if (enemyRangedUnits >= ownShieldmen) {
            RecruitCommanderUtil.setRecruitsShields(this.leader.army.getRecruitShieldmen(), true);
        }
    }

    public void shieldWall() {
        Vec3 target = this.leader.enemyArmy.getPosition();
        Vec3 toTarget = this.leader.m_20182_().m_82505_(target).m_82541_();
        Vec3 movePosInfantry = this.getPosTowardsTarget(target, 0.05);
        Vec3 movePosRanged = this.getPosTowardsTarget(target, -0.1);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitShieldmen(), movePosInfantry, 30, 1.0);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitInfantry(), movePosInfantry, 30, 1.0);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitRanged(), movePosRanged, 20, 1.8);
        RecruitCommanderUtil.setRecruitsWanderFreely(this.leader.army.getRecruitCavalry());
    }

    public void charge() {
        BlockPos movePosLeader = this.getBlockPosTowardsTarget(this.leader.enemyArmy.getPosition(), 0.2);
        this.leader.setHoldPos(Vec3.m_82512_((Vec3i)movePosLeader));
        this.leader.setFollowState(3);
        RecruitCommanderUtil.setRecruitsWanderFreely(this.leader.army.getAllRecruitUnits());
        this.setRecruitsTargets();
    }

    public void defaultAttack() {
        Vec3 target = this.leader.enemyArmy.getPosition();
        Vec3 toTarget = this.leader.m_20182_().m_82505_(target).m_82541_();
        Vec3 movePosRanged = this.getPosTowardsTarget(target, 0.4);
        BlockPos movePosLeader = this.getBlockPosTowardsTarget(target, 0.2);
        Vec3 movePosInfantry = this.getPosTowardsTarget(target, 0.6);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitInfantry(), movePosInfantry, 20, 3.25);
        RecruitCommanderUtil.setRecruitsWanderFreely(this.leader.army.getRecruitShieldmen());
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitRanged(), movePosRanged, 20, 3.25);
        RecruitCommanderUtil.setRecruitsWanderFreely(this.leader.army.getRecruitCavalry());
        this.setRecruitsTargets();
        this.leader.setHoldPos(Vec3.m_82512_((Vec3i)movePosLeader));
        this.leader.setFollowState(3);
    }

    public void regroupArmy() {
        this.sendToOwner("Recruits regroup!");
        Vec3 target = this.leader.enemyArmy.getPosition();
        Vec3 toTarget = this.leader.m_20182_().m_82505_(target).m_82541_();
        Vec3 movePosInfantry = this.getPosTowardsTarget(target, 0.1);
        Vec3 movePosRanged = this.getPosTowardsTarget(target, -0.1);
        Vec3 movePosCav = this.getPosTowardsTarget(target, 0.0);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitInfantry(), movePosInfantry, 20, 1.75);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitShieldmen(), movePosInfantry, 10, 2.25);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitRanged(), movePosRanged, 20, 3.0);
        FormationUtils.squareFormation(toTarget, this.leader.army.getRecruitCavalry(), movePosCav, 2.0);
    }

    public void forwarding() {
        Vec3 target = this.leader.enemyArmy.getPosition();
        Vec3 toTarget = this.leader.m_20182_().m_82505_(target).m_82541_();
        Vec3 movePosInfantry = this.getPosTowardsTarget(target, 0.6);
        Vec3 movePosRanged = this.getPosTowardsTarget(target, 0.4);
        Vec3 movePosCav = this.getPosTowardsTarget(target, 0.2);
        BlockPos movePosLeader = this.getBlockPosTowardsTarget(target, 0.3);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitInfantry(), movePosInfantry, 20, 1.75);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitShieldmen(), movePosInfantry, 10, 2.25);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitRanged(), movePosRanged, 20, 3.0);
        FormationUtils.squareFormation(toTarget, this.leader.army.getRecruitCavalry(), movePosCav, 2.0);
        this.leader.setHoldPos(Vec3.m_82512_((Vec3i)movePosLeader));
        this.leader.setFollowState(3);
    }

    public void back() {
        Vec3 target = this.leader.enemyArmy.getPosition();
        Vec3 toTarget = this.leader.m_20182_().m_82505_(target).m_82541_();
        Vec3 movePosInfantry = this.getPosTowardsTarget(target, -0.4);
        Vec3 movePosRanged = this.getPosTowardsTarget(target, -0.6);
        BlockPos movePosLeader = this.getBlockPosTowardsTarget(target, -0.7);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitInfantry(), movePosInfantry, 20, 1.25);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitShieldmen(), movePosInfantry, 20, 1.25);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitRanged(), movePosRanged, 20, 2.25);
        FormationUtils.lineFormation(toTarget, this.leader.army.getRecruitCavalry(), movePosRanged, 20, 2.25);
        this.leader.setHoldPos(Vec3.m_82512_((Vec3i)movePosLeader));
        this.leader.setFollowState(3);
    }

    public BlockPos getBlockPosTowardsTarget(Vec3 target, double x) {
        Vec3 pos = this.leader.m_20182_().m_165921_(target, x);
        return FormationUtils.getPositionOrSurface(this.leader.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
    }

    public Vec3 getPosTowardsTarget(Vec3 target, double x) {
        return this.leader.m_20182_().m_165921_(target, x);
    }

    public void setRecruitsTargets() {
        for (int i = 0; i < this.leader.army.getAllRecruitUnits().size(); ++i) {
            AbstractRecruitEntity recruit = this.leader.army.getAllRecruitUnits().get(i);
            if (this.leader.enemyArmy.size() <= i) continue;
            recruit.m_6710_(this.leader.enemyArmy.getAllUnits().get(i));
        }
    }

    public boolean canAttack(LivingEntity living) {
        int aggroState = this.leader.getState();
        switch (aggroState) {
            case 0: {
                if (!(living instanceof Monster)) break;
                return this.leader.m_6779_(living);
            }
            case 1: {
                if (!(living instanceof Player) && !(living instanceof AbstractRecruitEntity) && !(living instanceof Monster)) break;
                return this.leader.m_6779_(living);
            }
            case 2: {
                return this.leader.m_6779_(living);
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public void sendToOwner(String string) {
        if (this.leader.getOwner() != null) {
            this.leader.getOwner().m_213846_((Component)Component.m_237113_((String)(this.leader.m_7755_().getString() + ": " + string)));
        }
    }
}

