/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.entities.ai.controller;

import com.talhanation.recruits.compat.SmallShips;
import com.talhanation.recruits.entities.CaptainEntity;
import com.talhanation.recruits.entities.ai.navigation.SailorPathNavigation;
import com.talhanation.recruits.util.Kalkuel;
import com.talhanation.recruits.util.WaterObstacleScanner;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class SmallShipsController {
    public static final boolean DEBUG = false;
    public static final int REACH = 115;
    public static final int RECALCULATION_TIME = 300;
    private Path path;
    private final Level world;
    private final SailorPathNavigation pathNavigation;
    private final CaptainEntity captain;
    public SmallShips ship;
    private int recalcPath;
    private Node currentNode;
    public double distanceToSailPos;
    public WaterObstacleScanner waterObstacleScanner;
    private int sailState;
    public boolean right;
    public boolean left;
    public double reach;
    public Entity target;
    private final int attackRange = 4500;
    private final int followRange = 600;
    public double distanceToTarget;

    public SmallShipsController(CaptainEntity captain, Level world) {
        this.pathNavigation = new SailorPathNavigation(captain, world);
        this.world = world;
        this.captain = captain;
    }

    public void tryMountShip(Entity entity) {
        Boat boat;
        if (entity instanceof Boat && SmallShips.isSmallShip((Entity)(boat = (Boat)entity))) {
            this.ship = new SmallShips(boat, this.captain);
        }
    }

    public void tryDisMountShip() {
        Boat boat;
        Entity entity = this.captain.m_20202_();
        if (entity instanceof Boat && SmallShips.isSmallShip((Entity)(boat = (Boat)entity))) {
            this.ship = null;
        }
        this.waterObstacleScanner = null;
    }

    public void calculatePath() {
        this.recalcPath = 0;
    }

    public void tick() {
        double distanceToNode;
        if (this.world.m_5776_() || this.captain.m_9236_().m_5776_()) {
            return;
        }
        if (this.captain.m_20202_() == null || this.captain.getSailPos() == null || this.ship == null) {
            return;
        }
        if (!this.ship.isCaptainDriver()) {
            return;
        }
        if (this.updateAttacking()) {
            return;
        }
        BlockPos sailPos = this.captain.getSailPos();
        this.distanceToSailPos = this.captain.m_20275_(sailPos.m_123341_(), this.captain.m_20186_(), sailPos.m_123343_());
        double d = this.reach = this.captain.getFollowState() == 1 || this.captain.getFollowState() == 5 ? 230.0 : 115.0;
        if (this.distanceToSailPos < this.reach || this.captain.attackController.isTargetInRange()) {
            this.currentNode = null;
            this.path = null;
            this.ship.setSailState(0);
            return;
        }
        if (this.currentNode != null) {
            Vec3 forward = this.ship.getBoat().m_20156_().m_82524_(-90.0f).m_82541_();
            Vec3 target = new Vec3((double)this.currentNode.f_77271_, 0.0, (double)this.currentNode.f_77273_);
            Vec3 toTarget = target.m_82546_(this.ship.getBoat().m_20182_()).m_82541_();
            double phi = Kalkuel.horizontalAngleBetweenVectors(forward, toTarget);
            double ref = 63.334f;
            double stopThreshold = ref * (double)0.8f;
            if (Math.abs(phi) < stopThreshold) {
                this.left = phi < ref;
                this.right = phi > ref;
                this.ship.updateSmallShipsControl(this.right, this.left, 0);
                return;
            }
        }
        if (this.path != null && this.currentNode != null && (distanceToNode = this.captain.m_20202_().m_20275_((double)this.currentNode.f_77271_, this.captain.m_20202_().m_20186_(), (double)this.currentNode.f_77273_)) < this.reach) {
            this.calculatePath();
        }
        if (this.waterObstacleScanner != null) {
            int obstaclesLeft = this.waterObstacleScanner.getObstaclesLeft();
            int obstaclesRight = this.waterObstacleScanner.getObstaclesRight();
            int obstaclesFront = this.waterObstacleScanner.getObstaclesFront(10);
            if (obstaclesRight != 0 || obstaclesLeft != 0) {
                if (obstaclesLeft < obstaclesRight) {
                    this.right = true;
                    this.left = false;
                    this.sailState = 2;
                } else if (obstaclesLeft > obstaclesRight) {
                    this.right = false;
                    this.left = true;
                    this.sailState = 2;
                } else if (obstaclesFront > 0) {
                    this.sailState = 0;
                    this.right = true;
                    this.left = false;
                } else {
                    this.right = false;
                    this.left = false;
                }
                this.ship.updateSmallShipsControl(this.right, this.left, this.sailState);
                return;
            }
            if ((this.captain.getFollowState() == 1 || this.captain.getFollowState() == 5) && obstaclesFront <= 0) {
                if (this.distanceToSailPos < 500.0) {
                    this.ship.setSailState(2);
                } else {
                    this.ship.setSailState(4);
                }
                this.ship.updateSmallShipsControl(this.captain.getSailPos().m_123341_(), this.captain.getSailPos().m_123343_(), this.sailState);
                return;
            }
            if (--this.recalcPath <= 0) {
                this.recalcPath = 300;
                this.path = this.pathNavigation.createPath(this.captain.getSailPos(), 32, false, 0);
                if (this.path != null) {
                    try {
                        this.currentNode = this.path.m_77395_();
                    }
                    catch (IndexOutOfBoundsException e) {
                        this.currentNode = (Node)this.path.f_77362_.get(this.path.f_77362_.size() - 1);
                    }
                    this.sailState = 4;
                    this.reach = 115.0;
                }
            }
            if (this.path != null) {
                // empty if block
            }
            if (this.path != null && this.currentNode != null) {
                double distanceToNode2 = this.captain.m_20202_().m_20275_((double)this.currentNode.f_77271_, this.captain.m_20202_().m_20186_(), (double)this.currentNode.f_77273_);
                if (distanceToNode2 < this.reach) {
                    this.calculatePath();
                }
                this.ship.updateSmallShipsControl(this.currentNode.f_77271_, this.currentNode.f_77273_, this.sailState);
            }
        } else {
            this.waterObstacleScanner = new WaterObstacleScanner(this.captain.m_20193_(), (Entity)this.ship.getBoat());
        }
    }

    private boolean updateAttacking() {
        if (this.target == null || !this.target.m_6084_() || this.target.m_5842_() || this.ship.getBoat().m_20197_().contains(this.target) || !this.captain.m_21574_().m_148306_(this.target)) {
            if (this.captain.f_19797_ % 20 == 0) {
                this.checkForNextTarget();
            }
            return false;
        }
        this.distanceToTarget = this.enemyDistanceToLeader(this.target);
        if (this.distanceToTarget > 4500.0) {
            return false;
        }
        if (this.isTooFarFromMovementRange()) {
            this.target = null;
            this.captain.commandCooldown = 100;
            return false;
        }
        if (this.ship.canShootCannons() && this.rotateAndCheckAngle()) {
            this.shootCannons();
        }
        return true;
    }

    public boolean checkForNextTarget() {
        if (this.captain.enemyArmy == null || this.captain.enemyArmy.ships == null || this.captain.enemyArmy.getAllUnits() == null) {
            return false;
        }
        if (this.captain.enemyArmy.ships.size() > 0) {
            this.captain.enemyArmy.ships.sort(Comparator.comparing(this::enemyDistanceToLeader));
            this.target = (Entity)this.captain.enemyArmy.ships.get(0);
            if (this.captain.getOwner() != null) {
                this.captain.getOwner().m_213846_((Component)Component.m_237113_((String)(this.captain.m_7755_().getString() + ": Enemy Ship in contact, im counting " + this.captain.enemyArmy.ships + "!")));
            }
        } else if (this.captain.enemyArmy.getAllUnits().size() > 0) {
            this.captain.enemyArmy.ships.sort(Comparator.comparing(this::enemyDistanceToLeader));
            this.target = (Entity)this.captain.enemyArmy.getAllUnits().get(0);
            if (this.captain.getOwner() != null) {
                this.captain.getOwner().m_213846_((Component)Component.m_237113_((String)(this.captain.m_7755_().getString() + ": Enemies in contact, im counting " + this.captain.enemyArmy.getAllUnits().size() + "!")));
            }
        } else {
            this.captain.enemyArmy = null;
            this.target = null;
            return false;
        }
        return true;
    }

    public boolean shouldGetInRange() {
        return this.ship.canShootCannons() && this.ship.getDamage() < 70.0f && this.captain.getFollowState() == 0 && !this.captain.getShouldMovePos();
    }

    private boolean isTooFarFromMovementRange() {
        Vec3 boatPos = this.ship.getBoat().m_20182_();
        int movementState = this.captain.getFollowState();
        switch (movementState) {
            case 0: {
                BlockPos movePos = this.captain.getMovePos();
                return this.captain.getShouldMovePos() && movePos != null && movePos.m_252807_().m_82557_(boatPos) > 300.0;
            }
            case 1: {
                Player owner = this.captain.getOwner();
                return owner != null && owner.m_20238_(boatPos) > 600.0;
            }
            case 2: {
                Vec3 holdPos = this.captain.getHoldPos();
                return holdPos != null && holdPos.m_82557_(boatPos) > 300.0;
            }
            case 5: {
                LivingEntity protect = this.captain.getProtectingMob();
                return protect != null && this.captain.getShouldProtect() && protect.m_20238_(boatPos) > 600.0;
            }
        }
        return false;
    }

    private boolean rotateAndCheckAngle() {
        if (this.target == null || !this.target.m_6084_() || this.target.m_5842_() || this.captain.smallShipsController.ship.getBoat().m_20197_().contains(this.target)) {
            this.target = null;
            this.captain.commandCooldown = 0;
            return false;
        }
        Vec3 forward = this.captain.smallShipsController.ship.getBoat().m_20156_().m_82541_();
        double offsetDistance = this.captain.smallShipsController.ship.isGalley() ? 2.0 : 0.0;
        Vec3 cannonPosition = this.captain.smallShipsController.ship.getBoat().m_20182_().m_82549_(forward.m_82490_(offsetDistance));
        Vec3 toTarget = cannonPosition.m_82505_(this.target.m_20182_());
        Vec3 vecRight = forward.m_82524_(-1.57f).m_82541_();
        Vec3 vecLeft = forward.m_82524_(1.57f).m_82541_();
        double distanceToLeft = toTarget.m_82554_(vecLeft);
        double distanceToRight = toTarget.m_82554_(vecRight);
        boolean shootLeftSide = distanceToLeft < distanceToRight;
        double alpha = Kalkuel.horizontalAngleBetweenVectors(forward, toTarget);
        double phi = shootLeftSide ? -alpha : alpha;
        double ref = shootLeftSide ? -90.0 : 90.0;
        boolean inputLeft = phi < ref;
        boolean inputRight = phi > ref;
        this.captain.smallShipsController.ship.rotateShip(inputLeft, inputRight);
        double beta = shootLeftSide ? Kalkuel.horizontalAngleBetweenVectors(forward.m_82524_(1.57f), toTarget) : Kalkuel.horizontalAngleBetweenVectors(forward.m_82524_(-1.57f), toTarget);
        return beta < 15.0;
    }

    private void shootCannons() {
        if (this.captain.smallShipsController.ship.canShootCannons() && this.captain.getShouldRanged() && this.captain.getState() != 3) {
            double beta;
            double distanceToRight;
            if (!this.target.m_6084_()) {
                this.target = null;
                return;
            }
            Vec3 toTarget = this.captain.smallShipsController.ship.getBoat().m_20182_().m_82505_(this.target.m_20182_());
            Vec3 forward = this.captain.smallShipsController.ship.getBoat().m_20156_().m_82541_();
            Vec3 VecRight = forward.m_82524_(-1.57f).m_82541_();
            Vec3 VecLeft = forward.m_82524_(1.57f).m_82541_();
            double distanceToLeft = toTarget.m_82554_(VecLeft);
            boolean shootLeftSide = distanceToLeft < (distanceToRight = toTarget.m_82554_(VecRight));
            double alpha = Kalkuel.horizontalAngleBetweenVectors(forward, toTarget);
            double phi = shootLeftSide ? -alpha : alpha;
            double ref = shootLeftSide ? -90.0 : 90.0;
            boolean inputLeft = phi < ref;
            boolean inputRight = phi > ref;
            this.captain.smallShipsController.ship.rotateShip(inputLeft, inputRight);
            double d = beta = shootLeftSide ? Kalkuel.horizontalAngleBetweenVectors(forward.m_82524_(1.57f), toTarget) : Kalkuel.horizontalAngleBetweenVectors(forward.m_82524_(-1.57f), toTarget);
            if (beta < 15.0) {
                SmallShips.shootCannonsSmallShip(this.captain, (Boat)this.captain.m_20202_(), this.target, shootLeftSide);
            }
        }
    }

    public double enemyDistanceToLeader(Entity entity) {
        return entity.m_20238_(this.captain.m_20182_());
    }
}

