/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.TeamEvents;
import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageAssignGroupToTeamMate
implements Message<MessageAssignGroupToTeamMate> {
    private UUID owner;
    private UUID newOwner;
    private UUID recruit;

    public MessageAssignGroupToTeamMate() {
    }

    public MessageAssignGroupToTeamMate(UUID owner, UUID newOwner, UUID recruit) {
        this.owner = owner;
        this.newOwner = newOwner;
        this.recruit = recruit;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer serverPlayer = Objects.requireNonNull(context.getSender());
        List list = serverPlayer.m_20193_().m_6443_(AbstractRecruitEntity.class, context.getSender().m_20191_().m_82400_(100.0), recruit -> recruit.getOwnerUUID() != null && recruit.getOwnerUUID().equals(this.owner));
        int group = -1;
        for (AbstractRecruitEntity recruit1 : list) {
            if (!recruit1.m_20148_().equals(this.recruit)) continue;
            group = recruit1.getGroup();
            break;
        }
        for (AbstractRecruitEntity recruit2 : list) {
            UUID recruitOwner = recruit2.getOwnerUUID();
            if (recruitOwner == null || !recruitOwner.equals(this.owner) || recruit2.getGroup() != group) continue;
            TeamEvents.assignToTeamMate(serverPlayer, this.newOwner, recruit2);
        }
    }

    @Override
    public MessageAssignGroupToTeamMate fromBytes(FriendlyByteBuf buf) {
        this.owner = buf.m_130259_();
        this.newOwner = buf.m_130259_();
        this.recruit = buf.m_130259_();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.owner);
        buf.m_130077_(this.newOwner);
        buf.m_130077_(this.recruit);
    }
}

