/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageDisbandGroup
implements Message<MessageDisbandGroup> {
    private UUID owner;
    private UUID recruit;
    private boolean keepTeam;

    public MessageDisbandGroup() {
    }

    public MessageDisbandGroup(UUID owner, UUID recruit, boolean keepTeam) {
        this.owner = owner;
        this.recruit = recruit;
        this.keepTeam = keepTeam;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public void executeServerSide(NetworkEvent.Context context) {
        ServerPlayer player = Objects.requireNonNull(context.getSender());
        List list = player.m_20193_().m_45976_(AbstractRecruitEntity.class, player.m_20191_().m_82400_(100.0));
        int group = -1;
        for (AbstractRecruitEntity recruit1 : list) {
            if (!recruit1.m_20148_().equals(this.recruit)) continue;
            group = recruit1.getGroup();
            break;
        }
        if (group == -1) {
            return;
        }
        for (AbstractRecruitEntity recruit : list) {
            if (!this.owner.equals(recruit.getOwnerUUID()) || recruit.getGroup() != group) continue;
            recruit.disband((Player)context.getSender(), this.keepTeam, true);
        }
    }

    @Override
    public MessageDisbandGroup fromBytes(FriendlyByteBuf buf) {
        this.owner = buf.m_130259_();
        this.recruit = buf.m_130259_();
        this.keepTeam = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.owner);
        buf.m_130077_(this.recruit);
        buf.writeBoolean(this.keepTeam);
    }
}

