/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.network;

import com.talhanation.recruits.client.gui.player.PlayersList;
import com.talhanation.recruits.client.gui.team.TeamInspectionScreen;
import com.talhanation.recruits.world.RecruitsPlayerInfo;
import com.talhanation.recruits.world.RecruitsTeam;
import de.maxhenkel.recruits.corelib.net.Message;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.network.NetworkEvent;

public class MessageToClientUpdateTeamInspection
implements Message<MessageToClientUpdateTeamInspection> {
    private CompoundTag players;
    private CompoundTag team;
    private boolean editing;
    private boolean managing;

    public MessageToClientUpdateTeamInspection() {
    }

    public MessageToClientUpdateTeamInspection(List<RecruitsPlayerInfo> playerInfoList, RecruitsTeam team, boolean editing, boolean managing) {
        this.players = RecruitsPlayerInfo.toNBT(playerInfoList);
        this.team = team.toNBT();
        this.editing = editing;
        this.managing = managing;
    }

    @Override
    public Dist getExecutingSide() {
        return Dist.CLIENT;
    }

    @Override
    public void executeClientSide(NetworkEvent.Context context) {
        PlayersList.onlinePlayers = RecruitsPlayerInfo.getListFromNBT(this.players);
        TeamInspectionScreen.recruitsTeam = RecruitsTeam.fromNBT(this.team);
        TeamInspectionScreen.isEditingAllowed = this.editing;
        TeamInspectionScreen.isManagingAllowed = this.managing;
    }

    @Override
    public MessageToClientUpdateTeamInspection fromBytes(FriendlyByteBuf buf) {
        this.players = buf.m_130260_();
        this.team = buf.m_130260_();
        this.editing = buf.readBoolean();
        this.managing = buf.readBoolean();
        return this;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.players);
        buf.m_130079_(this.team);
        buf.writeBoolean(this.editing);
        buf.writeBoolean(this.managing);
    }
}

