/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.pathfinding;

import com.talhanation.recruits.config.RecruitsServerConfig;
import com.talhanation.recruits.pathfinding.AsyncPathNavigation;
import com.talhanation.recruits.pathfinding.AsyncPathfinder;
import com.talhanation.recruits.pathfinding.NodeEvaluatorGenerator;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AsyncGroundPathNavigation
extends AsyncPathNavigation {
    private static BiFunction<Integer, NodeEvaluator, PathFinder> pathfinderSupplier = (p_26453_, nodeEvaluator) -> new PathFinder(nodeEvaluator, p_26453_.intValue());
    private static final NodeEvaluatorGenerator nodeEvaluatorGenerator = () -> {
        WalkNodeEvaluator nodeEvaluator = new WalkNodeEvaluator();
        nodeEvaluator.m_77351_(true);
        nodeEvaluator.m_77358_(true);
        return nodeEvaluator;
    };
    private boolean avoidSun;

    public AsyncGroundPathNavigation(PathfinderMob p_26448_, Level p_26449_) {
        super(p_26448_, p_26449_);
        if (((Boolean)RecruitsServerConfig.UseAsyncPathfinding.get()).booleanValue()) {
            pathfinderSupplier = (p_26453_, nodeEvaluator) -> new AsyncPathfinder((NodeEvaluator)nodeEvaluator, (int)p_26453_, nodeEvaluatorGenerator, this.f_26495_);
        }
    }

    @Override
    @NotNull
    protected PathFinder m_5532_(int p_26453_) {
        this.f_26508_ = new WalkNodeEvaluator();
        this.f_26508_.m_77351_(true);
        return pathfinderSupplier.apply(p_26453_, this.f_26508_);
    }

    protected boolean m_7632_() {
        return this.f_26494_.m_20096_() || this.m_26574_() || this.f_26494_.m_20159_();
    }

    @NotNull
    protected Vec3 m_7475_() {
        return new Vec3(this.f_26494_.m_20185_(), (double)this.getSurfaceY(), this.f_26494_.m_20189_());
    }

    @Override
    public Path m_7864_(BlockPos p_26475_, int p_26476_) {
        if (this.f_26495_.m_8055_(p_26475_).m_60795_()) {
            BlockPos blockpos = p_26475_.m_7495_();
            while (blockpos.m_123342_() > this.f_26495_.m_141937_() && this.f_26495_.m_8055_(blockpos).m_60795_()) {
                blockpos = blockpos.m_7495_();
            }
            if (blockpos.m_123342_() > this.f_26495_.m_141937_()) {
                return super.m_7864_(blockpos.m_7494_(), p_26476_);
            }
            while (blockpos.m_123342_() < this.f_26495_.m_151558_() && this.f_26495_.m_8055_(blockpos).m_60795_()) {
                blockpos = blockpos.m_7494_();
            }
            p_26475_ = blockpos;
        }
        if (!this.f_26495_.m_8055_(p_26475_).m_280296_()) {
            return super.m_7864_(p_26475_, p_26476_);
        }
        BlockPos blockpos1 = p_26475_.m_7494_();
        while (blockpos1.m_123342_() < this.f_26495_.m_151558_() && this.f_26495_.m_8055_(blockpos1).m_280296_()) {
            blockpos1 = blockpos1.m_7494_();
        }
        return super.m_7864_(blockpos1, p_26476_);
    }

    @Override
    public Path m_6570_(Entity p_26465_, int p_26466_) {
        return this.m_7864_(p_26465_.m_20183_(), p_26466_);
    }

    private int getSurfaceY() {
        if (this.f_26494_.m_20069_() && this.m_26576_()) {
            int i = this.f_26494_.m_146904_();
            BlockState blockstate = this.f_26495_.m_8055_(new BlockPos((int)this.f_26494_.m_20185_(), i, (int)this.f_26494_.m_20189_()));
            int j = 0;
            while (blockstate.m_60713_(Blocks.f_49990_)) {
                blockstate = this.f_26495_.m_8055_(new BlockPos((int)this.f_26494_.m_20185_(), ++i, (int)this.f_26494_.m_20189_()));
                if (++j <= 16) continue;
                return this.f_26494_.m_146904_();
            }
            return i;
        }
        return Mth.m_14107_((double)(this.f_26494_.m_20186_() + 0.5));
    }

    @Override
    protected void m_6804_() {
        super.m_6804_();
        if (this.avoidSun) {
            if (this.f_26495_.m_45527_(new BlockPos((int)this.f_26494_.m_20185_(), (int)(this.f_26494_.m_20186_() + 0.5), (int)this.f_26494_.m_20189_()))) {
                return;
            }
            for (int i = 0; i < this.f_26496_.m_77398_(); ++i) {
                Node node = this.f_26496_.m_77375_(i);
                if (!this.f_26495_.m_45527_(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_))) continue;
                this.f_26496_.m_77388_(i);
                return;
            }
        }
    }

    protected boolean hasValidPathType(BlockPathTypes p_26467_) {
        if (p_26467_ == BlockPathTypes.WATER) {
            return false;
        }
        if (p_26467_ == BlockPathTypes.LAVA) {
            return false;
        }
        return p_26467_ != BlockPathTypes.OPEN;
    }

    public void setCanOpenDoors(boolean p_26478_) {
        this.f_26508_.m_77355_(p_26478_);
    }

    public boolean canPassDoors() {
        return this.f_26508_.m_77357_();
    }

    public void setCanPassDoors(boolean p_148215_) {
        this.f_26508_.m_77351_(p_148215_);
    }

    public boolean canOpenDoors() {
        return this.f_26508_.m_77357_();
    }

    public void setAvoidSun(boolean p_26491_) {
        this.avoidSun = p_26491_;
    }
}

