/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.recruits.util;

import com.talhanation.recruits.entities.AbstractRecruitEntity;
import com.talhanation.recruits.entities.CaptainEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class FormationUtils {
    public static final double spacing = 1.75;

    public static Vec3 calculateLineBlockPosition(Vec3 targetPos, Vec3 linePos, int size, int index, Level level) {
        Vec3 toTarget = linePos.m_82505_(targetPos).m_82541_();
        Vec3 rotation = toTarget.m_82524_(1.57f).m_82541_();
        Vec3 pos = index == 0 || size / index > size / 2 ? linePos.m_165921_(linePos.m_82549_(rotation), (double)index * 1.5) : linePos.m_165921_(linePos.m_82549_(rotation.m_82548_()), (double)index * 1.5);
        BlockPos blockPos = FormationUtils.getPositionOrSurface(level, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
        return new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
    }

    public static void movementFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        float yaw = player.m_146908_();
        Vec3 forward = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        FormationUtils.lineFormation(forward, recruits, targetPos, 3, 2.0);
    }

    public static void lineUpFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        float yaw = player.m_146908_();
        Vec3 forward = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        FormationUtils.lineFormation(forward, recruits, targetPos, 20, 1.75);
    }

    public static void lineFormation(Vec3 forward, List<AbstractRecruitEntity> recruits, Vec3 targetPos, int maxInRow, double spacing) {
        Vec3 left = new Vec3(-forward.f_82481_, forward.f_82480_, forward.f_82479_);
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        for (int i = 0; i < recruits.size(); ++i) {
            int row = i / maxInRow;
            int recruitsInCurrentRow = Math.min(maxInRow, recruits.size() - row * maxInRow);
            int positionInRow = i % maxInRow;
            double centerOffset = (double)(recruitsInCurrentRow - 1) / 2.0;
            Vec3 basePos = targetPos.m_82549_(forward.m_82490_((double)(-3 * row)));
            Vec3 offset = left.m_82490_(((double)positionInRow - centerOffset) * spacing);
            Vec3 recruitPos = basePos.m_82549_(offset);
            possiblePositions.add(new FormationPosition(recruitPos, true));
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = null;
            if (recruit.formationPos >= 0 && recruit.formationPos < possiblePositions.size() && ((FormationPosition)possiblePositions.get((int)recruit.formationPos)).isFree) {
                FormationPosition position = (FormationPosition)possiblePositions.get(recruit.formationPos);
                position.isFree = false;
                pos = position.position;
            } else {
                for (int i = 0; i < possiblePositions.size(); ++i) {
                    FormationPosition position = (FormationPosition)possiblePositions.get(i);
                    if (!position.isFree) continue;
                    pos = ((FormationPosition)possiblePositions.get((int)i)).position;
                    recruit.formationPos = i;
                    position.isFree = false;
                    break;
                }
            }
            if (pos == null) continue;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static void squareFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        float yaw = player.m_146908_();
        Vec3 forward = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        FormationUtils.squareFormation(forward, recruits, targetPos, 2.5);
    }

    public static void squareFormation(Vec3 forward, List<AbstractRecruitEntity> recruits, Vec3 targetPos, double spacing) {
        Vec3 left = new Vec3(-forward.f_82481_, forward.f_82480_, forward.f_82479_);
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        int numRecruits = recruits.size();
        int sideLength = (int)Math.ceil(Math.sqrt(numRecruits));
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        for (int i = 0; i < numRecruits; ++i) {
            int row = i / sideLength;
            int col = i % sideLength;
            Vec3 rowOffset = forward.m_82490_((double)(-row) * spacing);
            Vec3 colOffset = left.m_82490_((double)((float)col - (float)sideLength / 2.0f) * spacing);
            Vec3 recruitPos = targetPos.m_82549_(rowOffset).m_82549_(colOffset);
            possiblePositions.add(new FormationPosition(recruitPos, true));
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = null;
            if (recruit.formationPos >= 0 && recruit.formationPos < possiblePositions.size() && ((FormationPosition)possiblePositions.get((int)recruit.formationPos)).isFree) {
                FormationPosition position = (FormationPosition)possiblePositions.get(recruit.formationPos);
                position.isFree = false;
                pos = position.position;
            } else {
                for (int i = 0; i < possiblePositions.size(); ++i) {
                    FormationPosition position = (FormationPosition)possiblePositions.get(i);
                    if (!position.isFree) continue;
                    pos = position.position;
                    recruit.formationPos = i;
                    position.isFree = false;
                    break;
                }
            }
            if (pos == null) continue;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_()));
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static void triangleFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        float yaw = player.m_146908_();
        Vec3 forward = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        Vec3 left = new Vec3(-forward.f_82481_, forward.f_82480_, forward.f_82479_);
        double spacing = 2.5;
        int numRecruits = recruits.size();
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        int index = 0;
        int rowCount = 1;
        while (index < numRecruits) {
            for (int positionInRow = 0; positionInRow < rowCount && index < numRecruits; ++positionInRow, ++index) {
                Vec3 basePos = targetPos.m_82549_(forward.m_82490_((double)(-3 * (rowCount - 1))));
                Vec3 offset = left.m_82490_((double)((float)positionInRow - (float)(rowCount - 1) / 2.0f) * spacing);
                Vec3 recruitPos = basePos.m_82549_(offset);
                possiblePositions.add(new FormationPosition(recruitPos, true));
            }
            ++rowCount;
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = null;
            if (recruit.formationPos >= 0 && recruit.formationPos < possiblePositions.size() && ((FormationPosition)possiblePositions.get((int)recruit.formationPos)).isFree) {
                FormationPosition position = (FormationPosition)possiblePositions.get(recruit.formationPos);
                position.isFree = false;
                pos = position.position;
            } else {
                for (int i = 0; i < possiblePositions.size(); ++i) {
                    FormationPosition position = (FormationPosition)possiblePositions.get(i);
                    if (!position.isFree) continue;
                    pos = ((FormationPosition)possiblePositions.get((int)i)).position;
                    recruit.formationPos = i;
                    position.isFree = false;
                    break;
                }
            }
            if (pos == null) continue;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_));
            recruit.ownerRot = player.m_146908_();
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static void hollowCircleFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        double spacing = 2.5;
        int numRecruits = recruits.size();
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        double radius = spacing * (double)numRecruits / (Math.PI * 2);
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        for (int i = 0; i < numRecruits; ++i) {
            double angle = Math.PI * 2 / (double)numRecruits * (double)i;
            double x = targetPos.f_82479_ + radius * Math.cos(angle);
            double z = targetPos.f_82481_ + radius * Math.sin(angle);
            Vec3 recruitPos = new Vec3(x, targetPos.f_82480_, z);
            possiblePositions.add(new FormationPosition(recruitPos, true));
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = null;
            if (recruit.formationPos >= 0 && recruit.formationPos < possiblePositions.size() && ((FormationPosition)possiblePositions.get((int)recruit.formationPos)).isFree) {
                FormationPosition position = (FormationPosition)possiblePositions.get(recruit.formationPos);
                position.isFree = false;
                pos = position.position;
            } else {
                for (int i = 0; i < possiblePositions.size(); ++i) {
                    FormationPosition position = (FormationPosition)possiblePositions.get(i);
                    if (!position.isFree) continue;
                    pos = ((FormationPosition)possiblePositions.get((int)i)).position;
                    recruit.formationPos = i;
                    position.isFree = false;
                    break;
                }
            }
            if (pos == null) continue;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_));
            recruit.ownerRot = player.m_146908_();
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static void circleFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        Vec3 recruitPos;
        double z;
        double x;
        double angle;
        int i;
        double spacing = 2.5;
        int numRecruits = recruits.size();
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        int innerRingCount = Math.min(5, numRecruits);
        int middleRingCount = Math.min(10, numRecruits - innerRingCount);
        int outerRingCount = numRecruits - innerRingCount - middleRingCount;
        double innerRadius = spacing * (double)innerRingCount / (Math.PI * 2);
        double middleRadius = spacing * (double)middleRingCount / (Math.PI * 2);
        double outerRadius = spacing * (double)outerRingCount / (Math.PI * 2);
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        for (i = 0; i < innerRingCount; ++i) {
            angle = Math.PI * 2 / (double)innerRingCount * (double)i;
            x = targetPos.f_82479_ + innerRadius * Math.cos(angle);
            z = targetPos.f_82481_ + innerRadius * Math.sin(angle);
            recruitPos = new Vec3(x, targetPos.f_82480_, z);
            possiblePositions.add(new FormationPosition(recruitPos, true));
        }
        for (i = 0; i < middleRingCount; ++i) {
            angle = Math.PI * 2 / (double)middleRingCount * (double)i;
            x = targetPos.f_82479_ + middleRadius * Math.cos(angle);
            z = targetPos.f_82481_ + middleRadius * Math.sin(angle);
            recruitPos = new Vec3(x, targetPos.f_82480_, z);
            possiblePositions.add(new FormationPosition(recruitPos, true));
        }
        for (i = 0; i < outerRingCount; ++i) {
            angle = Math.PI * 2 / (double)outerRingCount * (double)i;
            x = targetPos.f_82479_ + outerRadius * Math.cos(angle);
            z = targetPos.f_82481_ + outerRadius * Math.sin(angle);
            recruitPos = new Vec3(x, targetPos.f_82480_, z);
            possiblePositions.add(new FormationPosition(recruitPos, true));
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = null;
            if (recruit.formationPos >= 0 && recruit.formationPos < possiblePositions.size() && ((FormationPosition)possiblePositions.get((int)recruit.formationPos)).isFree) {
                FormationPosition position = (FormationPosition)possiblePositions.get(recruit.formationPos);
                position.isFree = false;
                pos = position.position;
            } else {
                for (int i2 = 0; i2 < possiblePositions.size(); ++i2) {
                    FormationPosition position = (FormationPosition)possiblePositions.get(i2);
                    if (!position.isFree) continue;
                    pos = ((FormationPosition)possiblePositions.get((int)i2)).position;
                    recruit.formationPos = i2;
                    position.isFree = false;
                    break;
                }
            }
            if (pos == null) continue;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_));
            recruit.ownerRot = player.m_146908_();
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static void hollowSquareFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        int totalRecruitsNeeded;
        float yaw = player.m_146908_();
        Vec3 forward = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        Vec3 left = new Vec3(-forward.f_82481_, forward.f_82480_, forward.f_82479_);
        int recruitsPerSide = Math.max(2, recruits.size() / 4);
        double spacing = 2.5;
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        if ((totalRecruitsNeeded = recruitsPerSide * 4) > recruits.size()) {
            recruitsPerSide = recruits.size() / 4;
            totalRecruitsNeeded = recruitsPerSide * 4;
        }
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        for (int row = 0; row < 2; ++row) {
            double offset = spacing * (double)recruitsPerSide / 2.0;
            for (int i = 0; i < recruitsPerSide; ++i) {
                double positionOffset = (double)i * spacing - offset;
                possiblePositions.add(new FormationPosition(targetPos.m_82549_(forward.m_82490_(-offset - (double)row * spacing)).m_82549_(left.m_82490_(positionOffset)), true));
                possiblePositions.add(new FormationPosition(targetPos.m_82549_(forward.m_82490_(offset + (double)row * spacing)).m_82549_(left.m_82490_(positionOffset)), true));
                possiblePositions.add(new FormationPosition(targetPos.m_82549_(left.m_82490_(-offset - (double)row * spacing)).m_82549_(forward.m_82490_(positionOffset)), true));
                possiblePositions.add(new FormationPosition(targetPos.m_82549_(left.m_82490_(offset + (double)row * spacing)).m_82549_(forward.m_82490_(positionOffset)), true));
            }
        }
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = null;
            if (recruit.formationPos >= 0 && recruit.formationPos < possiblePositions.size() && ((FormationPosition)possiblePositions.get((int)recruit.formationPos)).isFree) {
                FormationPosition position = (FormationPosition)possiblePositions.get(recruit.formationPos);
                position.isFree = false;
                pos = position.position;
            } else {
                for (int i = 0; i < possiblePositions.size(); ++i) {
                    FormationPosition position = (FormationPosition)possiblePositions.get(i);
                    if (!position.isFree) continue;
                    pos = position.position;
                    recruit.formationPos = i;
                    position.isFree = false;
                    break;
                }
            }
            if (pos == null) continue;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_));
            recruit.ownerRot = player.m_146908_();
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static void vFormation(ServerPlayer player, List<AbstractRecruitEntity> recruits, Vec3 targetPos) {
        int i;
        float yaw = player.m_146908_();
        Vec3 forward = new Vec3(-Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        Vec3 left = new Vec3(-forward.f_82481_, forward.f_82480_, forward.f_82479_);
        double spacing = 2.5;
        int recruitsPerWing = recruits.size() / 2;
        for (AbstractRecruitEntity rec : recruits) {
            if (!(rec instanceof CaptainEntity)) continue;
            CaptainEntity captain = (CaptainEntity)rec;
            if (captain.smallShipsController.ship == null || !captain.smallShipsController.ship.isCaptainDriver()) continue;
            spacing *= 10.0;
            break;
        }
        ArrayList<FormationPosition> possiblePositions = new ArrayList<FormationPosition>();
        for (i = 0; i < recruitsPerWing; ++i) {
            double offset = (double)i * spacing;
            Vec3 rightWingPos = targetPos.m_82549_(forward.m_82490_(offset)).m_82549_(left.m_82490_(offset));
            possiblePositions.add(new FormationPosition(rightWingPos, true));
            Vec3 leftWingPos = targetPos.m_82549_(forward.m_82490_(offset)).m_82546_(left.m_82490_(offset));
            possiblePositions.add(new FormationPosition(leftWingPos, true));
        }
        if (recruits.size() % 2 != 0) {
            possiblePositions.add(new FormationPosition(targetPos, true));
        }
        for (i = 0; i < recruits.size() && i < possiblePositions.size(); ++i) {
            AbstractRecruitEntity recruit = recruits.get(i);
            Vec3 pos = ((FormationPosition)possiblePositions.get((int)i)).position;
            BlockPos blockPos = FormationUtils.getPositionOrSurface(recruit.m_20193_(), new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_));
            recruit.setHoldPos(new Vec3(pos.f_82479_, (double)blockPos.m_123342_(), pos.f_82481_));
            recruit.ownerRot = player.m_146908_();
            recruit.setFollowState(3);
            recruit.isInFormation = true;
        }
    }

    public static Vec3 getCenterOfPositions(List<LivingEntity> recruits, ServerLevel level) {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (LivingEntity recruit : recruits) {
            Vec3 pos = recruit.m_20182_();
            sumX += pos.f_82479_;
            sumY += pos.f_82480_;
            sumZ += pos.f_82481_;
        }
        double centerX = sumX / (double)recruits.size();
        double centerY = sumY / (double)recruits.size();
        double centerZ = sumZ / (double)recruits.size();
        BlockPos blockPos = FormationUtils.getPositionOrSurface((Level)level, new BlockPos((int)centerX, (int)centerY, (int)centerZ));
        return new Vec3(centerX, (double)blockPos.m_123342_(), centerZ);
    }

    public static Vec3 getFarthestRecruitsCenter(List<AbstractRecruitEntity> recruits, ServerLevel level) {
        if (recruits.size() < 2) {
            return recruits.isEmpty() ? Vec3.f_82478_ : recruits.get(0).m_20182_();
        }
        AbstractRecruitEntity farthestRecruit1 = null;
        AbstractRecruitEntity farthestRecruit2 = null;
        double maxDistance = Double.MIN_VALUE;
        for (int i = 0; i < recruits.size() - 1; ++i) {
            for (int j = i + 1; j < recruits.size(); ++j) {
                double distance = recruits.get(i).m_20280_((Entity)recruits.get(j));
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                farthestRecruit1 = recruits.get(i);
                farthestRecruit2 = recruits.get(j);
            }
        }
        Vec3 pos1 = ((AbstractRecruitEntity)Objects.requireNonNull(farthestRecruit1)).m_20182_();
        Vec3 pos2 = ((AbstractRecruitEntity)Objects.requireNonNull(farthestRecruit2)).m_20182_();
        double centerX = (pos1.f_82479_ + pos2.f_82479_) / 2.0;
        double centerY = (pos1.f_82480_ + pos2.f_82480_) / 2.0;
        double centerZ = (pos1.f_82481_ + pos2.f_82481_) / 2.0;
        BlockPos blockPos = FormationUtils.getPositionOrSurface((Level)level, new BlockPos((int)centerX, (int)centerY, (int)centerZ));
        return new Vec3(centerX, (double)blockPos.m_123342_(), centerZ);
    }

    public static Vec3 getGeometricMedian(List<AbstractRecruitEntity> recruits, ServerLevel level) {
        if (recruits.isEmpty()) {
            return Vec3.f_82478_;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (AbstractRecruitEntity recruit : recruits) {
            Vec3 pos = recruit.m_20182_();
            sumX += pos.f_82479_;
            sumY += pos.f_82480_;
            sumZ += pos.f_82481_;
        }
        Vec3 currentGuess = new Vec3(sumX / (double)recruits.size(), sumY / (double)recruits.size(), sumZ / (double)recruits.size());
        double tolerance = 1.0E-4;
        int maxIterations = 100;
        for (int iteration = 0; iteration < maxIterations; ++iteration) {
            double numeratorX = 0.0;
            double numeratorY = 0.0;
            double numeratorZ = 0.0;
            double denominator = 0.0;
            for (AbstractRecruitEntity recruit : recruits) {
                Vec3 pos = recruit.m_20182_();
                double distance = currentGuess.m_82554_(pos);
                if (distance < tolerance) continue;
                double weight = 1.0 / distance;
                numeratorX += pos.f_82479_ * weight;
                numeratorY += pos.f_82480_ * weight;
                numeratorZ += pos.f_82481_ * weight;
                denominator += weight;
            }
            Vec3 newGuess = new Vec3(numeratorX / denominator, numeratorY / denominator, numeratorZ / denominator);
            if (currentGuess.m_82554_(newGuess) < tolerance) break;
            currentGuess = newGuess;
        }
        BlockPos blockPos = FormationUtils.getPositionOrSurface((Level)level, new BlockPos((int)currentGuess.f_82479_, (int)currentGuess.f_82480_, (int)currentGuess.f_82481_));
        return new Vec3(currentGuess.f_82479_, (double)blockPos.m_123342_(), currentGuess.f_82481_);
    }

    public static BlockPos getPositionOrSurface(Level level, BlockPos pos) {
        boolean positionFree = true;
        for (int i = 0; i < 3; ++i) {
            if (level.m_8055_(pos.m_6630_(i)).m_60795_()) continue;
            positionFree = false;
            break;
        }
        return positionFree ? pos : new BlockPos(pos.m_123341_(), level.m_5452_(Heightmap.Types.WORLD_SURFACE, pos).m_123342_(), pos.m_123343_());
    }

    public static class FormationPosition {
        public Vec3 position;
        public boolean isFree;

        FormationPosition(Vec3 position, boolean isFree) {
            this.position = position;
            this.isFree = isFree;
        }
    }
}

