/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.client.model;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Either;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;

public class RetexturedBlockModel
extends BlockModel {
    private final Map<String, Material> replacements = new HashMap<String, Material>();

    public static RetexturedBlockModel from(BlockModel base) {
        RetexturedBlockModel retexturedBlockModel = new RetexturedBlockModel(base.getParentLocation(), base.m_111436_(), base.f_111417_, base.m_111476_(), base.m_111479_(), base.m_111491_(), base.m_111484_());
        retexturedBlockModel.customData.copyFrom(base.customData);
        return retexturedBlockModel;
    }

    public RetexturedBlockModel(@Nullable ResourceLocation parentLocation, List<BlockElement> elements, Map<String, Either<Material, String>> textures, boolean ambientOcclusion, @Nullable BlockModel.GuiLight guiLight, ItemTransforms cameraTransforms, List<ItemOverride> overrides) {
        super(parentLocation, elements, textures, Boolean.valueOf(ambientOcclusion), guiLight, cameraTransforms, overrides);
    }

    public Material m_111480_(String name) {
        if (name.charAt(0) == '#') {
            name = name.substring(1);
        }
        return this.replacements.containsKey(name) ? this.replacements.get(name) : super.m_111480_(name);
    }

    public void replaceTexture(String name, Material texture) {
        this.replacements.put(name, texture);
    }

    public void replaceTexture(String name, ResourceLocation texture) {
        this.replacements.put(name, new Material(InventoryMenu.f_39692_, texture));
    }

    public RetexturedBlockModel retexture(ImmutableMap<String, String> textures) {
        textures.forEach((name, texture) -> this.replaceTexture((String)name, new ResourceLocation(texture)));
        return this;
    }
}

