/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import shetiphian.core.common.MyDamageSource;
import shetiphian.core.common.TagHelper;

public abstract class ItemToolWithDamageSource
extends DiggerItem {
    private final MyDamageSource damageSource;

    public ItemToolWithDamageSource(float damage, float speed, Tier tier, MyDamageSource damageSource, Item.Properties properties) {
        this(damage, speed, tier, damageSource, TagHelper.BLOCK_DUMMY, properties);
    }

    public ItemToolWithDamageSource(float damage, float speed, Tier tier, MyDamageSource damageSource, TagKey<Block> blocks, Item.Properties properties) {
        super(damage, speed, tier, blocks, properties);
        this.damageSource = damageSource;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity victim) {
        if (victim.m_6097_() && !victim.m_7313_((Entity)player)) {
            AttackValues values = ItemToolWithDamageSource.calculateBaseValues(player, victim, null);
            values.bonusDamage = this.getBonusDamage(player, victim, this.damageSource, values.damage, values.bonusDamage);
            values.knockback = this.getKnockback(player, victim, this.damageSource, values.knockback);
            if ((values.damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, this.damageSource, null, values)) {
                this.postHurtEntity(player, victim, this.damageSource);
            }
        }
        return true;
    }

    public static boolean onLeftClickEntity(Player player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers) {
        if (victim.m_6097_() && !victim.m_7313_((Entity)player)) {
            AttackValues values = ItemToolWithDamageSource.calculateBaseValues(player, victim, extraModifiers);
            if ((values.damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, damageSource, extraModifiers, values)) {
                player.m_36399_(0.3f);
            }
        }
        return true;
    }

    private static AttackValues calculateBaseValues(Player player, Entity victim, ItemStack extraModifiers) {
        AttackValues values = new AttackValues();
        values.damage = (float)player.m_21051_(Attributes.f_22281_).m_22135_();
        if (victim instanceof LivingEntity) {
            values.bonusDamage = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)((LivingEntity)victim).m_6336_());
            values.knockback = EnchantmentHelper.m_44894_((LivingEntity)player);
            if (extraModifiers != null) {
                values.bonusDamage += EnchantmentHelper.m_44833_((ItemStack)extraModifiers, (MobType)((LivingEntity)victim).m_6336_());
                values.knockback += EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44980_, (ItemStack)extraModifiers);
            }
        } else {
            values.bonusDamage = EnchantmentHelper.m_44833_((ItemStack)player.m_21205_(), (MobType)MobType.f_21640_);
            if (extraModifiers != null) {
                values.bonusDamage += EnchantmentHelper.m_44833_((ItemStack)extraModifiers, (MobType)MobType.f_21640_);
            }
        }
        values.strength = player.m_36403_(0.5f);
        values.damage *= 0.2f + values.strength * values.strength * 0.8f;
        values.bonusDamage *= values.strength;
        player.m_36334_();
        if (player.m_20142_()) {
            ++values.knockback;
        }
        return values;
    }

    protected float getBonusDamage(Player player, Entity victim, MyDamageSource source, float damage, float bonusDamage) {
        return bonusDamage;
    }

    protected int getKnockback(Player player, Entity victim, MyDamageSource source, int knockback) {
        return knockback;
    }

    private static boolean preformDamage(Player player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers, AttackValues values) {
        ItemStack itemstack;
        boolean isStrongAttack = values.strength > 0.9f;
        boolean flag1 = false;
        boolean flag3 = false;
        if (player.m_20142_() && isStrongAttack) {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12314_, player.m_5720_(), 1.0f, 1.0f);
            flag1 = true;
        }
        boolean doBoostDamage = isStrongAttack && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && victim instanceof LivingEntity;
        doBoostDamage = doBoostDamage && !player.m_20142_();
        CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)victim, (boolean)doBoostDamage, (float)(doBoostDamage ? 1.5f : 1.0f));
        boolean bl = doBoostDamage = hitResult != null;
        if (doBoostDamage) {
            values.damage *= hitResult.getDamageModifier();
        }
        values.damage += values.bonusDamage;
        double d0 = player.f_19787_ - player.f_19867_;
        if (isStrongAttack && !doBoostDamage && !flag1 && player.m_20096_() && d0 < (double)player.m_6113_() && !(itemstack = player.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && itemstack.m_41720_() instanceof SwordItem) {
            flag3 = true;
        }
        float victimHealthPreAttack = 0.0f;
        boolean victimOnFire = false;
        int fireDamage = EnchantmentHelper.m_44914_((LivingEntity)player);
        if (extraModifiers != null) {
            fireDamage += EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)extraModifiers);
        }
        if (victim instanceof LivingEntity) {
            victimHealthPreAttack = ((LivingEntity)victim).m_21223_();
            if (fireDamage > 0 && !victim.m_6060_()) {
                victimOnFire = true;
                victim.m_20254_(1);
            }
        }
        Vec3 vec3d = victim.m_20184_();
        boolean victimWasHurt = damageSource != null ? victim.m_6469_(damageSource.causeEntityDamage((Entity)player), values.damage) : victim.m_6469_(victim.m_269291_().m_269075_(player), values.damage);
        if (victimWasHurt) {
            if (values.knockback > 0) {
                if (victim instanceof LivingEntity) {
                    ((LivingEntity)victim).m_147240_((double)((float)values.knockback * 0.5f), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                } else {
                    victim.m_5997_((double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))) * (float)values.knockback * 0.5f), 0.1, (double)(Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * (float)values.knockback * 0.5f));
                }
                player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                player.m_6858_(false);
            }
            if (flag3) {
                for (LivingEntity livingEntity : player.m_9236_().m_45976_(LivingEntity.class, victim.m_20191_().m_82363_(1.0, 0.25, 1.0))) {
                    if (livingEntity == player || livingEntity == victim || player.m_7307_((Entity)livingEntity) || !(player.m_20280_((Entity)livingEntity) < 9.0)) continue;
                    livingEntity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                    livingEntity.m_6469_(victim.m_269291_().m_269075_(player), 1.0f);
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                player.m_36346_();
            }
            if (victim instanceof ServerPlayer && victim.f_19864_) {
                ((ServerPlayer)victim).f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(victim));
                victim.f_19864_ = false;
                victim.m_20256_(vec3d);
            }
            if (doBoostDamage) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                player.m_5704_(victim);
            }
            if (!doBoostDamage && !flag3) {
                if (isStrongAttack) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, player.m_5720_(), 1.0f, 1.0f);
                } else {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
                }
            }
            if (values.bonusDamage > 0.0f) {
                player.m_5700_(victim);
            }
            if (!player.m_9236_().m_5776_() && victim instanceof Player) {
                ItemStack itemStack3;
                Player entityplayer = (Player)victim;
                ItemStack itemStack2 = player.m_21205_();
                ItemStack itemStack = itemStack3 = entityplayer.m_6117_() ? entityplayer.m_21211_() : ItemStack.f_41583_;
                if (!itemStack2.m_41619_() && !itemStack3.m_41619_() && itemStack2.m_41720_() instanceof AxeItem && itemStack3.m_41720_() == Items.f_42740_) {
                    float f3 = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)player) * 0.05f;
                    if (flag1) {
                        f3 += 0.75f;
                    }
                    if (player.m_9236_().f_46441_.m_188501_() < f3) {
                        entityplayer.m_36335_().m_41524_(Items.f_42740_, 100);
                        player.m_9236_().m_7605_((Entity)entityplayer, (byte)30);
                    }
                }
            }
            if (values.damage >= 0.0f) {
                player.m_5700_(victim);
            }
            player.m_21335_(victim);
            if (victim instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)victim), (Entity)player);
            }
            EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)victim);
            ItemStack equippedItem = player.m_21205_();
            Entity entity = victim;
            if (victim instanceof EnderDragonPart) {
                entity = ((EnderDragonPart)victim).f_31010_;
            }
            if (!equippedItem.m_41619_() && entity instanceof LivingEntity) {
                equippedItem.m_41640_((LivingEntity)entity, player);
                if (equippedItem.m_41613_() <= 0) {
                    player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                }
            }
            if (victim instanceof LivingEntity) {
                float victimHealthPostAttack = victimHealthPreAttack - ((LivingEntity)victim).m_21223_();
                player.m_36222_(Stats.f_12928_, Math.round(victimHealthPostAttack * 10.0f));
                if (fireDamage > 0) {
                    victim.m_20254_(fireDamage * 4);
                }
                if (player.m_9236_() instanceof ServerLevel && victimHealthPostAttack > 2.0f) {
                    int k = (int)((double)victimHealthPostAttack * 0.5);
                    ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123798_, victim.m_20185_(), victim.m_20186_() + (double)(victim.m_20206_() * 0.5f), victim.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                }
            }
            player.m_36399_(0.3f);
        } else {
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
            if (victimOnFire) {
                victim.m_20095_();
            }
        }
        return victimWasHurt;
    }

    protected void postHurtEntity(Player player, Entity victim, MyDamageSource source) {
        player.m_36399_(0.3f);
    }

    private static class AttackValues {
        private float damage;
        private int knockback;
        private float bonusDamage;
        private float strength;

        private AttackValues() {
        }
    }
}

