/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import xyz.przemyk.simpleplanes.client.render.UpgradesModels;
import xyz.przemyk.simpleplanes.entities.CargoPlaneEntity;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;
import xyz.przemyk.simpleplanes.setup.SimplePlanesEntities;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.LargeUpgrade;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.storage.ChestUpgrade;

public class PlaneRenderer<T extends PlaneEntity>
extends EntityRenderer<T> {
    protected final EntityModel<PlaneEntity> propellerModel;
    protected final EntityModel<T> planeEntityModel;
    protected final EntityModel<PlaneEntity> planeMetalModel;
    protected final ResourceLocation metalTexture;
    protected final ResourceLocation propellerTexture;
    public static final Map<Block, ResourceLocation> cachedTextures = new HashMap<Block, ResourceLocation>();
    public static final ResourceLocation FALLBACK_TEXTURE = new ResourceLocation("minecraft", "textures/block/oak_planks.png");

    public PlaneRenderer(EntityRendererProvider.Context context, EntityModel<T> planeModel, EntityModel<PlaneEntity> planeMetalModel, EntityModel<PlaneEntity> propellerModel, float shadowSize, ResourceLocation metalTexture, ResourceLocation propellerTexture) {
        super(context);
        this.propellerModel = propellerModel;
        this.planeEntityModel = planeModel;
        this.planeMetalModel = planeMetalModel;
        this.metalTexture = metalTexture;
        this.propellerTexture = propellerTexture;
        this.f_114477_ = shadowSize;
    }

    public static float getPropellerRotation(PlaneEntity entity, float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)entity.propellerRotationOld, (float)entity.propellerRotationNew);
    }

    public void render(T planeEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, 0.375, 0.0);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Quaternionf q = MathUtil.lerpQ(partialTicks, ((PlaneEntity)((Object)planeEntity)).getQ_Prev(), ((PlaneEntity)((Object)planeEntity)).getQ_Client());
        poseStack.m_252781_(q);
        EntityType entityType = planeEntity.m_6095_();
        if (entityType == SimplePlanesEntities.PLANE.get()) {
            poseStack.m_85837_(0.0, -0.5, -0.5);
        } else if (entityType == SimplePlanesEntities.LARGE_PLANE.get()) {
            poseStack.m_85837_(0.0, -0.3, -1.0);
        } else if (entityType == SimplePlanesEntities.CARGO_PLANE.get()) {
            poseStack.m_85837_(0.0, -0.8, -1.0);
        } else {
            poseStack.m_85837_(0.0, 0.0, 0.9);
        }
        float timeSinceHitWithPartial = (float)((PlaneEntity)((Object)planeEntity)).getTimeSinceHit() - partialTicks;
        if (timeSinceHitWithPartial > 0.0f) {
            float angle = Mth.m_14036_((float)(timeSinceHitWithPartial / 10.0f), (float)-30.0f, (float)30.0f);
            timeSinceHitWithPartial = (float)((PlaneEntity)((Object)planeEntity)).f_19797_ + partialTicks;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)timeSinceHitWithPartial) * angle));
        }
        poseStack.m_85837_(0.0, -1.1, 0.0);
        VertexConsumer materialVertexConsumer = buffer.m_6299_(this.planeEntityModel.m_103119_(PlaneRenderer.getMaterialTexture(planeEntity)));
        this.planeEntityModel.m_6973_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.planeEntityModel.m_7695_(poseStack, materialVertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)this.planeEntityModel.m_103119_(this.propellerTexture), (boolean)false, (boolean)planeEntity.m_20068_());
        this.propellerModel.m_6973_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.propellerModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        vertexConsumer = buffer.m_6299_(this.planeMetalModel.m_103119_(this.metalTexture));
        this.planeMetalModel.m_6973_(planeEntity, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f);
        this.planeMetalModel.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        for (Upgrade upgrade : ((PlaneEntity)((Object)planeEntity)).upgrades.values()) {
            upgrade.render(poseStack, buffer, packedLight, partialTicks);
        }
        if (planeEntity instanceof CargoPlaneEntity) {
            CargoPlaneEntity cargoPlaneEntity = (CargoPlaneEntity)((Object)planeEntity);
            if (!((PlaneEntity)((Object)planeEntity)).upgrades.containsKey(SimplePlanesUpgrades.SEATS.getId())) {
                UpgradesModels.WOODEN_CARGO_SEATS.m_7695_(poseStack, buffer.m_6299_(UpgradesModels.SEATS.m_103119_(PlaneRenderer.getMaterialTexture(planeEntity))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            for (int i = 0; i < cargoPlaneEntity.largeUpgrades.size(); ++i) {
                LargeUpgrade upgrade = cargoPlaneEntity.largeUpgrades.get(i);
                poseStack.m_85836_();
                if (i < 6) {
                    poseStack.m_85837_((double)(i % 2) - 0.5, 0.3125, (double)(i / 2) + 0.5);
                } else {
                    if (upgrade instanceof ChestUpgrade) {
                        poseStack.m_85837_(0.0, -0.1, 0.0);
                    }
                    if (i == 6) {
                        poseStack.m_85837_(2.875, 1.05, 2.1375);
                    } else {
                        poseStack.m_85837_(-2.875, 1.05, 2.1375);
                    }
                }
                upgrade.render(poseStack, buffer, packedLight, partialTicks);
                poseStack.m_85849_();
            }
        }
        poseStack.m_85849_();
        super.m_7392_(planeEntity, 0.0f, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(PlaneEntity entity) {
        return PlaneRenderer.getMaterialTexture(entity);
    }

    public static ResourceLocation getMaterialTexture(PlaneEntity entity) {
        ResourceLocation texture;
        Block block = entity.getMaterial();
        if (cachedTextures.containsKey(block)) {
            return cachedTextures.get(block);
        }
        try {
            ResourceLocation sprite = ((BakedQuad)Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(ForgeRegistries.BLOCKS.getKey((Object)block), "inventory")).getQuads(null, Direction.SOUTH, RandomSource.m_216327_(), ModelData.EMPTY, null).get(0)).m_173410_().m_245424_().m_246162_();
            texture = new ResourceLocation(sprite.m_135827_(), "textures/" + sprite.m_135815_() + ".png");
        }
        catch (IndexOutOfBoundsException | NullPointerException exception) {
            texture = FALLBACK_TEXTURE;
        }
        cachedTextures.put(block, texture);
        return texture;
    }
}

