/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Quaternionf;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.misc.MathUtil;

public class RotationPacket {
    private final Quaternionf quaternion;

    public RotationPacket(Quaternionf quaternion) {
        this.quaternion = quaternion;
    }

    public RotationPacket(FriendlyByteBuf buffer) {
        this.quaternion = buffer.m_269131_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_269101_(this.quaternion);
    }

    public void handle(Supplier<NetworkEvent.Context> ctxSup) {
        NetworkEvent.Context ctx = ctxSup.get();
        ctx.enqueueWork(() -> {
            Entity patt985$temp;
            ServerPlayer sender = ctx.getSender();
            if (sender != null && (patt985$temp = sender.m_20202_()) instanceof PlaneEntity) {
                PlaneEntity planeEntity = (PlaneEntity)patt985$temp;
                planeEntity.setQ(this.quaternion);
                MathUtil.EulerAngles eulerAngles = MathUtil.toEulerAngles(this.quaternion);
                planeEntity.m_146922_((float)eulerAngles.yaw);
                planeEntity.m_146926_((float)eulerAngles.pitch);
                planeEntity.rotationRoll = (float)eulerAngles.roll;
                planeEntity.setQ_Client(this.quaternion);
            }
        });
        ctx.setPacketHandled(true);
    }
}

