/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.api.central;

import com.codinglitch.simpleradio.api.central.Auricular;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.client.ClientRadioManager;
import com.codinglitch.simpleradio.core.registry.blocks.AuditoryBlockEntity;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import java.util.UUID;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public interface Speaking
extends Auricular {
    default public RadioSpeaker startSpeaking(Entity owner, @Nullable UUID id) {
        return this.setupSpeaker(RadioManager.getOrCreateSpeaker(owner, id));
    }

    default public RadioSpeaker startSpeaking(WorldlyPosition location, @Nullable UUID id) {
        return this.setupSpeaker(RadioManager.getOrCreateSpeaker(location, id));
    }

    default public RadioSpeaker setupSpeaker(RadioSpeaker speaker) {
        return speaker;
    }

    default public void stopSpeaking(UUID owner, boolean isClient) {
        if (isClient) {
            ClientRadioManager.removeRouter(owner);
        } else {
            RadioManager.removeSpeaker(owner);
        }
    }

    default public void stopSpeaking(WorldlyPosition location) {
        if (location.isClientSide()) {
            ClientRadioManager.removeRouter(location);
        } else {
            RadioManager.removeSpeaker(location);
        }
    }

    default public void stopSpeaking() {
        Speaking speaking = this;
        if (speaking instanceof AuditoryBlockEntity) {
            AuditoryBlockEntity blockEntity = (AuditoryBlockEntity)((Object)speaking);
            if (blockEntity.speaker != null) {
                this.stopSpeaking(blockEntity.speaker.location);
                blockEntity.speaker.invalidate();
            }
        }
    }
}

