/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.core.registry.blocks;

import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.Socket;
import com.codinglitch.simpleradio.radio.RadioListener;
import com.codinglitch.simpleradio.radio.RadioManager;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSpeaker;
import com.codinglitch.simpleradio.radio.RadioTransmitter;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AuditoryBlockEntity
extends BlockEntity
implements Socket {
    public Frequency frequency;
    public UUID id;
    @Nullable
    public RadioReceiver receiver;
    @Nullable
    public RadioTransmitter transmitter;
    @Nullable
    public RadioListener listener;
    @Nullable
    public RadioSpeaker speaker;

    public AuditoryBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        if (this.id == null && !level.f_46443_) {
            this.id = UUID.randomUUID();
        }
    }

    @Override
    public RadioRouter getRouter() {
        return Stream.of(this.listener, this.speaker, this.transmitter, this.receiver).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            if (this.id != null && this.m_58898_()) {
                return RadioManager.getRouterSided(this.id, this.f_58857_.f_46443_);
            }
            return null;
        });
    }

    public Vec3 getConnectionPosition() {
        return this.m_58899_().m_252807_();
    }

    public void loadFromItem(ItemStack stack) {
        this.loadTag(stack.m_41784_());
    }

    public void loadTag(CompoundTag tag) {
        if (tag.m_128441_("frequency")) {
            String frequencyName = tag.m_128461_("frequency");
            Frequency.Modulation modulation = Frequency.modulationOf(tag.m_128461_("modulation"));
            this.frequency = Frequency.getOrCreateFrequency(frequencyName, modulation);
        }
        if (tag.m_128441_("uuid")) {
            this.id = tag.m_128342_("uuid");
        }
    }

    public void saveTag(CompoundTag tag) {
        if (this.frequency != null) {
            tag.m_128359_("frequency", this.frequency.frequency);
            tag.m_128359_("modulation", this.frequency.modulation.shorthand);
        }
        if (this.id != null) {
            tag.m_128362_("uuid", this.id);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        this.saveTag(tag);
        super.m_183515_(tag);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

