/*
 * Decompiled with CFR 0.152.
 */
package com.codinglitch.simpleradio.radio;

import com.codinglitch.simpleradio.api.central.FrequencingType;
import com.codinglitch.simpleradio.api.central.Frequency;
import com.codinglitch.simpleradio.api.central.WorldlyPosition;
import com.codinglitch.simpleradio.radio.RadioReceiver;
import com.codinglitch.simpleradio.radio.RadioRouter;
import com.codinglitch.simpleradio.radio.RadioSource;
import java.util.UUID;
import java.util.function.BiPredicate;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class RadioTransmitter
extends RadioRouter {
    public int antennaPower = 0;
    public Frequency frequency;
    public FrequencingType frequencingType;

    protected RadioTransmitter(Frequency frequency, UUID id) {
        super(id);
        this.setFrequency(frequency);
    }

    protected RadioTransmitter(Frequency frequency) {
        this(frequency, UUID.randomUUID());
    }

    public RadioTransmitter(Frequency frequency, Entity owner) {
        this(frequency, owner, UUID.randomUUID());
    }

    public RadioTransmitter(Frequency frequency, Entity owner, UUID uuid) {
        this(frequency, uuid);
        this.owner = owner;
    }

    public RadioTransmitter(Frequency frequency, WorldlyPosition location) {
        this(frequency, location, UUID.randomUUID());
    }

    public RadioTransmitter(Frequency frequency, WorldlyPosition location, UUID uuid) {
        this(frequency, uuid);
        this.location = location;
    }

    public void setFrequency(Frequency frequency) {
        if (this.frequency != null) {
            this.frequency.removeTransmitter(this);
        }
        this.frequency = frequency;
        this.routers = this.frequency.receivers;
    }

    public RadioTransmitter transmitCriteria(BiPredicate<RadioSource, RadioRouter> criteria) {
        this.routeCriteria = criteria;
        return this;
    }

    public RadioTransmitter frequencingType(FrequencingType type) {
        this.frequencingType = type;
        return this;
    }

    public float getPower(Frequency.Modulation modulation) {
        int baseTransmissionPower = this.frequencingType.getTransmissionPower(modulation);
        return baseTransmissionPower + this.antennaPower * this.frequencingType.antennaAptitude;
    }

    @Override
    @Nullable
    public Frequency getFrequency() {
        return this.frequency;
    }

    @Override
    public boolean shouldRouteTo(RadioSource source, RadioRouter destination) {
        if (destination instanceof RadioReceiver) {
            RadioReceiver receiver = (RadioReceiver)destination;
            if (source.willShort(receiver)) {
                return false;
            }
            FrequencingType type = source.frequencingType == -1 ? this.frequencingType : source.getFrequencingType();
            double transmissionPower = source.frequencingType == -1 ? (double)this.getPower(this.frequency.modulation) : (double)source.transmissionPower;
            double distance = this.getLocation().distance(receiver.getLocation());
            double cost = distance * type.transmissionDiminishment;
            return transmissionPower + receiver.getPower() >= cost;
        }
        return super.shouldRouteTo(source, destination);
    }

    @Override
    public RadioSource prepareSource(RadioSource source, RadioRouter destination) {
        if (source.frequencingType == -1) {
            float transmissionPower = this.getPower(this.frequency.modulation);
            source.frequencingType = this.frequencingType.id;
            source.transmissionCap = transmissionPower;
            source.addPower(transmissionPower);
        }
        return super.prepareSource(source, destination);
    }

    @Override
    public void accept(RadioSource source) {
        if (!this.active) {
            return;
        }
        if (this.acceptCriteria != null && !this.acceptCriteria.test(source)) {
            return;
        }
        this.route(source, router -> source.owner == null || !source.owner.equals(router.reference));
    }
}

