/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class SandwichNameHelper {
    public static Component getSandwichDisplayName(ItemStack stack) {
        boolean isOpenFacedSandwich;
        String sandwichType;
        SandwichItemHandler sandwich = SandwichItemHandler.get((ICapabilityProvider)stack).orElse(new SandwichItemHandler());
        List<ItemStack> contents = sandwich.getItems();
        if (sandwich == null || sandwich.getItemCount() == 0 || !ForgeRegistries.ITEMS.tags().isKnownTagName(ModTags.SANDWICH_BREAD) || !ForgeRegistries.ITEMS.tags().isKnownTagName(ModTags.BURGER_BUNS)) {
            return SandwichNameHelper.translate("base", "sandwich");
        }
        int breadCount = SandwichNameHelper.countItems(contents, ModTags.SANDWICH_BREAD);
        int bunCount = SandwichNameHelper.countItems(contents, ModTags.BURGER_BUNS);
        String string = sandwichType = bunCount > breadCount - bunCount ? "burger" : "sandwich";
        if (contents.size() == breadCount) {
            return SandwichNameHelper.getBreadSandwichName(contents, sandwichType);
        }
        List<ItemStack> uniqueIngredients = SandwichNameHelper.getUniqueIngredientsExcludingBread(contents);
        List<ItemStack> potions = uniqueIngredients.stream().filter(item -> item.m_150930_(Items.f_42589_)).toList();
        if (potions.size() == 1) {
            return SandwichNameHelper.getPotionSandwichName(potions.get(0), sandwichType);
        }
        boolean bl = isOpenFacedSandwich = breadCount == 1 && contents.size() > 1;
        if (!uniqueIngredients.isEmpty() && uniqueIngredients.size() <= 3) {
            Component ingredientList = SandwichNameHelper.listIngredients(uniqueIngredients);
            if (sandwich.isDoubleDeckerSandwich()) {
                return SandwichNameHelper.translateWithArg("double_decker", "with_ingredients", sandwichType, ingredientList);
            }
            if (isOpenFacedSandwich) {
                return SandwichNameHelper.translateWithArg("open_faced", "with_ingredients", sandwichType, ingredientList);
            }
            return SandwichNameHelper.translateWithArg("base", "with_ingredients", sandwichType, ingredientList);
        }
        if (sandwich.isDoubleDeckerSandwich()) {
            return SandwichNameHelper.translate("double_decker", sandwichType);
        }
        if (isOpenFacedSandwich) {
            return SandwichNameHelper.translate("open_faced", sandwichType);
        }
        return SandwichNameHelper.translate("base", sandwichType);
    }

    private static List<ItemStack> getUniqueIngredientsExcludingBread(List<ItemStack> sandwich) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack ingredient : sandwich) {
            if (ingredient.m_204117_(ModTags.SANDWICH_BREAD) || !result.stream().noneMatch(stack -> ItemStack.m_41728_((ItemStack)ingredient, (ItemStack)stack))) continue;
            result.add(ingredient);
        }
        return result;
    }

    private static int countItems(List<ItemStack> sandwich, TagKey<Item> tagKey) {
        int result = 0;
        for (ItemStack ingredient : sandwich) {
            if (!ingredient.m_204117_(tagKey)) continue;
            ++result;
        }
        return result;
    }

    private static Component getBreadSandwichName(List<ItemStack> contents, String sandwichType) {
        if (contents.size() == 3 && contents.get(0).m_41720_() != ModItems.TOASTED_BREAD_SLICE.get() && contents.get(1).m_41720_() == ModItems.TOASTED_BREAD_SLICE.get() && contents.get(2).m_41720_() != ModItems.TOASTED_BREAD_SLICE.get()) {
            return SandwichNameHelper.translateWithArg("base", "with_ingredients", sandwichType, Ingredients.getDisplayName(contents.get(1)));
        }
        return SandwichNameHelper.translate("only_bread", sandwichType);
    }

    private static Component listIngredients(List<ItemStack> ingredients) {
        List<Component> ingredientNames = ingredients.stream().map(Ingredients::getDisplayName).toList();
        return SomeAssemblyRequired.translate("tooltip.ingredient_list.%s".formatted(ingredientNames.size()), ingredientNames.toArray());
    }

    private static Component translateWithArg(Object ... keys) {
        return Component.m_237110_((String)SandwichNameHelper.translationKey(Arrays.copyOfRange(keys, 0, keys.length - 1)), (Object[])new Object[]{keys[keys.length - 1]});
    }

    private static Component translate(Object ... keys) {
        return Component.m_237115_((String)SandwichNameHelper.translationKey(keys));
    }

    private static String translationKey(Object ... keys) {
        StringBuilder builder = new StringBuilder("item.%s.sandwich".formatted("some_assembly_required"));
        for (Object key : keys) {
            builder.append('.');
            builder.append(key);
        }
        return builder.toString();
    }

    private static Component getPotionSandwichName(ItemStack potionItem, String sandwichType) {
        Potion potion = PotionUtils.m_43579_((ItemStack)potionItem);
        if (potion != Potions.f_43598_) {
            ResourceLocation id = Objects.requireNonNull(BuiltInRegistries.f_256980_.m_7981_((Object)potion));
            String key = SandwichNameHelper.translationKey("potion", "with_id", id.m_135827_(), id.m_135815_(), sandwichType);
            if (I18n.m_118936_((String)key)) {
                return Component.m_237115_((String)key);
            }
        }
        String potionKey = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion).m_41778_();
        int i = 1;
        do {
            Pattern pattern = Pattern.compile(I18n.m_118938_((String)SandwichNameHelper.translationKey("potion", "pattern", i), (Object[])new Object[0]));
            String replacement = I18n.m_118938_((String)SandwichNameHelper.translationKey("potion", "pattern", i, sandwichType), (Object[])new Object[0]);
            Matcher matcher = pattern.matcher(I18n.m_118938_((String)potionKey, (Object[])new Object[0]));
            if (!matcher.matches()) continue;
            return Component.m_237113_((String)matcher.replaceAll(replacement));
        } while (I18n.m_118936_((String)SandwichNameHelper.translationKey("potion", "pattern", ++i)));
        return SandwichNameHelper.translateWithArg("base", "with_ingredients", sandwichType, SandwichNameHelper.listIngredients(List.of(potionItem)));
    }
}

