/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageData;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageUpdateMessage;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.entity.StorageHolderBase;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.upgrades.hopper.HopperUpgradeItem;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedLimitedBarrelContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.common.MountedStorageContainerMenu;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.network.MountedStorageOpennessMessage;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.network.StorageCreatePacketHandler;
import net.p3pp3rf1y.sophisticatedstoragecreateintegration.storage.MountedSophisticatedStorage;

public class MountedStorageHolder
extends StorageHolderBase {
    private final Consumer<ItemStack> storageStackSetter;
    private final Supplier<ItemStack> storageStackGetter;
    @Nullable
    private WeakReference<Entity> contraptionEntity = null;
    private BlockPos localPos = BlockPos.f_121853_;
    private BlockPos chestOtherPartPos = BlockPos.f_121853_;
    private Vec3 position = Vec3.f_82478_;
    @Nullable
    private WeakReference<Level> level = null;
    private boolean clearedNbt = false;
    @Nullable
    private WeakReference<IStorageWrapper> otherHalfStorageWrapper = null;
    private boolean refreshClientBlockRender = false;
    private boolean dirty = false;

    public MountedStorageHolder(Supplier<ItemStack> storageStackGetter, Consumer<ItemStack> storageStackSetter) {
        super(false);
        this.storageStackGetter = storageStackGetter;
        this.storageStackSetter = storageStackSetter;
        this.updateRenderAttributes = true;
    }

    public void setLocalPos(BlockPos localPos) {
        this.localPos = localPos;
    }

    public void setStorageItem(ItemStack storageItem) {
        super.setStorageItem(storageItem);
        this.dirty = true;
    }

    protected boolean isOwnContainer(Player player) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof MountedStorageContainerMenu) {
            MountedStorageContainerMenu mountedStorageContainerMenu = (MountedStorageContainerMenu)abstractContainerMenu;
            return mountedStorageContainerMenu.getContraptionEntity().map(c -> c == this.getEntity() && (mountedStorageContainerMenu.getLocalPos().equals((Object)this.localPos) || mountedStorageContainerMenu.getLocalPos().equals((Object)this.chestOtherPartPos))).orElse(false);
        }
        return false;
    }

    protected IStorageSavedData getStorageData(UUID storageId) {
        return MountedStorageData.get((UUID)storageId);
    }

    protected void setSyncedStorageStack(ItemStack storageStack) {
        this.storageStackSetter.accept(storageStack);
    }

    protected ItemStack getSyncedStorageStack() {
        return this.storageStackGetter.get();
    }

    protected boolean isLocked(ItemStack storageItem) {
        return NBTHelper.getBoolean((ItemStack)storageItem, (String)"locked").orElse(false);
    }

    @Nullable
    protected Level getLevel() {
        return this.level == null ? null : (Level)this.level.get();
    }

    public void setLevel(Level level) {
        this.level = new WeakReference<Level>(level);
        if (!level.m_5776_()) {
            this.getStorageWrapper().getRenderInfo().setDisplayItemsChangeListener(ri -> this.updateClientBlockRender());
        }
    }

    public void updateClientBlockRender() {
        this.refreshClientBlockRender = true;
    }

    public void tick(Entity entity) {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            this.sendStorageUpdatePayload();
        } else if (level != null && level.m_5776_() && this.refreshClientBlockRender) {
            this.refreshClientBlockRender = false;
            Entity entity2 = this.getEntity();
            if (entity2 instanceof AbstractContraptionEntity) {
                AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity2;
                contraptionEntity.getContraption().deferInvalidate = true;
            }
        }
        super.tick(entity);
    }

    public void sendStorageUpdatePayload() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        Entity entity = this.getEntity();
        if (entity == null || entity.m_9236_().m_5776_()) {
            return;
        }
        PacketHandler.INSTANCE.sendToAllTracking((Object)new MountedStorageUpdateMessage(entity.m_19879_(), this.localPos, this.getSyncedStorageStack(), this.refreshClientBlockRender && this.isBarrel()), entity);
    }

    protected Vec3 getPosition() {
        return this.position;
    }

    public void setPosition(Vec3 position) {
        this.position = position;
    }

    @Nullable
    protected Entity getEntity() {
        return this.contraptionEntity == null ? null : (Entity)this.contraptionEntity.get();
    }

    public void setContraptionEntity(Entity entity) {
        this.contraptionEntity = new WeakReference<Entity>(entity);
    }

    @Nullable
    protected StorageBlockEntity retrieveRenderBlockEntity() {
        Entity e = this.getEntity();
        if (e instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)e;
            return (StorageBlockEntity)abstractContraptionEntity.getContraption().presentBlockEntities.get(this.localPos);
        }
        return null;
    }

    protected boolean isUpgradeRunnable(ItemStack upgrade) {
        return !(upgrade.m_41720_() instanceof HopperUpgradeItem);
    }

    protected void refreshRenderBlockEntity() {
        StorageBlockEntity renderBlockEntity = this.retrieveRenderBlockEntity();
        if (renderBlockEntity != null) {
            this.updateRenderBlockEntityAttributes(this.getSyncedStorageStack(), renderBlockEntity);
        }
    }

    protected void updateRenderBlockEntityAttributes(ItemStack storageItem, StorageBlockEntity renderBlockEntity) {
        Entity entity;
        if (this.updateRenderAttributes && (entity = this.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity cEntity = (AbstractContraptionEntity)entity;
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)cEntity.getContraption().getBlocks().get(this.localPos);
            renderBlockEntity.m_155250_(blockInfo.f_74676_());
        }
        super.updateRenderBlockEntityAttributes(storageItem, renderBlockEntity);
    }

    protected void setLocked(boolean locked) {
        this.getSyncedStorageStack().m_41784_().m_128379_("locked", locked);
    }

    protected AABB getPickupBoundingBox() {
        return new AABB(this.getPosition(), this.getPosition().m_82520_(1.0, 1.0, 1.0)).m_82400_(0.2);
    }

    protected void openMenu(Player player) {
        Entity e = this.getEntity();
        if (e == null || !(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((w, p, pl) -> this.createMenu(w, pl, e.m_19879_(), this.localPos), this.getSyncedStorageStack().m_41786_()), buffer -> {
            buffer.writeInt(e.m_19879_());
            buffer.m_130064_(this.localPos);
        });
    }

    private MountedStorageContainerMenuBase createMenu(int id, Player pl, int contraptionEntityId, BlockPos localPos) {
        if (MovingStorageWrapper.isLimitedBarrel((ItemStack)this.getSyncedStorageStack())) {
            return new MountedLimitedBarrelContainerMenu(id, pl, contraptionEntityId, localPos);
        }
        return new MountedStorageContainerMenu(id, pl, contraptionEntityId, localPos);
    }

    protected void playSound(SoundEvent sound) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        Vec3 position = this.getPosition().m_82520_(0.5, 0.5, 0.5);
        level.m_6263_(null, position.m_7096_(), position.m_7098_(), position.m_7094_(), sound, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    void initEntityLevelAndPositions(MovementContext context) {
        if (this.getEntity() == null) {
            AbstractContraptionEntity entity = context.contraption.entity;
            BlockPos localPos = context.localPos;
            Vec3 position = context.position;
            Level level = context.world;
            this.initEntityLevelAndPositions(entity, localPos, level, position, context.state);
        }
    }

    public void initEntityLevelAndPositions(AbstractContraptionEntity abstractContraptionEntity, BlockPos localPos, Level level, Vec3 position, BlockState state) {
        this.setContraptionEntity((Entity)abstractContraptionEntity);
        this.setLocalPos(localPos);
        this.setLevel(level);
        this.setPosition(position);
        if (this.isChest() && state.m_61143_((Property)ChestBlock.TYPE) != ChestType.SINGLE) {
            Object v;
            this.chestOtherPartPos = localPos.m_121945_(ChestBlock.getConnectedDirection((BlockState)state));
            boolean bl = this.isMainStorage = state.m_61143_((Property)ChestBlock.TYPE) == ChestType.RIGHT;
            if (!this.isMainStorage && level.m_5776_() && (v = abstractContraptionEntity.getContraption().presentBlockEntities.get(localPos)) instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)v;
                chestBlockEntity.setMainPos(this.chestOtherPartPos);
            }
        }
    }

    public void clearNbt() {
        Entity entity;
        if (!this.clearedNbt && (entity = this.getEntity()) instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity abstractContraptionEntity = (AbstractContraptionEntity)entity;
            abstractContraptionEntity.getContraption().getBlocks().computeIfPresent(this.localPos, (p, blockInfo) -> new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), blockInfo.f_74676_(), null));
            this.clearedNbt = true;
        }
    }

    public void startOpen(Player player, Entity entity) {
        super.startOpen(player, entity);
        if (this.isChest() && this.isMainStorage && this.chestOtherPartPos != BlockPos.f_121853_) {
            this.getHolderOfOtherHalf(this.chestOtherPartPos).ifPresent(holder -> holder.startOpen(player, entity));
        }
    }

    protected void sendOpenness(Entity entity) {
        StorageCreatePacketHandler.INSTANCE.sendToAllTracking(new MountedStorageOpennessMessage(entity.m_19879_(), this.isDoubleChest() && !this.isMainStorage ? this.chestOtherPartPos : this.localPos, this.isOpen()), entity);
    }

    private Optional<StorageHolderBase> getHolderOfOtherHalf() {
        if (this.isChest() && this.chestOtherPartPos != BlockPos.f_121853_) {
            return this.getHolderOfOtherHalf(this.chestOtherPartPos).map(MountedStorageHolder.class::cast);
        }
        return Optional.empty();
    }

    private Optional<MountedStorageHolder> getHolderOfOtherHalf(BlockPos otherHalfLocalPos) {
        AbstractContraptionEntity abstractContraptionEntity;
        MountedStorageBase mountedStorageBase;
        Entity e = this.getEntity();
        if (e instanceof AbstractContraptionEntity && (mountedStorageBase = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)(abstractContraptionEntity = (AbstractContraptionEntity)e), (BlockPos)otherHalfLocalPos)) instanceof MountedSophisticatedStorage) {
            MountedSophisticatedStorage mountedSophisticatedStorage = (MountedSophisticatedStorage)mountedStorageBase;
            return Optional.of(mountedSophisticatedStorage.getStorageHolder());
        }
        return Optional.empty();
    }

    public void stopOpen(Player player, Entity entity) {
        super.stopOpen(player, entity);
        if (this.isChest() && this.isMainStorage && this.chestOtherPartPos != BlockPos.f_121853_) {
            this.getHolderOfOtherHalf(this.chestOtherPartPos).ifPresent(holder -> holder.stopOpen(player, entity));
        }
    }

    public IStorageWrapper getMainStorageWrapper() {
        if (this.isMainStorage) {
            return this.getStorageWrapper();
        }
        if (this.otherHalfStorageWrapper == null || this.otherHalfStorageWrapper.get() == null) {
            Object wrapper = this.getEntity() == null || this.getEntity().m_9236_().m_5776_() ? NoopStorageWrapper.INSTANCE : this.getHolderOfOtherHalf(this.chestOtherPartPos).map(StorageHolderBase::getStorageWrapper).orElse((IStorageWrapper)NoopStorageWrapper.INSTANCE);
            this.otherHalfStorageWrapper = new WeakReference<NoopStorageWrapper>((NoopStorageWrapper)wrapper);
            return wrapper;
        }
        return (IStorageWrapper)this.otherHalfStorageWrapper.get();
    }

    public void updateState() {
        Entity entity = this.getEntity();
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity cEntity = (AbstractContraptionEntity)entity;
            entity = this.getSyncedStorageStack().m_41720_();
            if (entity instanceof StorageBlockItem) {
                StorageBlockItem storageBlockItem = (StorageBlockItem)entity;
                StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)cEntity.getContraption().getBlocks().get(this.localPos);
                BlockState newBlockState = storageBlockItem.m_40614_().m_49966_();
                for (Map.Entry entry : blockInfo.f_74676_().m_61148_().entrySet()) {
                    newBlockState = this.setStateValue(newBlockState, (Property)entry.getKey(), entry.getValue());
                }
                cEntity.setBlock(this.localPos, new StructureTemplate.StructureBlockInfo(blockInfo.f_74675_(), newBlockState, blockInfo.f_74677_()));
            }
        }
    }

    private <T extends Comparable<T>> BlockState setStateValue(BlockState state, Property<T> property, Object value) {
        return (BlockState)state.m_61124_(property, (Comparable)value);
    }

    public void setDirty() {
        this.dirty = true;
    }

    public Optional<StorageHolderBase> getAuxiliaryStorageHolder() {
        return this.isMainStorage ? this.getHolderOfOtherHalf() : Optional.of(this);
    }

    public StorageHolderBase getMainStorageHolder() {
        return this.isMainStorage ? super.getMainStorageHolder() : this.getHolderOfOtherHalf().orElse(this);
    }

    public boolean isDoubleChest() {
        return this.isChest() && this.chestOtherPartPos != BlockPos.f_121853_;
    }

    public void setShouldBeOpen(boolean shouldBeOpen) {
        super.setShouldBeOpen(shouldBeOpen);
        if (this.isDoubleChest() && this.isMainStorage) {
            this.getHolderOfOtherHalf().ifPresent(holder -> holder.setShouldBeOpen(shouldBeOpen));
        }
    }
}

