/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.ArmorParts;

import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.CustomModelArmorData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BaseArmorRenderingBit {
    public final EquipmentSlot slot;
    public final Item item;
    public final Supplier<EntityModel<LivingEntity>> model;
    public final Supplier<ModelPart> part;
    public final float x;
    public final float y;
    public final float z;
    public final float expand;
    public final float Xspin;
    public final float Yspin;
    public final float Zspin;

    public BaseArmorRenderingBit(EquipmentSlot slot, Item item, Supplier<EntityModel<LivingEntity>> model, Supplier<ModelPart> part, float x, float y, float z, float expand, float xspin, float yspin, float zspin) {
        this.slot = slot;
        this.item = item;
        this.model = model;
        this.part = part;
        this.x = x;
        this.y = y;
        this.z = z;
        this.expand = expand;
        this.Xspin = xspin;
        this.Yspin = yspin;
        this.Zspin = zspin;
    }

    public BaseArmorRenderingBit(EquipmentSlot slot, Item item, Supplier<EntityModel<LivingEntity>> model, Supplier<ModelPart> part, float x, float y, float z, float expand) {
        this(slot, item, model, part, x, y, z, expand, 0.0f, 0.0f, 0.0f);
    }

    public ItemStack stack(LivingEntity livingEntity) {
        return livingEntity.m_6844_(this.slot);
    }

    protected VertexConsumer consumer(MultiBufferSource source, CustomModelArmorData data, HumanoidModel<LivingEntity> model, LivingEntity livingEntity) {
        return ItemRenderer.m_115222_((MultiBufferSource)source, (RenderType)model.m_103119_(data.getTextureLocation()), (boolean)false, (boolean)this.stack(livingEntity).m_41790_());
    }

    public void tickMovement(LivingEntity livingEntity, PoseStack poseStack, HumanoidModel<LivingEntity> model, int light, MultiBufferSource buffer) {
        float blue;
        float green;
        float red;
        Object armorData;
        ItemStack itemStack = this.stack(livingEntity);
        Item item = itemStack.m_41720_();
        if (item instanceof SporeArmorData) {
            armorData = (SporeArmorData)item;
            int color = armorData.getVariant(itemStack).getColor();
            red = (float)(color >> 16 & 0xFF) / 255.0f;
            green = (float)(color >> 8 & 0xFF) / 255.0f;
            blue = (float)(color & 0xFF) / 255.0f;
        } else {
            red = 1.0f;
            blue = 1.0f;
            green = 1.0f;
        }
        Item color = itemStack.m_41720_();
        if (color instanceof CustomModelArmorData) {
            armorData = (CustomModelArmorData)color;
            if (itemStack.m_41720_().equals(this.item)) {
                VertexConsumer consumer = this.consumer(buffer, (CustomModelArmorData)armorData, model, livingEntity);
                this.applyTransformEx(poseStack, this.getPiece(model), this.x, this.y, this.z, this.expand, this.Xspin, this.Yspin, this.Zspin, () -> this.part.get().m_104306_(poseStack, consumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f));
            }
        }
    }

    protected abstract ModelPart getPiece(HumanoidModel<LivingEntity> var1);

    protected void applyTransformEx(PoseStack poseStack, ModelPart origin, float x, float y, float z, float scale, float xSpin, float ySpin, float ZSpin, Runnable render) {
        poseStack.m_85836_();
        origin.m_104299_(poseStack);
        poseStack.m_252880_(x, y, z);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xSpin));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(ySpin));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(ZSpin));
        render.run();
        poseStack.m_85849_();
    }
}

