/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Layers;

import com.Harbinger.Spore.Client.Models.NuckelaveArmorModel;
import com.Harbinger.Spore.Client.Models.NuckelaveModel;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Nuclealave;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.client.ForgeHooksClient;

public class NucleaChestplateLayer<T extends Nuclealave>
extends RenderLayer<T, NuckelaveModel<T>> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final TextureAtlas armorTrimAtlas;
    public final NuckelaveArmorModel<T> Nucklemodel;
    public final List<ModelPart> helmetModels = new ArrayList<ModelPart>();
    public final List<ModelPart> chestModels = new ArrayList<ModelPart>();
    public final List<ModelPart> pantsModels = new ArrayList<ModelPart>();
    public final List<ModelPart> bootsModels = new ArrayList<ModelPart>();
    private static final ResourceLocation BLOOD_LAYER1 = new ResourceLocation("spore", "textures/overlay/blood_overlay.png");
    private static final ResourceLocation BLOOD_LAYER2 = new ResourceLocation("spore", "textures/overlay/blood_overlay_2.png");

    public NucleaChestplateLayer(RenderLayerParent<T, NuckelaveModel<T>> p_117346_, EntityModelSet set, ModelManager manager) {
        super(p_117346_);
        this.Nucklemodel = new NuckelaveArmorModel(set.m_171103_(NuckelaveArmorModel.LAYER_LOCATION));
        this.armorTrimAtlas = manager.m_119428_(Sheets.f_265912_);
        this.helmetModels.add(((NuckelaveModel)this.m_117386_()).HeadWear);
        this.chestModels.add(((NuckelaveModel)this.m_117386_()).LeftArmWear);
        this.chestModels.add(((NuckelaveModel)this.m_117386_()).RightArmWear);
        this.pantsModels.add(((NuckelaveModel)this.m_117386_()).BackRightLegWear);
        this.pantsModels.add(((NuckelaveModel)this.m_117386_()).FrontRightLegWear);
        this.bootsModels.add(((NuckelaveModel)this.m_117386_()).BackLeftFootWear);
        this.bootsModels.add(((NuckelaveModel)this.m_117386_()).FrontRightFootWear);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int value, T type, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        this.renderArmorBuffer(type, stack, bufferSource, value);
        this.renderToBufferPerArmorPiece(type, stack, bufferSource, value, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void renderToBufferPerArmorPiece(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderArmorPart(entity, EquipmentSlot.HEAD, this.helmetModels, poseStack, bufferSource, packedLight, packedOverlay, red, green, blue, alpha);
        this.renderArmorPart(entity, EquipmentSlot.CHEST, this.chestModels, poseStack, bufferSource, packedLight, packedOverlay, red, green, blue, alpha);
        this.renderArmorPart(entity, EquipmentSlot.LEGS, this.pantsModels, poseStack, bufferSource, packedLight, packedOverlay, red, green, blue, alpha);
        this.renderArmorPart(entity, EquipmentSlot.FEET, this.bootsModels, poseStack, bufferSource, packedLight, packedOverlay, red, green, blue, alpha);
    }

    private void renderArmorPart(T entity, EquipmentSlot slot, List<ModelPart> parts, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        ItemStack itemStack = entity.m_6844_(slot);
        boolean flag = itemStack.m_41790_();
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            if (armorItem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armorItem).m_41121_(itemStack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderArmor(parts, stack, bufferSource, packedLight, OverlayTexture.f_118083_, f, f1, f2, 1.0f, this.getArmorResource((Entity)entity, itemStack, slot, null), flag, slot);
            } else {
                this.renderArmor(parts, stack, bufferSource, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)entity, itemStack, slot, null), flag, slot);
            }
            ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemStack).ifPresent(p_289638_ -> this.renderTrim(armorItem.m_40401_(), stack, bufferSource, packedLight, (ArmorTrim)p_289638_, parts, flag));
        }
    }

    private void renderArmor(List<ModelPart> parts, PoseStack stack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, ResourceLocation location, boolean glint, EquipmentSlot slot) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)location));
        ((NuckelaveModel)this.m_117386_()).Nuckelavee.m_171331_().forEach(modelPart -> this.setInvisible((ModelPart)modelPart, parts));
        ((NuckelaveModel)this.m_117386_()).Nuckelavee.m_104306_(stack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (glint) {
            ((NuckelaveModel)this.m_117386_()).Nuckelavee.m_104306_(stack, bufferSource.m_6299_(RenderType.m_110496_()), packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.renderBloodLayer(((NuckelaveModel)this.m_117386_()).Nuckelavee, slot, stack, bufferSource, packedLight);
    }

    private void setInvisible(ModelPart part, List<ModelPart> parts) {
        part.f_233556_ = !parts.contains(part);
    }

    private void renderBloodLayer(ModelPart part, EquipmentSlot slot, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)(slot == EquipmentSlot.LEGS ? BLOOD_LAYER2 : BLOOD_LAYER1)));
        part.m_104301_(stack, consumer, packedLight, OverlayTexture.f_118083_);
    }

    public void renderArmorBuffer(T entity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        ItemStack itemStack = entity.m_6844_(EquipmentSlot.CHEST);
        boolean flag = itemStack.m_41790_();
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            if (armorItem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armorItem).m_41121_(itemStack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.RenderChestplate(poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, f, f1, f2, 1.0f, this.getArmorResource((Entity)entity, itemStack, EquipmentSlot.CHEST, null), flag);
            } else {
                this.RenderChestplate(poseStack, bufferSource, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)entity, itemStack, EquipmentSlot.CHEST, null), flag);
            }
            ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemStack).ifPresent(p_289638_ -> this.renderTrim(armorItem.m_40401_(), poseStack, bufferSource, packedLight, (ArmorTrim)p_289638_, flag));
        }
    }

    private void RenderChestplate(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, ResourceLocation location, boolean glint) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)location));
        this.Nucklemodel.ChestPlate.m_104306_(poseStack, consumer, packedLight, packedOverlay, red, green, blue, alpha);
        if (glint) {
            this.Nucklemodel.ChestPlate.m_104306_(poseStack, bufferSource.m_6299_(RenderType.m_110496_()), packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.renderBloodLayer(this.Nucklemodel.ChestPlate, EquipmentSlot.CHEST, poseStack, bufferSource, packedLight);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, slot == EquipmentSlot.LEGS ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }

    private void renderTrim(ArmorMaterial material, PoseStack stack, MultiBufferSource source, int light, ArmorTrim armorTrim, List<ModelPart> parts, boolean flag) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(flag ? armorTrim.m_267774_(material) : armorTrim.m_267606_(material));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(source.m_6299_(Sheets.m_266442_()));
        ((NuckelaveModel)this.m_117386_()).Nuckelavee.m_171331_().forEach(modelPart -> this.setInvisible((ModelPart)modelPart, parts));
        ((NuckelaveModel)this.m_117386_()).Nuckelavee.m_104306_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTrim(ArmorMaterial material, PoseStack stack, MultiBufferSource source, int light, ArmorTrim armorTrim, boolean flag) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(flag ? armorTrim.m_267774_(material) : armorTrim.m_267606_(material));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(source.m_6299_(Sheets.m_266442_()));
        this.Nucklemodel.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

