/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.SlasherModel;
import com.Harbinger.Spore.Client.Models.SmasherSlasherModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Slasher;
import com.Harbinger.Spore.Sentities.Variants.SlasherVariants;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SlasherRenderer<Type extends Slasher>
extends BaseInfectedRenderer<Type, EntityModel<Type>> {
    private final EntityModel<Type> defaultModel;
    private final EntityModel<Type> smasher;
    public static final Map<SlasherVariants, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(SlasherVariants.class), p_114874_ -> {
        p_114874_.put(SlasherVariants.DEFAULT, new ResourceLocation("spore", "textures/entity/slasher.png"));
        p_114874_.put(SlasherVariants.PIERCER, new ResourceLocation("spore", "textures/entity/piercer.png"));
        p_114874_.put(SlasherVariants.SMASHER, new ResourceLocation("spore", "textures/entity/smasher_slasher.png"));
    });
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/slasher.png");

    public SlasherRenderer(EntityRendererProvider.Context context) {
        super(context, new SlasherModel(context.m_174023_(SlasherModel.LAYER_LOCATION)), 0.5f);
        this.defaultModel = this.f_115290_;
        this.smasher = new SmasherSlasherModel<Type>(context.m_174023_(SmasherSlasherModel.LAYER_LOCATION));
    }

    public void render(Type type, float value1, float value2, PoseStack stack, MultiBufferSource bufferSource, int light) {
        this.f_115290_ = ((Slasher)type).getVariant() == SlasherVariants.SMASHER ? this.smasher : this.defaultModel;
        super.m_7392_(type, value1, value2, stack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE.get((Object)((Slasher)entity).getVariant());
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }
}

