/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Seffects;
import com.Harbinger.Spore.Core.Sentities;
import com.Harbinger.Spore.Core.Sparticles;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Damage.SdamageTypes;
import com.Harbinger.Spore.ExtremelySusThings.ChunkLoaderHelper;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityVigilCall;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamityPathNavigation;
import com.Harbinger.Spore.Sentities.ArmorPersentageBypass;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.MovementControls.CalamityMovementControl;
import com.Harbinger.Spore.Sentities.Organoids.Mound;
import com.Harbinger.Spore.Sentities.Utility.CorpseEntity;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class Calamity
extends UtilityEntity
implements Enemy,
ArmorPersentageBypass {
    public static final EntityDataAccessor<Integer> KILLS = SynchedEntityData.m_135353_(Calamity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> MUTATION = SynchedEntityData.m_135353_(Calamity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<BlockPos> SEARCH_AREA = SynchedEntityData.m_135353_(Calamity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Boolean> ROOTED = SynchedEntityData.m_135353_(Calamity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected int breakCounter;
    private int stun = 0;
    private static final List<BlockState> states = List.of(((Block)Sblocks.BIOMASS_BLOCK.get()).m_49966_(), ((Block)Sblocks.ROOTED_BIOMASS.get()).m_49966_(), ((Block)Sblocks.CALCIFIED_BIOMASS_BLOCK.get()).m_49966_(), ((Block)Sblocks.SICKEN_BIOMASS_BLOCK.get()).m_49966_(), ((Block)Sblocks.REMAINS.get()).m_49966_());

    public Calamity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
        this.f_21344_ = new CalamityPathNavigation(this, level);
        this.f_21342_ = new CalamityMovementControl((Mob)this, 20);
        this.f_21364_ = 50;
    }

    protected int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 25;
    }

    public void setStun(int i) {
        this.stun = i;
    }

    public boolean isStunned() {
        return this.stun > 0;
    }

    @Override
    public boolean m_7327_(Entity entity) {
        if (super.m_7327_(entity)) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Utilities.doCustomModifiersAfterEffects((LivingEntity)this, livingEntity);
                livingEntity.m_147207_(new MobEffectInstance((MobEffect)Seffects.MYCELIUM.get(), 600, 1), (Entity)this);
            }
            return true;
        }
        return false;
    }

    @Override
    public DamageSource getCustomDamage(LivingEntity entity) {
        if (Math.random() < 0.5) {
            return SdamageTypes.calamity_damage1((LivingEntity)this);
        }
        if (Math.random() < 0.5) {
            return SdamageTypes.calamity_damage2((LivingEntity)this);
        }
        return SdamageTypes.calamity_damage3((LivingEntity)this);
    }

    public void m_6710_(@Nullable LivingEntity p_21544_) {
        super.m_6710_(p_21544_);
        if (this.isRooted()) {
            this.setRooted(false);
        }
    }

    protected void tickPart(CalamityMultipart part, double e, double i, double o) {
        part.m_6034_(this.m_20185_() + e, this.m_20186_() + i, this.m_20189_() + o);
    }

    protected void tickPart(CalamityMultipart part, Vec3 vec3i) {
        Vec3 vec3 = vec3i.m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        part.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
    }

    protected void tickPart(CalamityMultipart part, Vec3 vec3i, double Y) {
        Vec3 vec3 = vec3i.m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        part.m_6034_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + Y, this.m_20189_() + vec3.f_82481_);
    }

    public void m_5993_(Entity entity, int i, DamageSource damageSource) {
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        this.f_19804_.m_135381_(KILLS, (Object)((Integer)this.f_19804_.m_135370_(KILLS) + 1));
        if (this.canCalcify(entity) && armor != null) {
            armor.m_22100_(armor.m_22135_() + 1.0);
        }
        super.m_5993_(entity, i, damageSource);
    }

    public void m_7023_(Vec3 p_32858_) {
        if (this.m_21515_() && this.isInFluidType()) {
            this.m_19920_(0.1f, p_32858_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.7));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_32858_);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("kills", ((Integer)this.f_19804_.m_135370_(KILLS)).intValue());
        tag.m_128405_("mutation", ((Integer)this.f_19804_.m_135370_(MUTATION)).intValue());
        tag.m_128379_("rooted", ((Boolean)this.f_19804_.m_135370_(ROOTED)).booleanValue());
        tag.m_128405_("AreaX", this.getSearchArea().m_123341_());
        tag.m_128405_("AreaY", this.getSearchArea().m_123342_());
        tag.m_128405_("AreaZ", this.getSearchArea().m_123343_());
    }

    public void setMutationColor() {
        int value = this.colorMap().isEmpty() ? 0 : Utilities.mixColors(this.colorMap());
        this.f_19804_.m_135381_(MUTATION, (Object)value);
    }

    public int getMutationColor() {
        return (Integer)this.f_19804_.m_135370_(MUTATION);
    }

    Map<Integer, Float> colorMap() {
        HashMap<Integer, Float> values = new HashMap<Integer, Float>();
        float toxic = this.getAtLevel(this.m_21051_((Attribute)SAttributes.TOXICITY.get()));
        float rejuvenation = this.getAtLevel(this.m_21051_((Attribute)SAttributes.REJUVENATION.get()));
        float local = this.getAtLevel(this.m_21051_((Attribute)SAttributes.LOCALIZATION.get()));
        float laceration = this.getAtLevel(this.m_21051_((Attribute)SAttributes.LACERATION.get()));
        float corrosive = this.getAtLevel(this.m_21051_((Attribute)SAttributes.CORROSIVES.get()));
        float ballistic = this.getAtLevel(this.m_21051_((Attribute)SAttributes.BALLISTIC.get()));
        float grinding = this.getAtLevel(this.m_21051_((Attribute)SAttributes.GRINDING.get()));
        if (toxic > 0.0f) {
            values.put(-16751104, Float.valueOf(toxic));
        }
        if (rejuvenation > 0.0f) {
            values.put(-10092442, Float.valueOf(rejuvenation));
        }
        if (local > 0.0f) {
            values.put(-6711040, Float.valueOf(local));
        }
        if (laceration > 0.0f) {
            values.put(-65536, Float.valueOf(laceration));
        }
        if (corrosive > 0.0f) {
            values.put(-13369549, Float.valueOf(corrosive));
        }
        if (ballistic > 0.0f) {
            values.put(-10066330, Float.valueOf(ballistic));
        }
        if (grinding > 0.0f) {
            values.put(-16764058, Float.valueOf(grinding));
        }
        return values;
    }

    public float getAtLevel(AttributeInstance instance) {
        if (instance != null) {
            return (float)instance.m_22135_();
        }
        return 0.0f;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    public void setSearchArea(BlockPos blockPos) {
        this.f_19804_.m_135381_(SEARCH_AREA, (Object)blockPos);
    }

    public BlockPos getSearchArea() {
        return (BlockPos)this.f_19804_.m_135370_(SEARCH_AREA);
    }

    public void setKills(Integer count) {
        this.f_19804_.m_135381_(KILLS, (Object)count);
    }

    public int getKills() {
        return (Integer)this.f_19804_.m_135370_(KILLS);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(KILLS, (Object)tag.m_128451_("kills"));
        this.f_19804_.m_135381_(MUTATION, (Object)tag.m_128451_("mutation"));
        this.f_19804_.m_135381_(ROOTED, (Object)tag.m_128471_("rooted"));
        int i = tag.m_128451_("AreaX");
        int j = tag.m_128451_("AreaY");
        int k = tag.m_128451_("AreaZ");
        this.setSearchArea(new BlockPos(i, j, k));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROOTED, (Object)false);
        this.f_19804_.m_135372_(KILLS, (Object)0);
        this.f_19804_.m_135372_(MUTATION, (Object)0);
        this.f_19804_.m_135372_(SEARCH_AREA, (Object)BlockPos.f_121853_);
    }

    public boolean canCalcify(Entity entity) {
        return entity.m_6095_().m_204039_(EntityTypeTags.f_13120_);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRooted() {
        return (Boolean)this.f_19804_.m_135370_(ROOTED);
    }

    public void setRooted(boolean value) {
        this.f_19804_.m_135381_(ROOTED, (Object)value);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new GoToLocation(this, 1.1));
        this.addTargettingGoals();
        this.f_21345_.m_25352_(7, (Goal)new CalamityVigilCall(this));
    }

    public double getDamageCap() {
        return 0.0;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.setRooted(false);
        if (this.m_217043_().m_188503_(20) == 0) {
            this.grief(this.m_20191_().m_82377_(this.setInflation(), 0.0, this.setInflation()));
        }
        if ((double)amount > this.getDamageCap() && this.getDamageCap() > 0.0) {
            return super.m_6469_(source, (float)this.getDamageCap());
        }
        if (source.m_276093_(DamageTypes.f_268444_) && Math.random() < (double)0.2f) {
            Calamity.forceStart(Calamity.findGoal((Mob)this, SporeBurstSupport.class));
        }
        return super.m_6469_(source, amount);
    }

    public static void forceStart(Goal goal) {
        try {
            Method m = Goal.class.getDeclaredMethod("start", new Class[0]);
            m.setAccessible(true);
            m.invoke((Object)goal, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends Goal> T findGoal(Mob mob, Class<T> goalClass) {
        for (WrappedGoal wrapped : mob.f_21345_.m_148105_()) {
            if (!goalClass.isInstance(wrapped.m_26015_())) continue;
            return (T)((Goal)goalClass.cast(wrapped.m_26015_()));
        }
        return null;
    }

    public boolean tryToDigDown() {
        if (this.getSearchArea() != BlockPos.f_121853_ && this.f_201939_) {
            double x = (double)Math.abs(this.getSearchArea().m_123341_()) - Math.abs(this.m_20185_());
            double z = (double)Math.abs(this.getSearchArea().m_123343_()) - Math.abs(this.m_20189_());
            return (double)this.getSearchArea().m_123342_() < this.m_20186_() && Math.abs(x) < 6.0 && Math.abs(z) < 6.0;
        }
        return false;
    }

    public void relocateExitPoint() {
        RandomSource randomSource = RandomSource.m_216327_();
        if ((double)this.getSearchArea().m_123342_() > this.m_20186_() && (double)Math.abs(this.getSearchArea().m_123341_()) - Math.abs(this.m_20185_()) < 6.0 && (double)Math.abs(this.getSearchArea().m_123343_()) - Math.abs(this.m_20189_()) < 6.0 && (double)Math.abs(this.getSearchArea().m_123342_()) - Math.abs(this.m_20186_()) > 4.0) {
            int f = (int)Math.abs((double)Math.abs(this.getSearchArea().m_123342_()) - Math.abs(this.m_20186_()));
            int x = randomSource.m_216339_(-f, f);
            int z = randomSource.m_216339_(-f, f);
            this.setSearchArea(new BlockPos(this.getSearchArea().m_123341_() + x, this.getSearchArea().m_123342_(), this.getSearchArea().m_123343_() + z));
        }
    }

    public double setInflation() {
        return 1.5;
    }

    public AABB getMiningHitbox() {
        if (this.getSearchArea() != BlockPos.f_121853_ && this.m_5448_() == null) {
            if ((double)this.getSearchArea().m_123342_() < this.m_20186_()) {
                return this.m_20191_().m_82377_(this.setInflation(), 0.0, this.setInflation()).m_82386_(0.0, -1.0, 0.0);
            }
            if ((double)this.getSearchArea().m_123342_() > this.m_20186_()) {
                return this.m_20191_().m_82377_(this.setInflation(), 0.0, this.setInflation()).m_82386_(0.0, 1.0, 0.0);
            }
            return this.m_20191_().m_82377_(this.setInflation(), 0.0, this.setInflation());
        }
        return this.m_20191_().m_82377_(this.setInflation(), 0.0, this.setInflation()).m_82386_(0.0, 1.0, 0.0);
    }

    protected void grief(AABB aabb) {
        boolean flag = false;
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (Utilities.biomass().contains(blockstate)) {
                flag = this.m_9236_().m_7731_(blockpos, ((Block)Sblocks.MEMBRANE_BLOCK.get()).m_49966_(), 3) || flag;
                this.breakCounter = 0;
                continue;
            }
            if (!(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) < (float)this.getDestroySpeed()) || !(blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos) >= 0.0f) || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) continue;
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
            this.breakCounter = 0;
        }
    }

    public void ActivateAdaptation() {
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (this.f_19797_ % 1200 == 0) {
            this.setRooted(this.m_5448_() == null && (double)this.m_21223_() <= (double)this.m_21233_() * 0.3 && this.m_20096_());
            if (this.isRooted()) {
                this.setKills(this.getKills() + 1);
            }
        }
        if (this.isRooted()) {
            this.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.0, 1.0, 0.0));
        }
        if (this.m_217043_().m_188503_(300) == 0 && this.getSearchArea() != BlockPos.f_121853_) {
            this.relocateExitPoint();
        }
        if (this.breakCounter < 80) {
            ++this.breakCounter;
        } else if (this.m_21225_() == this.m_269291_().m_269325_() || this.m_21225_() == this.m_269291_().m_269318_() || this.f_19862_ || this.tryToDigDown()) {
            this.grief(this.getMiningHitbox());
        }
        if (this.stun > 0 && this.m_20096_() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            --this.stun;
            this.m_7601_(Blocks.f_50016_.m_49966_(), new Vec3(0.0, 1.0, 0.0));
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 1.2;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 1.25 * 5.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 1.2;
            serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)Sparticles.BLOOD_PARTICLE.get()), x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
        }
        if (this.m_21223_() < this.m_21233_() && !this.m_21023_(MobEffects.f_19605_) && this.getKills() > 0) {
            int level2 = this.m_21223_() < this.m_21233_() / 2.0f ? 1 : 0;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, level2 + this.calculateHealing()));
            this.setKills(this.getKills() - 1);
        }
    }

    private int calculateHealing() {
        AttributeInstance toxic = this.m_21051_((Attribute)SAttributes.REJUVENATION.get());
        if (toxic != null) {
            double level = toxic.m_22135_();
            if (level < 1.0) {
                return 0;
            }
            return (int)level;
        }
        return 0;
    }

    public int getDestroySpeed() {
        return (Integer)SConfig.SERVER.calamity_bd.get();
    }

    @Override
    public float amountOfDamage(float value) {
        AttributeInstance attack;
        double e;
        float extra = 0.0f;
        AttributeInstance penetration = this.m_21051_((Attribute)SAttributes.LACERATION.get());
        if (penetration != null && (e = penetration.m_22135_()) >= 1.0) {
            extra = (float)(e * (double)0.1f);
        }
        return (attack = this.m_21051_(Attributes.f_22281_)) == null ? value : (float)(attack.m_22135_() * (double)(0.2f + extra));
    }

    public void m_6667_(DamageSource source) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double x0 = this.m_20185_() - ((double)this.f_19796_.m_188501_() - 0.1) * 3.2;
            double y0 = this.m_20186_() + ((double)this.f_19796_.m_188501_() - 0.25) * 3.25 * 5.0;
            double z0 = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.1) * 3.2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123812_, x0, y0, z0, 4, 0.0, 0.0, 0.0, 1.0);
        }
        this.m_216990_((SoundEvent)Ssounds.CALAMITY_DEATH.get());
        super.m_6667_(source);
        this.summonBiomass();
        this.m_146870_();
    }

    private void SummonMound(Entity entity) {
        Mound mound = new Mound((EntityType<? extends PathfinderMob>)((EntityType)Sentities.MOUND.get()), entity.m_9236_());
        mound.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        mound.setMaxAge(4);
        entity.m_9236_().m_7967_((Entity)mound);
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.CALAMITY_DAMAGE.get();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        this.setDefaultAdaptation(serverLevelAccessor);
        this.setMutationColor();
        return super.m_6518_(serverLevelAccessor, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    public void setDefaultAdaptation(ServerLevelAccessor level) {
        ServerLevel serverLevel;
        SporeSavedData data;
        if (level instanceof ServerLevel && (data = SporeSavedData.getDataLocation(serverLevel = (ServerLevel)level)) != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get()) {
            this.ActivateAdaptation();
        }
    }

    public boolean m_147207_(MobEffectInstance instance, @Nullable Entity entity) {
        if (instance.m_19544_().m_19483_() == MobEffectCategory.HARMFUL && instance.m_19564_() < 1) {
            return false;
        }
        return super.m_147207_(instance, entity);
    }

    public List<ItemStack> getDroppedItems(int val) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.getDropList() == null || this.getDropList().isEmpty()) {
            return drops;
        }
        for (String string : this.getDropList()) {
            int quantity;
            ResourceLocation itemId;
            Item item;
            String[] parts = string.split("\\|");
            if (parts.length < 4 || (item = (Item)ForgeRegistries.ITEMS.getValue(itemId = new ResourceLocation(parts[0]))) == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item);
            int minCount = Integer.parseUnsignedInt(parts[2]);
            int maxCount = Integer.parseUnsignedInt(parts[3]);
            int chancePercent = Integer.parseUnsignedInt(parts[1]) + val * 10;
            if (minCount == maxCount) {
                quantity = val > 0 ? this.f_19796_.m_216339_(maxCount, maxCount + val) : maxCount;
            } else if (minCount >= 1 && maxCount >= 1) {
                float scale = 1.0f + 0.15f * (float)val;
                int adjustedMax = (int)((float)maxCount * scale);
                quantity = this.f_19796_.m_216339_(minCount, adjustedMax + 1);
            } else {
                quantity = 1;
            }
            if (!(this.f_19796_.m_188501_() < (float)chancePercent / 100.0f)) continue;
            stack.m_41764_(quantity);
            drops.add(stack);
        }
        return drops;
    }

    public List<HitboxesForParts> parts() {
        return List.of();
    }

    public boolean getAdaptation() {
        return false;
    }

    @Override
    protected void m_7472_(DamageSource source, int val, boolean bool) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        List<ItemStack> loot = this.getDroppedItems(val);
        List<HitboxesForParts> partList = this.parts();
        if (partList.isEmpty() || loot.isEmpty()) {
            return;
        }
        int partCount = partList.size();
        ArrayList<List<ItemStack>> distributedLoot = new ArrayList<List<ItemStack>>();
        for (int i = 0; i < partCount; ++i) {
            distributedLoot.add(new ArrayList());
        }
        for (ItemStack stack : loot) {
            int baseAmount = stack.m_41613_() / partCount;
            int remainder = stack.m_41613_() % partCount;
            for (int i = 0; i < partCount; ++i) {
                int amount = baseAmount + (i < remainder ? 1 : 0);
                if (amount <= 0) continue;
                ((List)distributedLoot.get(i)).add(stack.m_255036_(amount));
            }
        }
        this.summonCorpsePart(partCount, distributedLoot, partList);
    }

    public void summonCorpsePart(int partCount, List<List<ItemStack>> distributedLoot, List<HitboxesForParts> partList) {
        for (int i = 0; i < partCount; ++i) {
            CorpseEntity partEntity = new CorpseEntity((EntityType)Sentities.CORPSE_PIECE.get(), this.m_9236_());
            for (ItemStack stack : distributedLoot.get(i)) {
                partEntity.addToInventory(stack);
            }
            partEntity.setColor(this.getMutationColor());
            partEntity.m_20219_(this.m_20182_());
            partEntity.m_20256_(new Vec3((this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.9, this.f_19796_.m_188500_() * 0.6 + 0.3, (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.9));
            partEntity.setOwnerAda(this.getAdaptation());
            partEntity.setCorpseType(partList.get(i).getID());
            this.m_9236_().m_7967_((Entity)partEntity);
        }
    }

    public HitboxesForParts calculateChance(HitboxesForParts part, float val) {
        if (Math.random() < (double)val) {
            return part;
        }
        return null;
    }

    private void summonBiomass() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockState = this.m_9236_().m_8055_(blockpos);
            if (!blockState.m_60795_() || !(Math.random() < (double)0.1f)) continue;
            BlockState state = states.get(this.f_19796_.m_188503_(states.size()));
            FallingBlockEntity.m_201971_((Level)this.m_9236_(), (BlockPos)blockpos, (BlockState)state);
        }
    }

    public static class GoToLocation
    extends Goal {
        public final Calamity infected;
        public final double speed;
        public int tryTicks;

        public GoToLocation(Calamity infected1, double speed) {
            this.infected = infected1;
            this.speed = speed;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        protected void moveMobToBlock() {
            this.infected.m_21573_().m_26519_((double)this.infected.getSearchArea().m_123341_() + 0.5, (double)(this.infected.getSearchArea().m_123342_() + 1), (double)this.infected.getSearchArea().m_123343_() + 0.5, 1.0);
        }

        public boolean m_8036_() {
            if (this.infected.getSearchArea() != BlockPos.f_121853_ && this.infected.getSearchArea() != null && this.infected.m_5448_() == null) {
                return this.infected.getSearchArea().m_203193_((Position)this.infected.m_20182_()) > 4.0;
            }
            return false;
        }

        public void m_8056_() {
            this.moveMobToBlock();
            this.tryTicks = 0;
            super.m_8056_();
        }

        public boolean m_8045_() {
            return this.infected.m_5448_() == null;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            if (this.infected.getSearchArea() != BlockPos.f_121853_ && this.shouldRecalculatePath()) {
                this.moveMobToBlock();
            }
            if (this.infected.getSearchArea() != BlockPos.f_121853_ && this.infected.getSearchArea().m_203193_((Position)this.infected.m_20182_()) < 20.0) {
                Level level = this.infected.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    SectionPos pos = SectionPos.m_123199_((BlockPos)this.infected.getSearchArea());
                    ChunkLoaderHelper.unloadChunk(serverLevel, this.infected.getSearchArea(), pos.m_123170_(), pos.m_123222_(), true);
                }
                this.infected.setSearchArea(BlockPos.f_121853_);
                this.infected.SummonMound((Entity)this.infected);
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 40 == 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

