/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.Calamities;

import com.Harbinger.Spore.Core.SAttributes;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.Sentities.AI.AOEMeleeAttackGoal;
import com.Harbinger.Spore.Sentities.AI.AerialRangedGoal;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.CalamityInfectedCommand;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SporeBurstSupport;
import com.Harbinger.Spore.Sentities.AI.CalamitiesAI.SummonScentInCombat;
import com.Harbinger.Spore.Sentities.AI.FlyingWanderAround;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.BaseEntities.CalamityMultipart;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import com.Harbinger.Spore.Sentities.FlyingInfected;
import com.Harbinger.Spore.Sentities.HitboxesForParts;
import com.Harbinger.Spore.Sentities.Projectile.ThrownTumor;
import com.Harbinger.Spore.Sentities.TrueCalamity;
import com.Harbinger.Spore.Sentities.Utility.TumoroidNuke;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class Hinderburg
extends Calamity
implements FlyingInfected,
TrueCalamity,
RangedAttackMob {
    public static final EntityDataAccessor<Boolean> ADAPTATION = SynchedEntityData.m_135353_(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DROPPED_BOMBS = SynchedEntityData.m_135353_(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> BOMB = SynchedEntityData.m_135353_(Hinderburg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int bomb_timer = -1;
    private final CalamityMultipart[] subEntities;
    public final CalamityMultipart lowerbody;
    public final CalamityMultipart forwardbody;
    public final CalamityMultipart rightcannon;
    public final CalamityMultipart leftcannon;
    public final CalamityMultipart mouth;
    private final List<HitboxesForParts> innatePartList = List.of(HitboxesForParts.HINDEN_FRONT, HitboxesForParts.HINDEN_BACK, HitboxesForParts.MAW, HitboxesForParts.RIGHT_CANNON, HitboxesForParts.LEFT_CANNON);

    public Hinderburg(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.lowerbody = new CalamityMultipart(this, "lowerbody", 4.0f, 4.0f);
        this.forwardbody = new CalamityMultipart(this, "forwardbody", 4.0f, 4.0f);
        this.rightcannon = new CalamityMultipart(this, "rightcannon", 1.5f, 1.5f);
        this.leftcannon = new CalamityMultipart(this, "leftcannon", 1.5f, 1.5f);
        this.mouth = new CalamityMultipart(this, "mouth", 3.0f, 0.5f);
        this.subEntities = new CalamityMultipart[]{this.lowerbody, this.forwardbody, this.rightcannon, this.leftcannon, this.mouth};
        this.f_21342_ = new HindenMovementController(this);
        this.f_21365_ = new HindenLookControl((Mob)this);
        this.m_20234_(f_19843_.getAndAdd(this.subEntities.length + 1) + 1);
    }

    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        return false;
    }

    @Override
    public void m_7023_(Vec3 vec) {
        if (this.m_20096_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
        }
        if (this.m_21515_() && !this.m_20096_()) {
            this.m_19920_(0.1f, vec);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.95));
        } else {
            super.m_7023_(vec);
        }
    }

    @Override
    public boolean canCalcify(Entity entity) {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    public void m_20234_(int p_20235_) {
        super.m_20234_(p_20235_);
        for (int i = 0; i < this.subEntities.length; ++i) {
            this.subEntities[i].m_20234_(p_20235_ + i + 1);
        }
    }

    @Override
    public double setInflation() {
        return 1.0;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 20 == 0) {
            if (this.getKills() >= 50 && this.getDroppedBombs() >= 5 && !this.isAdapted()) {
                this.f_19804_.m_135381_(ADAPTATION, (Object)true);
            }
            if (this.isAdapted()) {
                AABB aabb = this.m_20191_().m_82400_(8.0);
                List entities = this.m_9236_().m_45933_((Entity)this, aabb);
                for (Entity entity : entities) {
                    LivingEntity living;
                    if (!(entity instanceof LivingEntity) || (living = (LivingEntity)entity) instanceof Infected || living instanceof UtilityEntity || ((List)SConfig.SERVER.blacklist.get()).contains(living.m_20078_())) continue;
                    living.m_20254_(5);
                }
            }
        }
        if (this.getBomb() < 2450) {
            int value = this.isAdapted() ? 2 : 1;
            this.setBomb(this.getBomb() + value);
        }
        if (this.getBombTimer() >= 0) {
            this.tickBomb();
            if (this.getBombTimer() == 1) {
                Hinderburg entity = this.m_5448_() != null ? this.m_5448_() : this;
                entity.m_216990_((SoundEvent)Ssounds.HINDEN_NUKE.get());
            }
            if (this.getBombTimer() >= 80) {
                this.SummonNuke();
                this.bomb_timer = -1;
            }
        }
    }

    public int getBombTimer() {
        return this.bomb_timer;
    }

    public void tickBomb() {
        ++this.bomb_timer;
    }

    public int getDroppedBombs() {
        return (Integer)this.f_19804_.m_135370_(DROPPED_BOMBS);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (Double)SConfig.SERVER.hinden_hp.get() * (Double)SConfig.SERVER.global_health.get()).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22284_, (Double)SConfig.SERVER.hinden_armor.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22281_, (Double)SConfig.SERVER.hinden_damage.get() * (Double)SConfig.SERVER.global_armor.get()).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_((Attribute)SAttributes.TOXICITY.get(), 0.0).m_22268_((Attribute)SAttributes.REJUVENATION.get(), 0.0).m_22268_((Attribute)SAttributes.LOCALIZATION.get(), 0.0).m_22268_((Attribute)SAttributes.LACERATION.get(), 0.0).m_22268_((Attribute)SAttributes.CORROSIVES.get(), 0.0).m_22268_((Attribute)SAttributes.BALLISTIC.get(), 0.0).m_22268_((Attribute)SAttributes.GRINDING.get(), 0.0);
    }

    @Override
    public boolean hurt(CalamityMultipart calamityMultipart, DamageSource source, float value) {
        if (calamityMultipart == this.mouth) {
            this.m_6469_(source, value * 2.0f);
        } else if (calamityMultipart == this.rightcannon || calamityMultipart == this.leftcannon) {
            this.m_6469_(source, value * 3.0f);
        } else {
            this.m_6469_(source, value);
        }
        return true;
    }

    @Override
    public int chemicalRange() {
        return 32;
    }

    @Override
    public List<? extends String> buffs() {
        return (List)SConfig.SERVER.hinden_buffs.get();
    }

    @Override
    public List<? extends String> debuffs() {
        return (List)SConfig.SERVER.hinden_debuffs.get();
    }

    @Override
    public List<? extends String> getDropList() {
        return (List)SConfig.DATAGEN.hindie_loot.get();
    }

    @Override
    public void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, TumoroidNuke.class, 10.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new AerialRangedGoal(this, 1.3, this.isAdapted() ? 20 : 40, 16.0f, 5, 10){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && this.target != null && (this.target.m_20096_() || this.target.isInFluidType());
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new AOEMeleeAttackGoal(this, 1.0, true, 2.0, 6.0f, livingEntity -> this.TARGET_SELECTOR.test(livingEntity)));
        this.f_21345_.m_25352_(6, (Goal)new CalamityInfectedCommand(this));
        this.f_21345_.m_25352_(7, (Goal)new SummonScentInCombat(this));
        this.f_21345_.m_25352_(8, (Goal)new SporeBurstSupport(this));
        this.f_21345_.m_25352_(9, (Goal)new FlyingWanderAround(this, 0.5));
        super.m_8099_();
    }

    @Override
    public void ActivateAdaptation() {
        this.setKills(this.getKills() + 50);
        this.f_19804_.m_135381_(DROPPED_BOMBS, (Object)((Integer)this.f_19804_.m_135370_(DROPPED_BOMBS) + 5));
    }

    public void m_8107_() {
        float f14 = this.m_146908_() * ((float)Math.PI / 180);
        float f2 = Mth.m_14031_((float)f14);
        float f15 = Mth.m_14089_((float)f14);
        Vec3[] avec3 = new Vec3[this.subEntities.length];
        for (int j = 0; j < this.subEntities.length; ++j) {
            avec3[j] = new Vec3(this.subEntities[j].m_20185_(), this.subEntities[j].m_20186_(), this.subEntities[j].m_20189_());
        }
        this.tickPart(this.forwardbody, f2 * -5.0f, 0.0, f15 * 5.0f);
        this.tickPart(this.lowerbody, f2 * 5.0f, 0.0, f15 * -5.0f);
        this.tickPart(this.mouth, f2 * -0.5f, -0.5, f15 * 0.5f);
        this.tickPart(this.rightcannon, new Vec3(0.0, 0.0, 4.0), 0.3);
        this.tickPart(this.leftcannon, new Vec3(0.0, 0.0, -4.0), 0.3);
        for (int l = 0; l < this.subEntities.length; ++l) {
            this.subEntities[l].f_19854_ = avec3[l].f_82479_;
            this.subEntities[l].f_19855_ = avec3[l].f_82480_;
            this.subEntities[l].f_19856_ = avec3[l].f_82481_;
            this.subEntities[l].f_19790_ = avec3[l].f_82479_;
            this.subEntities[l].f_19791_ = avec3[l].f_82480_;
            this.subEntities[l].f_19792_ = avec3[l].f_82481_;
        }
        super.m_8107_();
        if (this.isAdapted()) {
            for (int i = 0; i < 360; ++i) {
                if (i % 40 != 0) continue;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.cos(i) * 0.25, 0.25, Math.sin(i) * 0.25);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.sin(i) * 0.25, -0.25, Math.cos(i) * 0.25);
            }
        }
    }

    public CalamityMultipart[] getSubEntities() {
        return this.subEntities;
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.subEntities;
    }

    public void m_141965_(ClientboundAddEntityPacket p_218825_) {
        super.m_141965_(p_218825_);
    }

    public boolean isAdapted() {
        return (Boolean)this.f_19804_.m_135370_(ADAPTATION);
    }

    @Override
    public double getDamageCap() {
        return (Double)SConfig.SERVER.hinden_dpsr.get();
    }

    public boolean tryToSummonNUKE(Entity entity) {
        if (entity != null && this.isArmed()) {
            double x = Math.abs(entity.m_20185_()) - Math.abs(this.m_20185_());
            double z = Math.abs(entity.m_20189_()) - Math.abs(this.m_20189_());
            return entity.m_20186_() < this.m_20186_() && Math.abs(x) < 10.0 && Math.abs(z) < 10.0;
        }
        return false;
    }

    public void SummonNuke() {
        TumoroidNuke tnt = new TumoroidNuke(this.m_9236_(), this);
        tnt.setOverclocked((Boolean)this.f_19804_.m_135370_(ADAPTATION));
        tnt.setBuster(Math.random() < 0.2);
        this.f_19804_.m_135381_(DROPPED_BOMBS, (Object)((Integer)this.f_19804_.m_135370_(DROPPED_BOMBS) + 1));
        this.m_9236_().m_7967_((Entity)tnt);
        this.setBomb(0);
    }

    public int m_8100_() {
        return 200;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Ssounds.HINDEN_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Ssounds.INF_DAMAGE.get();
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12361_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BOMB, (Object)0);
        this.f_19804_.m_135372_(DROPPED_BOMBS, (Object)0);
        this.f_19804_.m_135372_(ADAPTATION, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("bomb", ((Integer)this.f_19804_.m_135370_(BOMB)).intValue());
        tag.m_128405_("dropped_bombs", ((Integer)this.f_19804_.m_135370_(DROPPED_BOMBS)).intValue());
        tag.m_128379_("adaptation", ((Boolean)this.f_19804_.m_135370_(ADAPTATION)).booleanValue());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(BOMB, (Object)tag.m_128451_("bomb"));
        this.f_19804_.m_135381_(DROPPED_BOMBS, (Object)tag.m_128451_("dropped_bombs"));
        this.f_19804_.m_135381_(ADAPTATION, (Object)tag.m_128471_("adaptation"));
    }

    public int getBomb() {
        return (Integer)this.f_19804_.m_135370_(BOMB);
    }

    public void setBomb(int i) {
        this.f_19804_.m_135381_(BOMB, (Object)i);
    }

    public boolean isArmed() {
        return this.getBomb() >= 2400;
    }

    @Override
    public boolean tryToDigDown() {
        return super.tryToDigDown() || this.f_19863_;
    }

    public void m_6504_(LivingEntity livingEntity, float p_33318_) {
        if (!this.m_9236_().f_46443_) {
            ThrownTumor tumor = new ThrownTumor(this.m_9236_(), (LivingEntity)this);
            double dx = livingEntity.m_20185_() - this.m_20185_();
            double dy = livingEntity.m_20186_() + (double)livingEntity.m_20192_() - 1.5;
            double dz = livingEntity.m_20189_() - this.m_20189_();
            Vec3 vec3 = this.f_19796_.m_188501_() < 0.3f ? new Vec3(2.0, 1.3, 5.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f) : (this.f_19796_.m_188501_() < 0.3f ? new Vec3(2.0, 1.3, -5.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f) : new Vec3(0.0, -2.0, 0.0).m_82524_(-this.m_146908_() * ((float)Math.PI / 180) - 1.5707964f));
            if (SConfig.SERVER.hinden_explosive_effects != null) {
                List ev = (List)SConfig.SERVER.hinden_explosive_effects.get();
                for (int i = 0; i < 1; ++i) {
                    int randomIndex = this.f_19796_.m_188503_(ev.size());
                    ResourceLocation randomElement1 = new ResourceLocation((String)ev.get(randomIndex));
                    MobEffect randomElement = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(randomElement1);
                    tumor.setMobEffect(randomElement);
                }
            }
            tumor.setExplode(Level.ExplosionInteraction.MOB);
            tumor.m_6027_(this.m_20185_() + vec3.m_7096_(), this.m_20186_() + vec3.m_7098_(), this.m_20189_() + vec3.m_7094_());
            tumor.m_6686_(dx, dy - tumor.m_20186_() + Math.hypot(dx, dz) * (double)0.05f, dz, 2.0f, 12.0f);
            this.m_9236_().m_7967_((Entity)tumor);
            this.m_20256_(this.m_20184_().m_82549_(new Vec3(dx, dy, dz).m_82541_().m_82490_(0.2)));
        }
    }

    @Override
    public boolean m_7327_(Entity entity) {
        this.m_216990_((SoundEvent)Ssounds.SIEGER_BITE.get());
        return super.m_7327_(entity);
    }

    @Override
    public String getMutation() {
        if (this.isAdapted()) {
            return "spore.entity.variant.overclocked";
        }
        return super.getMutation();
    }

    @Override
    public boolean getAdaptation() {
        return this.isAdapted();
    }

    @Override
    public List<HitboxesForParts> parts() {
        ArrayList<HitboxesForParts> values = new ArrayList<HitboxesForParts>();
        for (HitboxesForParts hitboxes : this.innatePartList) {
            HitboxesForParts part = this.calculateChance(hitboxes, 0.75f);
            if (part == null) continue;
            values.add(part);
        }
        return values;
    }

    private static class HindenMovementController
    extends MoveControl {
        private final Hinderburg mob;
        private int floatDuration;

        public HindenMovementController(Hinderburg mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.mob.m_217043_().m_188503_(4) + 2;
                Vec3 vec3 = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
                vec3 = vec3.m_82541_();
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(vec3.m_82490_(0.1)));
            }
            if (this.f_24981_ == MoveControl.Operation.WAIT && !this.m_24995_() && this.mob.m_5448_() == null) {
                this.mob.m_20256_(this.mob.m_20184_().m_82520_(0.0, -0.01, 0.0));
            }
        }
    }

    private static class HindenLookControl
    extends LookControl {
        public HindenLookControl(Mob mob) {
            super(mob);
        }

        public void m_8128_() {
            super.m_8128_();
            if (this.f_24937_.m_5448_() == null) {
                if (this.f_24937_.f_19797_ % 40 == 0) {
                    Vec3 vec3 = this.f_24937_.m_20184_();
                    this.f_24937_.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                    this.f_24937_.f_20883_ = this.f_24937_.m_146908_();
                }
            } else {
                LivingEntity livingentity = this.f_24937_.m_5448_();
                if (livingentity.m_20280_((Entity)this.f_24937_) < 4096.0) {
                    double d1 = livingentity.m_20185_() - this.f_24937_.m_20185_();
                    double d2 = livingentity.m_20189_() - this.f_24937_.m_20189_();
                    this.f_24937_.m_146922_(-((float)Mth.m_14136_((double)d1, (double)d2)) * 57.295776f);
                    this.f_24937_.f_20883_ = this.f_24937_.m_146908_();
                }
            }
        }
    }
}

