/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.data.tag;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.supermartijn642.core.codec.CodecHelper;
import com.supermartijn642.core.data.tag.CustomTagEntry;
import com.supermartijn642.core.data.tag.CustomTagEntrySerializer;
import com.supermartijn642.core.data.tag.TagEntryAdapter;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagEntry;

public class CustomTagEntries {
    public static void init() {
        TagEntry.f_215911_ = Codec.either(CodecHelper.jsonSerializerToCodec(input -> {
            JsonObject json = new JsonObject();
            CustomTagEntrySerializer<?> serializer = input.customEntry.getSerializer();
            json.addProperty("type", Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getIdentifier(serializer).toString());
            try {
                serializer.serialize(json, input.customEntry);
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst serializing custom tag entry for type '" + Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getIdentifier(serializer).toString() + "'!");
            }
            return json;
        }, element -> {
            Object customEntry;
            if (!(element instanceof JsonObject)) {
                throw new JsonParseException("Entry must be an object!");
            }
            JsonObject json = (JsonObject)element;
            if (!(json.has("type") && json.get("type").isJsonPrimitive() && json.getAsJsonPrimitive("type").isString())) {
                throw new JsonParseException("Missing string key 'type'!");
            }
            String typeString = json.get("type").getAsString();
            if (!RegistryUtil.isValidIdentifier(typeString)) {
                throw new JsonParseException("Invalid identifier '" + typeString + "'!");
            }
            ResourceLocation type = new ResourceLocation(typeString);
            if (!Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.hasIdentifier(type)) {
                throw new JsonParseException("Unknown custom tag entry serializer '" + typeString + "'!");
            }
            CustomTagEntrySerializer<?> serializer = Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getValue(type);
            try {
                customEntry = serializer.deserialize(json);
            }
            catch (JsonParseException e) {
                throw new JsonParseException("Encountered an exception whilst deserializing custom tag entry for type '" + type + "'!", (Throwable)e);
            }
            return new TagEntryAdapter(type, (CustomTagEntry)customEntry);
        }), (Codec)TagEntry.f_215911_).xmap(either -> (TagEntry)either.map(Function.identity(), Function.identity()), tagEntry -> tagEntry instanceof TagEntryAdapter ? Either.left((Object)((Object)((TagEntryAdapter)((Object)tagEntry)))) : Either.right((Object)tagEntry));
    }

    static TagEntry wrap(CustomTagEntry customEntry) {
        return new TagEntryAdapter(Registries.CUSTOM_TAG_ENTRY_SERIALIZERS.getIdentifier(customEntry.getSerializer()), customEntry);
    }
}

