/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.createmod.catnip.math.VecHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.integration.CreateCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BambooSpikesBehavior
implements MovementBehaviour {
    private static final BambooSpikesBlockTile DUMMY = new BambooSpikesBlockTile(BlockPos.f_121853_, ModRegistry.BAMBOO_SPIKES.get().m_49966_());

    public boolean isSameDir(MovementContext context) {
        return VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)((Direction)context.state.m_61143_((Property)BambooSpikesBlock.FACING)));
    }

    public void tick(MovementContext context) {
        this.damageEntities(context);
    }

    public void damageEntities(MovementContext context) {
        Level world = context.world;
        Vec3 pos = context.position;
        DamageSource damageSource = BambooSpikesBlock.getDamageSource(world);
        block0: for (Entity entity : world.m_45976_(Entity.class, new AABB(pos.m_82520_(-0.5, -0.5, -0.5), pos.m_82520_(0.5, 0.5, 0.5)))) {
            Object player;
            if (entity instanceof ItemEntity || entity instanceof AbstractContraptionEntity || entity instanceof Player && (player = (Player)entity).m_7500_()) continue;
            if (entity instanceof AbstractMinecart) {
                player = entity.m_146897_().iterator();
                while (player.hasNext()) {
                    Entity passenger = (Entity)player.next();
                    if (!CreateCompat.isContraption(context, passenger)) continue;
                    continue block0;
                }
            }
            if (entity.m_6084_() && entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!world.f_46443_) {
                    double pow = 5.0 * Math.pow(context.relativeMotion.m_82553_(), 0.4) + 1.0;
                    float damage = !this.isSameDir(context) ? 1.0f : (float)Mth.m_14008_((double)pow, (double)2.0, (double)6.0);
                    entity.m_6469_(damageSource, damage);
                    this.doTileStuff(context, world, livingEntity);
                }
            }
            if (world.f_46443_ != entity instanceof Player) continue;
            Vec3 motionBoost = context.motion.m_82520_(0.0, context.motion.m_82553_() / 4.0, 0.0);
            int maxBoost = 4;
            if (motionBoost.m_82553_() > (double)maxBoost) {
                motionBoost = motionBoost.m_82546_(motionBoost.m_82541_().m_82490_(motionBoost.m_82553_() - (double)maxBoost));
            }
            entity.m_20256_(entity.m_20184_().m_82549_(motionBoost));
            entity.f_19864_ = true;
        }
    }

    private void doTileStuff(MovementContext context, @NotNull Level world, LivingEntity le) {
        CompoundTag com = context.blockEntityData;
        if (com == null) {
            return;
        }
        long lastTicked = com.m_128454_("LastTicked");
        if (!this.isOnCooldown(world, lastTicked)) {
            DUMMY.m_142466_(com);
            if (DUMMY.interactWithEntity(le, world)) {
                CreateCompat.changeState(context, (BlockState)context.state.m_61124_((Property)BambooSpikesBlock.TIPPED, (Comparable)Boolean.valueOf(false)));
            }
            com = DUMMY.m_187480_();
            lastTicked = world.m_46467_();
            com.m_128356_("LastTicked", lastTicked);
            context.blockEntityData = com;
        }
    }

    public boolean isOnCooldown(Level world, long lastTicked) {
        return world.m_46467_() - lastTicked < 20L;
    }
}

