/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.entity;

public class ReloadState {
    public static final int NOT_RELOADING_COUNTDOWN = -1;
    protected StateType stateType;
    protected long countDown;

    public ReloadState() {
        this.stateType = StateType.NOT_RELOADING;
        this.countDown = -1L;
    }

    public ReloadState(ReloadState src) {
        this.stateType = src.stateType;
        this.countDown = src.countDown;
    }

    public StateType getStateType() {
        return this.stateType;
    }

    public void setStateType(StateType stateType) {
        this.stateType = stateType;
    }

    public long getCountDown() {
        if (this.stateType == StateType.NOT_RELOADING) {
            return -1L;
        }
        return this.countDown;
    }

    public void setCountDown(long countDown) {
        this.countDown = countDown;
    }

    public boolean equals(Object o) {
        if (o instanceof ReloadState) {
            ReloadState reloadState = (ReloadState)o;
            return reloadState.stateType.equals((Object)this.stateType) && reloadState.countDown == this.countDown;
        }
        return false;
    }

    public static enum StateType {
        NOT_RELOADING,
        EMPTY_RELOAD_FEEDING,
        EMPTY_RELOAD_FINISHING,
        TACTICAL_RELOAD_FEEDING,
        TACTICAL_RELOAD_FINISHING;


        public boolean isReloadingEmpty() {
            return this == EMPTY_RELOAD_FEEDING || this == EMPTY_RELOAD_FINISHING;
        }

        public boolean isReloadingTactical() {
            return this == TACTICAL_RELOAD_FEEDING || this == TACTICAL_RELOAD_FINISHING;
        }

        public boolean isReloading() {
            return this.isReloadingEmpty() || this.isReloadingTactical();
        }

        public boolean isReloadFinishing() {
            return this == EMPTY_RELOAD_FINISHING || this == TACTICAL_RELOAD_FINISHING;
        }
    }
}

