/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.client.gui.GunSmithTableScreen;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GunPackList
extends ContainerObjectSelectionList<Entry> {
    private final GunSmithTableScreen parent;
    private final List<Checkbox> gunPackList = new ArrayList<Checkbox>();
    private final Set<String> selectedNamespaces = new HashSet<String>();
    private final Checkbox byHandCheckbox;
    private final EditBox byName;

    public GunPackList(Minecraft pMinecraft, int pWidth, int pHeight, int pY0, int pY1, int pItemHeight, Map<ResourceLocation, List<ResourceLocation>> recipes, final GunSmithTableScreen parent) {
        super(pMinecraft, pWidth, pHeight, pY0, pY1, pItemHeight);
        this.m_93488_(false);
        this.m_93496_(false);
        this.parent = parent;
        HashSet namespaces = new HashSet();
        for (List<ResourceLocation> entry : recipes.values()) {
            entry.forEach(resourceLocation -> namespaces.add(resourceLocation.m_135827_()));
        }
        this.byName = new EditBox(pMinecraft.f_91062_, 3, 0, 94, 10, (Component)Component.m_237119_());
        this.byName.m_257771_((Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.filter.search"));
        this.byName.m_94151_(pText -> {
            parent.m_7856_();
            parent.setIndexPage(0);
        });
        this.m_7085_((AbstractSelectionList.Entry)new Entry((AbstractWidget)this.byName));
        this.byHandCheckbox = new Checkbox(0, 0, 10, 10, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.filter.handgun"), false){

            @Override
            public void m_5691_() {
                super.m_5691_();
                parent.m_7856_();
                parent.setIndexPage(0);
            }
        };
        this.m_7085_((AbstractSelectionList.Entry)new Entry((AbstractWidget)this.byHandCheckbox));
        final Checkbox checkbox1 = new Checkbox(0, 0, 10, 10, (Component)Component.m_237115_((String)"gui.tacz.gun_smith_table.filter.all"), true){

            @Override
            public void m_5691_() {
                super.m_5691_();
                GunPackList.this.gunPackList.forEach(checkbox -> {
                    checkbox.selected = this.selected;
                });
                GunPackList.this.updateSelectedNamespaces();
            }
        };
        this.m_7085_((AbstractSelectionList.Entry)new Entry((AbstractWidget)checkbox1));
        for (String namespace : namespaces) {
            PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(namespace);
            MutableComponent name = packInfo == null ? Component.m_237113_((String)namespace) : Component.m_237115_((String)packInfo.getName());
            Checkbox checkbox = new Checkbox(0, 0, 10, 10, (Component)name, namespace, true){

                @Override
                public void m_5691_() {
                    super.m_5691_();
                    checkbox1.selected = GunPackList.this.gunPackList.stream().allMatch(Checkbox::selected);
                    GunPackList.this.updateSelectedNamespaces();
                }
            };
            this.gunPackList.add(checkbox);
            this.selectedNamespaces.add(namespace);
            this.m_7085_((AbstractSelectionList.Entry)new Entry((AbstractWidget)checkbox));
        }
    }

    public String getSearchText() {
        return this.byName.m_94155_();
    }

    public boolean isByHandSelected() {
        return this.byHandCheckbox.selected;
    }

    public Set<String> namespaceList() {
        return this.selectedNamespaces;
    }

    public void updateSelectedNamespaces() {
        this.selectedNamespaces.clear();
        this.gunPackList.forEach(checkbox -> {
            if (checkbox.selected) {
                this.selectedNamespaces.add(checkbox.getId());
            }
        });
        this.parent.m_7856_();
        this.parent.setIndexPage(0);
    }

    protected int m_5756_() {
        return this.f_93392_ - 2;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_7733_(pGuiGraphics);
        pGuiGraphics.m_280509_(this.f_93393_, this.f_93390_, this.f_93392_, this.f_93391_, Integer.MIN_VALUE);
        int i = this.m_5756_();
        int j = i + 6;
        this.m_280310_(pGuiGraphics);
        this.m_239227_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.m_280618_();
        int i2 = this.m_93518_();
        if (i2 > 0) {
            int j2 = (int)((float)((this.f_93391_ - this.f_93390_) * (this.f_93391_ - this.f_93390_)) / (float)this.m_5775_());
            j2 = Mth.m_14045_((int)j2, (int)32, (int)(this.f_93391_ - this.f_93390_ - 8));
            int k1 = (int)this.m_93517_() * (this.f_93391_ - this.f_93390_ - j2) / i2 + this.f_93390_;
            if (k1 < this.f_93390_) {
                k1 = this.f_93390_;
            }
            pGuiGraphics.m_280509_(i, k1, j, k1 + j2, -8355712);
            pGuiGraphics.m_280509_(i, k1, j - 1, k1 + j2 - 1, -4144960);
        }
        this.m_7154_(pGuiGraphics, pMouseX, pMouseY);
        RenderSystem.disableBlend();
    }

    public int m_5747_() {
        return this.f_93393_ + 4;
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    public static class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        private final AbstractWidget widget;

        public Entry(AbstractWidget widget) {
            this.widget = widget;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)this.widget);
        }

        public void m_6311_(GuiGraphics pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pHovering, float pPartialTick) {
            this.widget.m_252865_(pLeft);
            this.widget.m_253211_(pTop);
            this.widget.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.widget);
        }
    }

    public static class Checkbox
    extends AbstractButton {
        private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/checkbox.png");
        protected boolean selected;
        protected final boolean showLabel;
        private String id;

        public Checkbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, String id, boolean pSelected) {
            this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
            this.id = id;
        }

        public Checkbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected) {
            this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
        }

        public Checkbox(int pX, int pY, int pWidth, int pHeight, Component pMessage, boolean pSelected, boolean pShowLabel) {
            super(pX, pY, pWidth, pHeight, pMessage);
            this.selected = pSelected;
            this.showLabel = pShowLabel;
        }

        public String getId() {
            return this.id;
        }

        public void m_5691_() {
            this.selected = !this.selected;
        }

        public boolean selected() {
            return this.selected;
        }

        public void m_168797_(NarrationElementOutput pNarrationElementOutput) {
            pNarrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
            if (this.f_93623_) {
                if (this.m_93696_()) {
                    pNarrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.focused"));
                } else {
                    pNarrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.hovered"));
                }
            }
        }

        public void m_87963_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.m_91087_();
            RenderSystem.enableDepthTest();
            Font font = minecraft.f_91062_;
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            pGuiGraphics.m_280163_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_93696_() ? 10.0f : 0.0f, this.selected ? 10.0f : 0.0f, 10, 10, 32, 32);
            pGuiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            if (this.showLabel) {
                pGuiGraphics.m_280430_(font, this.m_6035_(), this.m_252754_() + 24, this.m_252907_() + (this.f_93619_ - 8) / 2, 0xE0E0E0 | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
            }
        }
    }
}

