/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.pojo;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CommonTransformObject {
    @Nullable
    private Vector3f translation;
    @Nullable
    private Vector3f rotation;
    @Nullable
    private Vector3f scale;

    public CommonTransformObject() {
    }

    public CommonTransformObject(@Nullable Vector3f translation, @Nullable Vector3f rotation, @Nullable Vector3f scale) {
        this.translation = translation;
        this.rotation = rotation;
        this.scale = scale;
    }

    @Nonnull
    public Vector3f getTranslation() {
        if (this.translation == null) {
            this.translation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return this.translation;
    }

    @Nonnull
    public Vector3f getRotation() {
        if (this.rotation == null) {
            this.rotation = new Vector3f(0.0f, 0.0f, 0.0f);
        }
        return this.rotation;
    }

    @Nonnull
    public Vector3f getScale() {
        if (this.scale == null) {
            this.scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        return this.scale;
    }

    public boolean equals(Object other) {
        if (other instanceof CommonTransformObject) {
            CommonTransformObject object = (CommonTransformObject)other;
            boolean flag1 = this.translation == null || object.translation == null ? this.translation == null && object.translation == null : this.translation.equals((Object)object.translation);
            boolean flag2 = this.rotation == null || object.rotation == null ? this.rotation == null && object.rotation == null : this.rotation.equals((Object)object.rotation);
            boolean flag3 = this.scale == null || object.scale == null ? this.scale == null && object.scale == null : this.scale.equals((Object)object.scale);
            return flag1 && flag2 && flag3;
        }
        return false;
    }

    public CommonTransformObject lerp(CommonTransformObject target, float alpha) {
        CommonTransformObject object = new CommonTransformObject();
        object.translation = this.translation == null ? new Vector3f(0.0f, 0.0f, 0.0f) : new Vector3f((Vector3fc)this.translation);
        object.rotation = this.rotation == null ? new Vector3f(0.0f, 0.0f, 0.0f) : new Vector3f((Vector3fc)this.rotation);
        object.scale = this.scale == null ? new Vector3f(1.0f, 1.0f, 1.0f) : new Vector3f((Vector3fc)this.scale);
        object.translation.lerp((Vector3fc)target.getTranslation(), alpha);
        object.rotation.lerp((Vector3fc)target.getRotation(), alpha);
        object.scale.lerp((Vector3fc)target.getScale(), alpha);
        return object;
    }

    public static class Serializer
    implements JsonDeserializer<CommonTransformObject>,
    JsonSerializer<CommonTransformObject> {
        public CommonTransformObject deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                CommonTransformObject transformObject = new CommonTransformObject();
                JsonObject jsonObject = json.getAsJsonObject();
                JsonElement translationElement = jsonObject.get("translation");
                JsonElement rotationElement = jsonObject.get("rotation");
                JsonElement scaleElement = jsonObject.get("scale");
                if (translationElement != null) {
                    transformObject.translation = (Vector3f)context.deserialize(translationElement, Vector3f.class);
                }
                if (rotationElement != null) {
                    transformObject.rotation = (Vector3f)context.deserialize(rotationElement, Vector3f.class);
                }
                if (scaleElement != null) {
                    transformObject.scale = (Vector3f)context.deserialize(scaleElement, Vector3f.class);
                }
                return transformObject;
            }
            throw new JsonSyntaxException("Expected " + json + " to be a CommonTransformObject because it's not an JsonObject");
        }

        public JsonElement serialize(CommonTransformObject src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            if (src.translation != null) {
                jsonObject.add("translation", context.serialize((Object)src.translation));
            }
            if (src.rotation != null) {
                jsonObject.add("rotation", context.serialize((Object)src.rotation));
            }
            if (src.scale != null) {
                jsonObject.add("scale", context.serialize((Object)src.scale));
            }
            return jsonObject;
        }
    }
}

