/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.connection.cable_type;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.config.TFMGConfigs;
import com.drmangotea.tfmg.config.TFMGServerConfig;
import com.drmangotea.tfmg.content.electricity.connection.cable_type.ResistivityValues;
import com.drmangotea.tfmg.content.machinery.misc.winding_machine.SpoolItem;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.jetbrains.annotations.Nullable;

public class CableTypeStats
implements TooltipModifier {
    protected final SpoolItem cableItem;

    public CableTypeStats(SpoolItem cableItem) {
        this.cableItem = cableItem;
    }

    @Nullable
    public static CableTypeStats create(Item item) {
        if (item instanceof SpoolItem) {
            SpoolItem cableItem = (SpoolItem)item;
            if (Objects.equals(cableItem.cableTypeKey, TFMG.asResource("empty"))) {
                return null;
            }
            return new CableTypeStats(cableItem);
        }
        return null;
    }

    public void modify(ItemTooltipEvent context) {
        List<Component> conductorStats = CableTypeStats.getCableTypeStats(this.cableItem, context.getEntity());
        if (!conductorStats.isEmpty()) {
            List tooltip = context.getToolTip();
            tooltip.add(CommonComponents.f_237098_);
            tooltip.addAll(conductorStats);
        }
    }

    public static List<Component> getCableTypeStats(SpoolItem spoolItem, Player player) {
        ArrayList<Component> list = new ArrayList<Component>();
        TFMGServerConfig config = TFMGConfigs.server();
        boolean hasGoggles = GogglesItem.isWearingGoggles((Player)player);
        CreateLang.translate((String)"tooltip.resistivity", (Object[])new Object[0]).style(ChatFormatting.GRAY).addTo(list);
        double resistivity = ResistivityValues.getResistivity(TFMGUtils.getCableType(spoolItem.cableTypeKey));
        LangBuilder builder = CreateLang.builder();
        builder.space().add(CreateLang.text((String)(resistivity + "\u03a9"))).style(ChatFormatting.GOLD).addTo(list);
        return list;
    }

    static enum Resistivity {
        VERY_LOW(ChatFormatting.RED, ChatFormatting.GOLD),
        LOW(ChatFormatting.GOLD, ChatFormatting.YELLOW),
        MEDIUM(ChatFormatting.YELLOW, ChatFormatting.GREEN),
        HIGH(ChatFormatting.GREEN, ChatFormatting.DARK_GREEN);

        private final ChatFormatting absoluteColor;
        private final ChatFormatting relativeColor;

        private Resistivity(ChatFormatting absoluteColor, ChatFormatting relativeColor) {
            this.absoluteColor = absoluteColor;
            this.relativeColor = relativeColor;
        }

        public ChatFormatting getAbsoluteColor() {
            return this.absoluteColor;
        }

        public ChatFormatting getRelativeColor() {
            return this.relativeColor;
        }
    }
}

