/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.base;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.types.AbstractSmallEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.radial_engine.RadialEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.types.turbine_engine.TurbineEngineBlockEntity;
import com.drmangotea.tfmg.content.engines.upgrades.EnginePipingUpgrade;
import com.drmangotea.tfmg.content.engines.upgrades.TransmissionUpgrade;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EngineBlock
extends HorizontalKineticBlock {
    public static final EnumProperty<EngineState> ENGINE_STATE = EnumProperty.m_61587_((String)"engine_state", EngineState.class);
    public static final Property<Direction> SHAFT_FACING = DirectionProperty.m_61546_((String)"shaft_facing", (Predicate)Direction.Plane.HORIZONTAL);

    public EngineBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(ENGINE_STATE, (Comparable)((Object)EngineState.NORMAL)));
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(pos = context.m_8083_());
        if (blockEntity instanceof AbstractSmallEngineBlockEntity) {
            AbstractSmallEngineBlockEntity be = (AbstractSmallEngineBlockEntity)blockEntity;
            if (be.hasUpgrade()) {
                if (be.upgrade.isPresent()) {
                    if (be.upgrade.get() instanceof TransmissionUpgrade) {
                        BlockEntity blockEntity2;
                        if (be.getControllerBE().engineController != null && (blockEntity2 = level.m_7702_(be.getControllerBE().engineController)) instanceof EngineControllerBlockEntity) {
                            EngineControllerBlockEntity engineController = (EngineControllerBlockEntity)blockEntity2;
                            engineController.engineStarted = false;
                            engineController.accelerationRate = 0;
                            engineController.shift = TransmissionUpgrade.TransmissionState.NEUTRAL;
                            be.shift = TransmissionUpgrade.TransmissionState.NEUTRAL;
                            be.clutchPressed = false;
                            engineController.engine = null;
                            engineController.enginePos = null;
                            engineController.disconnectEngine();
                            engineController.sendData();
                        }
                        be.getControllerBE().engineController = null;
                        be.getControllerBE().highestSignal = 0;
                        be.getControllerBE().connectNextTick = true;
                        be.getControllerBE().fuelInjectionRate = 0.0f;
                        be.updateGeneratedRotation();
                        be.getControllerBE().updateGeneratedRotation();
                        be.getControllerBE().sendData();
                    }
                    be.playRemovalSound();
                    be.dropItem(be.upgrade.get().getItem().m_7968_());
                }
                be.upgrade = Optional.empty();
                be.updateRotation();
                return InteractionResult.SUCCESS;
            }
            if (!(be instanceof RadialEngineBlockEntity) && !(be instanceof TurbineEngineBlockEntity) && state.m_61143_(ENGINE_STATE) == EngineState.SHAFT) {
                be.playRemovalSound();
                be.dropItem(AllBlocks.SHAFT.asStack());
                level.m_7731_(pos, (BlockState)state.m_61124_(ENGINE_STATE, (Comparable)((Object)EngineState.NORMAL)), 2);
                be.connectNextTick = true;
                be.detachKinetics();
                be.getControllerBE().updateGeneratedRotation();
                be.updateGeneratedRotation();
                if (be.getOrCreateNetwork() != null) {
                    be.getOrCreateNetwork().remove((KineticBlockEntity)be);
                }
                be.m_6596_();
                be.sendData();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        AbstractSmallEngineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractSmallEngineBlockEntity && (be = (AbstractSmallEngineBlockEntity)blockEntity).insertItem(player.m_21120_(hand), player.m_6144_(), player, hand)) {
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(blockState, level, pos, player, hand, blockHitResult);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos pos, CollisionContext p_60558_) {
        return state.m_61143_(ENGINE_STATE) == EngineState.SHAFT ? TFMGShapes.ENGINE_FRONT.get(((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122424_()) : TFMGShapes.ENGINE.get((Direction)state.m_61143_(HORIZONTAL_FACING));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return state.m_61143_(ENGINE_STATE) == EngineState.SHAFT && face == state.m_61143_(SHAFT_FACING);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ENGINE_STATE, SHAFT_FACING});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos neighbor, boolean b) {
        AbstractSmallEngineBlockEntity be;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractSmallEngineBlockEntity && (be = (AbstractSmallEngineBlockEntity)blockEntity).hasUpgrade() && be.upgrade.get().getItem() == TFMGBlocks.INDUSTRIAL_PIPE.m_5456_()) {
            ((EnginePipingUpgrade)be.upgrade.get()).findTank(be);
        }
        super.m_6861_(state, level, pos, block, neighbor, b);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public static enum EngineState implements StringRepresentable
    {
        NORMAL("normal"),
        SHAFT("front"),
        BACK("back"),
        SINGLE("single");

        private final String name;

        private EngineState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

