/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.engines.engine_controller;

import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlock;
import com.drmangotea.tfmg.content.engines.engine_controller.EngineControllerBlockEntity;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerBindPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerInputPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineControllerStopControllerPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.EngineStartPacket;
import com.drmangotea.tfmg.content.engines.engine_controller.packets.TransmissionShiftPacket;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGKeys;
import com.drmangotea.tfmg.registry.TFMGPackets;
import com.mojang.blaze3d.platform.InputConstants;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.redstone.link.LinkBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.ControlsUtil;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EngineControllerClientHandler {
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    public static BlockPos controllerPos;
    private static BlockPos selectedLocation;
    private static int packetCooldown;
    private static Vector<KeyMapping> standardControls;

    public static void toggleBindMode(BlockPos location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
        }
    }

    public static void toggle() {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            controllerPos = null;
        } else {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
        }
    }

    public static void activateInLectern(BlockPos lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            controllerPos = lecternAt;
        }
    }

    public static void deactivateInLectern() {
        if (MODE == Mode.ACTIVE && EngineControllerClientHandler.isController()) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
        }
    }

    public static boolean isController() {
        return controllerPos != null;
    }

    protected static void onReset() {
        EngineControllerClientHandler.getControls().forEach(kb -> kb.m_7249_(ControlsUtil.isActuallyPressed((KeyMapping)kb)));
        packetCooldown = 0;
        selectedLocation = BlockPos.f_121853_;
        if (EngineControllerClientHandler.isController()) {
            TFMGPackets.getChannel().sendToServer((Object)new EngineControllerStopControllerPacket(controllerPos));
        }
        controllerPos = null;
        if (!currentlyPressed.isEmpty()) {
            TFMGPackets.getChannel().sendToServer((Object)new EngineControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
    }

    public static void tick() {
        BlockEntity blockEntity;
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (player.m_5833_()) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
            return;
        }
        if (!(EngineControllerClientHandler.isController() || AllItems.LINKED_CONTROLLER.isIn(heldItem) || AllItems.LINKED_CONTROLLER.isIn(heldItem = player.m_21206_()))) {
            MODE = Mode.IDLE;
            return;
        }
        if (EngineControllerClientHandler.isController() && ((EngineControllerBlock)((Object)TFMGBlocks.ENGINE_CONTROLLER.get())).getBlockEntityOptional((BlockGetter)mc.f_91073_, controllerPos).map(be -> !be.isUsedBy((Player)mc.f_91074_)).orElse(true).booleanValue()) {
            EngineControllerClientHandler.deactivateInLectern();
            return;
        }
        if (mc.f_91080_ != null) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
            return;
        }
        if (InputConstants.m_84830_((long)mc.m_91268_().m_85439_(), (int)256)) {
            MODE = Mode.IDLE;
            EngineControllerClientHandler.onReset();
            return;
        }
        Vector<KeyMapping> controls = EngineControllerClientHandler.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed((KeyMapping)controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            EngineControllerBlockEntity be2;
            if (!releasedKeys.isEmpty()) {
                TFMGPackets.getChannel().sendToServer((Object)new EngineControllerInputPacket(releasedKeys, false, controllerPos));
                blockEntity = player.m_9236_().m_7702_(controllerPos);
                if (blockEntity instanceof EngineControllerBlockEntity) {
                    be2 = (EngineControllerBlockEntity)blockEntity;
                    be2.handleInput(releasedKeys, false);
                }
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                TFMGPackets.getChannel().sendToServer((Object)new EngineControllerInputPacket(newKeys, true, controllerPos));
                blockEntity = player.m_9236_().m_7702_(controllerPos);
                if (blockEntity instanceof EngineControllerBlockEntity) {
                    be2 = (EngineControllerBlockEntity)blockEntity;
                    be2.handleInput(newKeys, true);
                }
                if (newKeys.contains(5) || newKeys.contains(6)) {
                    TFMGPackets.getChannel().sendToServer((Object)new TransmissionShiftPacket(newKeys, controllerPos));
                    blockEntity = player.m_9236_().m_7702_(controllerPos);
                    if (blockEntity instanceof EngineControllerBlockEntity) {
                        be2 = (EngineControllerBlockEntity)blockEntity;
                        if (newKeys.contains(6)) {
                            be2.shiftBack();
                        } else {
                            be2.shiftForward();
                        }
                    }
                }
                if (newKeys.contains(8)) {
                    TFMGPackets.getChannel().sendToServer((Object)new EngineStartPacket(controllerPos));
                    blockEntity = player.m_9236_().m_7702_(controllerPos);
                    if (blockEntity instanceof EngineControllerBlockEntity) {
                        be2 = (EngineControllerBlockEntity)blockEntity;
                        be2.toggleEngine();
                    }
                }
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.m_9236_(), (Vec3i)player.m_20183_(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                TFMGPackets.getChannel().sendToServer((Object)new EngineControllerInputPacket(pressedKeys, true, controllerPos));
                blockEntity = player.m_9236_().m_7702_(controllerPos);
                if (blockEntity instanceof EngineControllerBlockEntity) {
                    be2 = (EngineControllerBlockEntity)blockEntity;
                    be2.handleInput(newKeys, true);
                }
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            VoxelShape shape = mc.f_91073_.m_8055_(selectedLocation).m_60808_((BlockGetter)mc.f_91073_, selectedLocation);
            blockEntity = newKeys.iterator();
            if (blockEntity.hasNext()) {
                Integer integer = (Integer)blockEntity.next();
                LinkBehaviour linkBehaviour = (LinkBehaviour)BlockEntityBehaviour.get((BlockGetter)mc.f_91073_, (BlockPos)selectedLocation, (BehaviourType)LinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    TFMGPackets.getChannel().sendToServer((Object)new EngineControllerBindPacket(integer, selectedLocation));
                    CreateLang.translate((String)"linked_controller.key_bound", (Object[])new Object[]{controls.get(integer).m_90863_().getString()}).sendStatus((Player)mc.f_91074_);
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.m_7249_(false));
    }

    public static Vector<KeyMapping> getControls() {
        if (standardControls == null) {
            Options gameSettings = Minecraft.m_91087_().f_91066_;
            standardControls = new Vector(6);
            standardControls.add(gameSettings.f_92085_);
            standardControls.add(gameSettings.f_92087_);
            standardControls.add(gameSettings.f_92086_);
            standardControls.add(gameSettings.f_92088_);
            standardControls.add(gameSettings.f_92089_);
            standardControls.add(TFMGKeys.TRANSMISSION_SHIFT_UP.getKeybind());
            standardControls.add(TFMGKeys.TRANSMISSION_SHIFT_DOWN.getKeybind());
            standardControls.add(TFMGKeys.ENGINE_CONTROLLER_CUSTOM_BUTTON.getKeybind());
            standardControls.add(TFMGKeys.ENGINE_START.getKeybind());
            standardControls.add(gameSettings.f_92090_);
        }
        return standardControls;
    }

    static {
        selectedLocation = BlockPos.f_121853_;
    }

    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

