/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.distillation_tower.controller;

import com.drmangotea.tfmg.content.decoration.tanks.steel.SteelTankBlockEntity;
import com.drmangotea.tfmg.content.machinery.oil_processing.distillation_tower.controller.DistillationControllerBlock;
import com.drmangotea.tfmg.content.machinery.oil_processing.distillation_tower.output.DistillationOutputBlockEntity;
import com.drmangotea.tfmg.recipes.DistillationRecipe;
import com.drmangotea.tfmg.registry.TFMGTags;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class DistillationControllerBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    private static final Object DistillationRecipesKey = new Object();
    public DistillationRecipe recipe;
    LerpedFloat angle = LerpedFloat.angular();
    protected LazyOptional<IFluidHandler> fluidCapability;
    public final FluidTank tank = new SmartFluidTank(8000, this::onFluidStackChanged);

    public DistillationControllerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tank);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        DistillationRecipe recipe;
        super.tick();
        if (this.f_58857_.f_46443_) {
            this.angle.chase((double)(180.0f * ((float)this.tank.getFluidAmount() / (float)this.tank.getCapacity())), (double)0.2f, LerpedFloat.Chaser.EXP);
            this.angle.tickChaser();
        }
        ArrayList<DistillationOutputBlockEntity> outputs = this.getOutputs();
        BlockEntity beBehind = this.f_58857_.m_7702_(this.m_58899_().m_121945_(DistillationControllerBlock.getFacing(this.m_58900_()).m_122424_()));
        if (!(beBehind instanceof SteelTankBlockEntity)) {
            return;
        }
        SteelTankBlockEntity be = (SteelTankBlockEntity)beBehind;
        if (outputs.isEmpty() || be.activeHeat == 0) {
            return;
        }
        if (!(this.recipe != null && this.recipe.matches(this.tank, outputs.toArray().length) || (recipe = this.getMatchingRecipes()) == null)) {
            this.recipe = recipe;
            this.sendData();
        }
        if (this.recipe == null) {
            return;
        }
        float speedModifier = (float)be.activeHeat / 2.0f;
        if ((float)this.recipe.getInputFluid().getRequiredAmount() * speedModifier > (float)this.tank.getFluidAmount()) {
            return;
        }
        if (this.recipe.getFluidResults().toArray().length != this.getOutputs().toArray().length) {
            return;
        }
        if (be.isController() ? be.getHeight() < outputs.toArray().length * 2 || be.width < 2 && outputs.toArray().length > 3 : be.getControllerBE() != null && (be.getControllerBE().getHeight() < outputs.toArray().length * 2 || be.getControllerBE().width < 2)) {
            return;
        }
        for (DistillationOutputBlockEntity be1 : outputs) {
            if (be1.tank.getSpace() != 0 || be1.mode.get() != DistillationOutputBlockEntity.DistillationOutputMode.KEEP_FLUID) continue;
            return;
        }
        int numero = 0;
        for (DistillationOutputBlockEntity output : outputs) {
            FluidStack fluidStack = (FluidStack)this.recipe.getFluidResults().get(numero);
            if (fluidStack.isEmpty() || output.tank.fill(new FluidStack(fluidStack, (int)((float)fluidStack.getAmount() * speedModifier)), IFluidHandler.FluidAction.SIMULATE) > output.tank.getCapacity() && output.mode.get() == DistillationOutputBlockEntity.DistillationOutputMode.KEEP_FLUID) break;
            output.tank.fill(new FluidStack(fluidStack, (int)((float)fluidStack.getAmount() * speedModifier)), IFluidHandler.FluidAction.EXECUTE);
            int consumption = this.recipe.getInputFluid().getRequiredAmount() / 6;
            this.tank.drain((int)((float)consumption * speedModifier), IFluidHandler.FluidAction.EXECUTE);
            ++numero;
        }
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BlockEntity beBehind = this.f_58857_.m_7702_(this.m_58899_().m_121945_(DistillationControllerBlock.getFacing(this.m_58900_()).m_122424_()));
        if (beBehind instanceof SteelTankBlockEntity) {
            SteelTankBlockEntity be = (SteelTankBlockEntity)beBehind;
            CreateLang.translate((String)"goggles.distillation_tower.status", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip, 1);
            if (be.activeHeat > 0) {
                CreateLang.translate((String)"goggles.distillation_tower.level", (Object[])new Object[]{be.activeHeat}).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            } else {
                CreateLang.translate((String)"goggles.distillation_tower.level", (Object[])new Object[]{be.activeHeat}).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            }
            if (this.getOutputs().toArray().length > 0) {
                CreateLang.translate((String)"goggles.distillation_tower.found_outputs", (Object[])new Object[]{this.getOutputs().toArray().length}).style(ChatFormatting.GOLD).forGoggles(tooltip, 1);
            } else {
                CreateLang.translate((String)"goggles.distillation_tower.found_outputs", (Object[])new Object[]{this.getOutputs().toArray().length}).style(ChatFormatting.RED).forGoggles(tooltip, 1);
            }
        } else {
            CreateLang.translate((String)"goggles.distillation_tower.tank_not_found", (Object[])new Object[0]).style(ChatFormatting.RED).forGoggles(tooltip, 1);
        }
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(ForgeCapabilities.FLUID_HANDLER));
        return true;
    }

    protected DistillationRecipe getMatchingRecipes() {
        List list = RecipeFinder.get((Object)this.getRecipeCacheKey(), (Level)this.f_58857_, r -> r instanceof DistillationRecipe);
        for (int i = 0; i < list.toArray().length; ++i) {
            DistillationRecipe recipe = (DistillationRecipe)((Object)list.get(i));
            if (recipe.getFluidResults().toArray().length != this.getOutputs().toArray().length) continue;
            for (int y = 0; y < ((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().toArray().length; ++y) {
                if (this.tank.getFluid().getFluid() != ((FluidStack)((FluidIngredient)recipe.getFluidIngredients().get(0)).getMatchingFluidStacks().get(y)).getFluid() || this.tank.getFluidAmount() < ((FluidIngredient)recipe.getFluidIngredients().get(0)).getRequiredAmount()) continue;
                return recipe;
            }
        }
        return null;
    }

    protected Object getRecipeCacheKey() {
        return DistillationRecipesKey;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public ArrayList<DistillationOutputBlockEntity> getOutputs() {
        ArrayList<DistillationOutputBlockEntity> outputs = new ArrayList<DistillationOutputBlockEntity>();
        BlockPos checkedPos = this.m_58899_().m_7494_();
        for (int i = 0; i < 11; ++i) {
            if (i == 0 || i == 2 || i == 4 || i == 6 || i == 8 || i == 10) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(checkedPos);
                if (!(blockEntity instanceof DistillationOutputBlockEntity)) break;
                DistillationOutputBlockEntity be = (DistillationOutputBlockEntity)blockEntity;
                outputs.add(be);
            } else if (!this.f_58857_.m_8055_(checkedPos).m_204336_(TFMGTags.TFMGBlockTags.INDUSTRIAL_PIPE.tag)) break;
            checkedPos = checkedPos.m_7494_();
        }
        return outputs;
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.tank.readFromNBT(compound.m_128469_("TankContent"));
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("TankContent", (Tag)this.tank.writeToNBT(new CompoundTag()));
    }
}

