/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.combine;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.combine.TooltipCombineCraft;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;

@OnlyIn(value=Dist.CLIENT)
public record ClientTooltipCombineCraft(TooltipCombineCraft tooltip) implements ClientTooltipComponent
{
    private static final int WIDTH = 38;
    private static final int ICON_SIZE = 18;

    public void m_183452_(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (((Boolean)ConfigTombstone.client.showTooltipCombine.get()).booleanValue()) {
            ClientTooltipCombineCraft.render(guiGraphics, x, y, this.tooltip().stack(), this.tooltip().getEnabledCombinations(), true);
        }
    }

    public static void render(GuiGraphics guiGraphics, int x, int y, ItemStack ingredient, List<CombineCraft> combinations, boolean onlyIngredient) {
        int row;
        int left;
        int startX;
        int count = combinations.size();
        if (count == 0) {
            return;
        }
        int slotId = 0;
        int startY = y + 1;
        while (slotId < count) {
            startX = x;
            left = Math.min(5, count - slotId);
            for (row = 0; row < left; ++row) {
                Helper.renderCircle(guiGraphics, startX, startY, -15382113, 18);
                Helper.renderCircle(guiGraphics, startX + 18, startY, -15382113, 18);
                startX += 38;
            }
            slotId += left;
            startY += 19;
        }
        slotId = 0;
        startY = y + 2;
        while (slotId < count) {
            startX = x + 1;
            left = Math.min(5, count - slotId);
            for (row = 0; row < left; ++row) {
                CombineCraft combination = combinations.get(slotId++);
                if (onlyIngredient) {
                    guiGraphics.m_280480_(combination.added(), startX, startY);
                    guiGraphics.m_280480_(combination.result(), startX + 18, startY);
                } else {
                    guiGraphics.m_280480_(ingredient, startX, startY);
                    guiGraphics.m_280480_(combination.added(), startX + 18, startY);
                }
                startX += 38;
            }
            startY += 19;
        }
    }

    public int m_142069_(Font font) {
        return (Boolean)ConfigTombstone.client.showTooltipCombine.get() != false ? 38 * Math.min(5, this.tooltip().getEnabledCombinations().size()) : 0;
    }

    public int m_142103_() {
        return (Boolean)ConfigTombstone.client.showTooltipCombine.get() != false ? 19 * (int)Math.ceil((float)this.tooltip().getEnabledCombinations().size() / 5.0f) + 2 : 0;
    }
}

