/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.combine;

import it.unimi.dsi.fastutil.longs.Long2ObjectFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import ovh.corail.tombstone.helper.TimeHelper;

class CyclableIngredient {
    private final Long2ObjectFunction<ItemStack> cyclableIngredient;
    private final Predicate<ItemStack> isIngredient;
    private final Supplier<Ingredient> supplierIngredient;
    private final boolean cycling;

    CyclableIngredient(ItemStack stack) {
        this.cyclableIngredient = time -> stack;
        this.isIngredient = aStack -> aStack.m_150930_(stack.m_41720_());
        this.supplierIngredient = () -> Ingredient.m_43927_((ItemStack[])new ItemStack[]{stack});
        this.cycling = false;
    }

    CyclableIngredient(TagKey<Item> tagKey) {
        this.cyclableIngredient = time -> this.fromTag(time, tagKey);
        this.isIngredient = aStack -> aStack.m_204117_(tagKey);
        this.supplierIngredient = () -> Ingredient.m_204132_((TagKey)tagKey);
        this.cycling = true;
    }

    ItemStack fromTag(long time, TagKey<Item> tagKey) {
        return BuiltInRegistries.f_257033_.m_203431_(tagKey).map(holders -> {
            int count = holders.m_203632_();
            return new ItemStack(holders.m_203662_(Mth.m_14045_((int)((int)(time % ((long)count * 60L)) / 60), (int)0, (int)(count - 1))));
        }).orElse(ItemStack.f_41583_);
    }

    Ingredient asIngredient() {
        return this.supplierIngredient.get();
    }

    boolean isIngredient(ItemStack stack) {
        return this.isIngredient.test(stack);
    }

    ItemStack get() {
        return (ItemStack)this.cyclableIngredient.apply(this.cycling ? TimeHelper.systemTime() / 50L : 0L);
    }
}

