/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.helper.LootHelper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.RandomWeightedItem;
import ovh.corail.tombstone.registry.ModLootFunctions;
import ovh.corail.tombstone.registry.ModTags;

public class RandomMagicTabletFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = new ResourceLocation("tombstone", "random_magic_tablet");
    public static final Serializer SERIALIZER = new Serializer();
    private final boolean isAncient;

    protected RandomMagicTabletFunction(LootItemCondition[] conditionsIn, boolean isAncient) {
        super(conditionsIn);
        this.isAncient = isAncient;
    }

    public LootItemFunctionType m_7162_() {
        return ModLootFunctions.RANDOM_MAGIC_TABLET;
    }

    protected ItemStack m_7372_(ItemStack stack, LootContext context) {
        RandomWeightedItem generator = LootHelper.getItemGenerator(ModTags.Items.magic_tablets);
        ItemStack result = Optional.ofNullable(generator.getRandomItem()).filter(i -> {
            IDisableable disableable;
            return !(i instanceof IDisableable) || (disableable = (IDisableable)i).isEnabled();
        }).map(ItemStack::new).orElse(ItemStack.f_41583_);
        if (!result.m_41619_()) {
            NBTStackHelper.setBoolean(result, "enchant", true);
            if (this.isAncient) {
                NBTStackHelper.setBoolean(result, "ancient", true);
            }
        }
        return result;
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<RandomMagicTabletFunction> {
        public RandomMagicTabletFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, LootItemCondition[] conditionsIn) {
            return new RandomMagicTabletFunction(conditionsIn, GsonHelper.m_13855_((JsonObject)json, (String)"ancient", (boolean)false));
        }

        public void serialize(JsonObject json, RandomMagicTabletFunction fct, JsonSerializationContext serializationContext) {
            super.m_6170_(json, (LootItemConditionalFunction)fct, serializationContext);
            json.addProperty("ancient", Boolean.valueOf(fct.isAncient));
        }
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final boolean isAncient;

        public Builder(boolean isAncient) {
            this.isAncient = isAncient;
        }

        protected Builder getThis() {
            return this;
        }

        public LootItemFunction m_7453_() {
            return new RandomMagicTabletFunction(this.m_80699_(), this.isAncient);
        }
    }
}

