/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={Entity.class})
public class EntityMixin {
    @Inject(method={"isAlliedTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsAlliedTo(Entity entity, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (entity == null) {
            callbackInfoReturnable.setReturnValue((Object)false);
        } else {
            Entity entity2 = (Entity)this;
            if (entity2 instanceof LivingEntity) {
                LivingEntity otherEntity;
                LivingEntity thisEntity = (LivingEntity)entity2;
                if (entity instanceof LivingEntity && EntityHelper.areOwnerOrServants(thisEntity, otherEntity = (LivingEntity)entity)) {
                    callbackInfoReturnable.setReturnValue((Object)true);
                }
            }
        }
    }

    @Inject(method={"isInvisibleTo"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodIsInvisibleTo(Player player, CallbackInfoReturnable<Boolean> callbackInfoReturnable) {
        if (EffectHelper.isPotionActive((LivingEntity)player, ModEffects.ghostly_shape) || EffectHelper.isPotionActive((LivingEntity)player, ModEffects.true_sight)) {
            callbackInfoReturnable.setReturnValue((Object)false);
        }
    }
}

