/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.capability.TBCapabilityProvider;
import ovh.corail.tombstone.helper.Helper;

public final class CMessagePlayerCapSyncKnowledge {
    private final int knowledge;

    public CMessagePlayerCapSyncKnowledge(int knowledge) {
        this.knowledge = Math.max(0, knowledge);
    }

    static CMessagePlayerCapSyncKnowledge fromBytes(FriendlyByteBuf buf) {
        return new CMessagePlayerCapSyncKnowledge(buf.readInt());
    }

    static void toBytes(CMessagePlayerCapSyncKnowledge msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.knowledge);
    }

    public static class Handler {
        static void handle(final CMessagePlayerCapSyncKnowledge message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        Player player = ModTombstone.PROXY.getClientPlayer();
                        if (player != null) {
                            player.getCapability(TBCapabilityProvider.TB_CAPABILITY).ifPresent(cap -> cap.setKnowledge(message2.knowledge));
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

