/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.platform;

import com.tom.storagemod.Content;
import com.tom.storagemod.util.GameObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;

public class Platform {
    public static final GameObject.GameRegistry<Item> ITEMS = new GameObject.GameRegistry(ForgeRegistries.ITEMS);
    public static final GameObject.GameRegistry<Block> BLOCKS = new GameObject.GameRegistry(ForgeRegistries.BLOCKS);
    public static final GameObject.GameRegistryBE BLOCK_ENTITY = new GameObject.GameRegistryBE();
    public static final GameObject.GameRegistry<MenuType<?>> MENU_TYPE = new GameObject.GameRegistry(ForgeRegistries.MENU_TYPES);
    public static final DeferredRegister<CreativeModeTab> TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"toms_storage");
    private static List<Item> tabItems = new ArrayList<Item>();
    public static final RegistryObject<CreativeModeTab> STORAGE_MOD_TAB = TAB.register("tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.toms_storage.tab")).m_257737_(() -> new ItemStack((ItemLike)Content.terminal.get())).m_257501_((p, out) -> tabItems.forEach(arg_0 -> ((CreativeModeTab.Output)out).m_246326_(arg_0))).m_257652_());
    private static boolean curios = ModList.get().isLoaded("curios");

    public static <I extends Item> I addItemToTab(I item) {
        tabItems.add(item);
        return item;
    }

    public static void register() {
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY.register();
        MENU_TYPE.register();
        TAB.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static CompoundTag getSyncTag(ItemStack stack) {
        Item item = stack.m_41720_();
        CompoundTag compoundtag = null;
        if (item.isDamageable(stack) || item.m_41468_()) {
            compoundtag = stack.getShareTag();
        }
        return compoundtag;
    }

    public static InteractionResult checkUse(Level worldIn, BlockHitResult lookingAt, Player playerIn, InteractionHand handIn) {
        PlayerInteractEvent.RightClickBlock event = new PlayerInteractEvent.RightClickBlock(playerIn, handIn, lookingAt.m_82425_(), lookingAt);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        return null;
    }

    public static <T> T checkExtraSlots(Player player, Predicate<ItemStack> is, T def, Function<ItemStack, T> map) {
        List s;
        if (curios && !(s = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, is)).isEmpty()) {
            return map.apply(((SlotResult)s.get(0)).stack());
        }
        return def;
    }

    public static int getRecipeWidth(Recipe<?> recipe) {
        if (recipe instanceof IShapedRecipe) {
            IShapedRecipe sr = (IShapedRecipe)recipe;
            return sr.getRecipeWidth();
        }
        return -1;
    }
}

