/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.tom.storagemod.util.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class FilteredInventoryHandler
implements IItemHandler {
    private IItemHandler parent;
    private ItemPredicate filter;
    private boolean keepLastInSlot;

    public FilteredInventoryHandler(IItemHandler parent, ItemPredicate filter, boolean keepLastInSlot) {
        this.parent = parent;
        this.filter = filter;
        this.keepLastInSlot = keepLastInSlot;
    }

    public int getSlots() {
        return this.parent.getSlots();
    }

    public ItemStack getStackInSlot(int paramInt) {
        ItemStack inSlot = this.parent.getStackInSlot(paramInt);
        if (!this.isInFilter(inSlot)) {
            return ItemStack.f_41583_;
        }
        if (this.keepLastInSlot) {
            ItemStack s = inSlot.m_41777_();
            s.m_41774_(1);
            return s;
        }
        return inSlot;
    }

    public ItemStack insertItem(int paramInt, ItemStack stack, boolean paramBoolean) {
        if (!this.isInFilter(stack)) {
            return stack;
        }
        return this.parent.insertItem(paramInt, stack, paramBoolean);
    }

    public ItemStack extractItem(int slot, int amount, boolean paramBoolean) {
        ItemStack inSlot = this.parent.getStackInSlot(slot);
        if (this.keepLastInSlot && (amount = Math.min(inSlot.m_41613_() - 1, amount)) < 1) {
            return ItemStack.f_41583_;
        }
        if (!this.isInFilter(inSlot)) {
            return ItemStack.f_41583_;
        }
        return this.parent.extractItem(slot, amount, paramBoolean);
    }

    public int getSlotLimit(int paramInt) {
        return this.parent.getSlotLimit(paramInt);
    }

    public boolean isItemValid(int paramInt, ItemStack paramItemStack) {
        return this.isInFilter(paramItemStack);
    }

    private boolean isInFilter(ItemStack inSlot) {
        return this.filter.test(inSlot);
    }
}

