/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.item.bauble.hairpin;

import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.api.event.MaidAfterEatEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.yimeng261.maidspell.Global;
import com.github.yimeng261.maidspell.api.IExtendBauble;
import com.github.yimeng261.maidspell.item.MaidSpellItems;
import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class HairpinBauble
implements IExtendBauble {
    public static final Logger LOGGER = LogUtils.getLogger();

    public HairpinBauble() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onRemove(EntityMaid maid) {
    }

    @SubscribeEvent
    public void beforeMaidEffectAdded(MobEffectEvent.Applicable event) {
        EntityMaid maid;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof EntityMaid && ItemsUtil.getBaubleSlotInMaid((EntityMaid)(maid = (EntityMaid)livingEntity), (IMaidBauble)this) >= 0) {
            MobEffectInstance effectInstance = event.getEffectInstance();
            int fl = maid.getFavorabilityManager().getLevel();
            if (fl >= 3 && !effectInstance.m_19544_().m_19486_()) {
                event.setResult(Event.Result.DENY);
            }
            if (fl >= 2) {
                int duration = effectInstance.m_19557_();
                if (effectInstance.m_19544_().m_19486_()) {
                    duration = Math.max((int)((double)duration * 1.15), duration + 15);
                    effectInstance.m_19558_(new MobEffectInstance(effectInstance.m_19544_(), duration, event.getEffectInstance().m_19564_(), event.getEffectInstance().m_19571_(), event.getEffectInstance().m_19572_()));
                }
            }
        }
    }

    @SubscribeEvent
    public void afterMaidEat(MaidAfterEatEvent event) {
        EntityMaid maid = event.getMaid();
        if (ItemsUtil.getBaubleSlotInMaid((EntityMaid)maid, (IMaidBauble)this) >= 0) {
            maid.getFavorabilityManager().add(1);
        }
    }

    static {
        Global.bauble_hurtProcessors_pre.put(MaidSpellItems.itemDesc(MaidSpellItems.HAIRPIN), (event, maid) -> {
            LivingEntity owner = maid.m_269323_();
            DamageSource source = event.getSource();
            if (owner == null) {
                return null;
            }
            if (Boolean.TRUE.equals(Global.IN_REDIRECT.get())) {
                return null;
            }
            long now = owner.m_9236_().m_46467_();
            Global.DamageKey key = Global.DamageKey.build(owner, source);
            long expire = now + 2L;
            Deque queue = Global.hairpinTickets.computeIfAbsent(owner.m_20148_(), k -> new ArrayDeque());
            queue.addLast(new Global.RedirectTicket(maid.m_20148_(), key, expire));
            Global.hairpinTickets.put(owner.m_20148_(), queue);
            owner.m_6469_(source, event.getAmount());
            event.setCanceled(true);
            return null;
        });
    }
}

