/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.inventory.MaidAwareBaubleItemHandler;
import com.github.yimeng261.maidspell.inventory.SpellBookAwareMaidBackpackHandler;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityMaid.class})
public class EntityMaidMixin {
    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    private void replaceHandlers(EntityType<EntityMaid> type, Level world, CallbackInfo ci) {
        try {
            LogUtils.getLogger().info("Replacing maid handlers in constructor");
            Field maidInvField = EntityMaid.class.getDeclaredField("maidInv");
            maidInvField.setAccessible(true);
            SpellBookAwareMaidBackpackHandler newMaidInv = new SpellBookAwareMaidBackpackHandler(36, (EntityMaid)this);
            maidInvField.set(this, (Object)newMaidInv);
            LogUtils.getLogger().info("Successfully replaced maidInv with SpellBookAwareMaidBackpackHandler");
            Field maidBaubleField = EntityMaid.class.getDeclaredField("maidBauble");
            maidBaubleField.setAccessible(true);
            MaidAwareBaubleItemHandler newMaidBauble = new MaidAwareBaubleItemHandler(9, (EntityMaid)this);
            maidBaubleField.set(this, (Object)newMaidBauble);
            LogUtils.getLogger().info("Successfully replaced maidBauble with MaidAwareBaubleItemHandler");
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Failed to replace maid handlers", (Throwable)e);
        }
    }
}

