/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.data;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class MaidSlashBladeData {
    private static final Map<UUID, MaidSlashBladeData> DATA_MAP = new ConcurrentHashMap<UUID, MaidSlashBladeData>();
    private ItemStack slashBlade = ItemStack.f_41583_;
    private WeakReference<LivingEntity> target = new WeakReference<Object>(null);
    private boolean isCasting = false;
    private long saExecutionStartTime = 0L;
    private ResourceLocation lastComboState = null;
    private int targetUseTime = 0;
    private int cooldown = 0;

    private MaidSlashBladeData(UUID maidUUID) {
    }

    public static MaidSlashBladeData getOrCreate(UUID maidUUID) {
        return DATA_MAP.computeIfAbsent(maidUUID, MaidSlashBladeData::new);
    }

    public static void remove(UUID maidUUID) {
        DATA_MAP.remove(maidUUID);
    }

    public void setSlashBlade(ItemStack slashBlade) {
        this.slashBlade = slashBlade != null ? slashBlade.m_41777_() : ItemStack.f_41583_;
    }

    public LivingEntity getTarget() {
        return (LivingEntity)this.target.get();
    }

    public void setTarget(LivingEntity target) {
        this.target = new WeakReference<LivingEntity>(target);
    }

    public boolean isCasting() {
        return this.isCasting;
    }

    public void setCasting(boolean casting) {
        this.isCasting = casting;
    }

    public void setSAExecutionStartTime(long time) {
        this.saExecutionStartTime = time;
    }

    public long getSAExecutionStartTime() {
        return this.saExecutionStartTime;
    }

    public int getTargetUseTime() {
        return this.targetUseTime;
    }

    public void setTargetUseTime(int time) {
        this.targetUseTime = time;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int time) {
        this.cooldown = time;
    }

    public Boolean isOnCooldown() {
        return this.cooldown > 0;
    }

    public ResourceLocation getLastComboState() {
        return this.lastComboState;
    }

    public void setLastComboState(ResourceLocation lastComboState) {
        this.lastComboState = lastComboState;
    }

    public void updateCooldowns() {
        this.cooldown -= 20;
    }

    public void reset() {
        this.slashBlade = ItemStack.f_41583_;
        this.target = new WeakReference<Object>(null);
        this.isCasting = false;
        this.saExecutionStartTime = 0L;
        this.targetUseTime = 0;
        this.lastComboState = null;
    }
}

