/*
 * Decompiled with CFR 0.152.
 */
package com.github.yimeng261.maidspell.spell.providers;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.yimeng261.maidspell.api.ISpellBookProvider;
import com.github.yimeng261.maidspell.spell.data.MaidArsNouveauSpellData;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import com.hollingsworth.arsnouveau.api.util.CasterUtil;
import com.hollingsworth.arsnouveau.api.util.SpellUtil;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.items.SpellBook;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSensitive;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import org.slf4j.Logger;

public class ArsNouveauProvider
implements ISpellBookProvider {
    private static final Logger LOGGER = LogUtils.getLogger();

    private MaidArsNouveauSpellData getData(EntityMaid maid) {
        if (maid == null) {
            return null;
        }
        return MaidArsNouveauSpellData.getOrCreate(maid.m_20148_());
    }

    @Override
    public boolean isSpellBook(ItemStack itemStack) {
        if (itemStack == null || itemStack.m_41619_()) {
            return false;
        }
        return itemStack.m_41720_() instanceof SpellBook;
    }

    @Override
    public void setTarget(EntityMaid maid, LivingEntity target) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data != null) {
            data.setTarget(target);
        }
    }

    @Override
    public LivingEntity getTarget(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        return data != null ? data.getTarget() : null;
    }

    @Override
    public void setSpellBook(EntityMaid maid, ItemStack spellBook) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data != null) {
            data.setSpellBook(spellBook);
            if (this.isSpellBook(spellBook)) {
                ISpellCaster caster = CasterUtil.getCaster((ItemStack)spellBook);
                data.setCurrentCaster(caster);
            } else {
                data.setCurrentCaster(null);
            }
        }
    }

    @Override
    public boolean isCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        return data != null && data.isCasting();
    }

    @Override
    public boolean initiateCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data == null || data.isCasting() || !this.isSpellBook(data.getSpellBook()) || data.getCurrentCaster() == null) {
            return false;
        }
        this.ensureManaCapability(maid);
        Spell spell = this.selectRandomSpell(data);
        if (spell == null) {
            return false;
        }
        LivingEntity target = data.getTarget();
        if (target != null) {
            BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
        }
        data.setCasting(true);
        data.setCastingTicks(0);
        data.setCurrentSpell(spell);
        data.setSpellCooldown(spell.name, spell.getCost(), maid);
        maid.m_6674_(InteractionHand.MAIN_HAND);
        return true;
    }

    @Override
    public void processContinuousCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentSpell() == null) {
            return;
        }
        data.incrementCastingTicks();
        LivingEntity target = data.getTarget();
        if (target != null) {
            BehaviorUtils.m_22595_((LivingEntity)maid, (LivingEntity)target);
        }
        if (data.isCastingComplete()) {
            this.completeCasting(maid);
        }
    }

    @Override
    public void stopCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data == null || !data.isCasting()) {
            return;
        }
        data.resetCastingState();
    }

    @Override
    public boolean castSpell(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data != null && data.isCasting()) {
            return false;
        }
        return this.initiateCasting(maid);
    }

    @Override
    public void updateCooldown(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        data.updateCooldowns();
        if (maid != null && maid.f_19797_ % 100 == 0) {
            this.ensureManaCapability(maid);
        }
    }

    private void ensureManaCapability(EntityMaid maid) {
        IManaCap manaCap;
        LazyOptional manaOpt;
        if (maid != null && (manaOpt = CapabilityRegistry.getMana((LivingEntity)maid)).isPresent() && (manaCap = (IManaCap)manaOpt.orElse(null)).getCurrentMana() < 1000.0) {
            manaCap.setMana(1000.0);
        }
    }

    private List<Spell> getAvailableSpells(MaidArsNouveauSpellData data) {
        ArrayList<Spell> availableSpells = new ArrayList<Spell>();
        ISpellCaster caster = data.getCurrentCaster();
        if (caster == null) {
            return availableSpells;
        }
        for (int i = 0; i < caster.getMaxSlots(); ++i) {
            Spell spell = caster.getSpell(i);
            if (!spell.isValid() || spell.isEmpty() || data.isSpellOnCooldown(spell.name)) continue;
            availableSpells.add(spell);
        }
        return availableSpells;
    }

    private Spell selectRandomSpell(MaidArsNouveauSpellData data) {
        List<Spell> availableSpells = this.getAvailableSpells(data);
        if (availableSpells.isEmpty()) {
            return null;
        }
        int randomIndex = (int)(Math.random() * (double)availableSpells.size());
        return availableSpells.get(randomIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCasting(EntityMaid maid) {
        MaidArsNouveauSpellData data = this.getData(maid);
        if (data == null || !data.isCasting() || data.getCurrentSpell() == null || data.getCurrentCaster() == null) {
            return;
        }
        try {
            this.ensureManaCapability(maid);
            LivingCaster wrappedCaster = new LivingCaster((LivingEntity)maid);
            SpellContext context = new SpellContext(maid.m_9236_(), data.getCurrentSpell(), (LivingEntity)maid, (IWrappedCaster)wrappedCaster, data.getSpellBook());
            SpellResolver resolver = new SpellResolver(context){

                protected boolean enoughMana(LivingEntity entity) {
                    return true;
                }

                public void expendMana() {
                }
            };
            boolean castSuccess = false;
            LivingEntity target = data.getTarget();
            if (target != null) {
                Vec3 targetPos = target.m_146892_();
                Vec3 maidPos = maid.m_146892_();
                Vec3 direction = targetPos.m_82546_(maidPos).m_82541_();
                float yaw = (float)(Math.atan2(direction.f_82479_, direction.f_82481_) * 180.0 / Math.PI);
                float pitch = (float)(Math.asin(-direction.f_82480_) * 180.0 / Math.PI);
                maid.m_146922_(yaw);
                maid.m_146926_(pitch);
                maid.f_19859_ = yaw;
                maid.f_19860_ = pitch;
                if (data.getCurrentSpell().getCastMethod() instanceof MethodProjectile) {
                    try {
                        EntityProjectileSpell projectile = new EntityProjectileSpell(maid.m_9236_(), resolver);
                        projectile.m_5602_((Entity)maid);
                        projectile.m_6034_(maidPos.f_82479_, maidPos.f_82480_ - 0.1, maidPos.f_82481_);
                        float velocity = Math.max(0.1f, 0.75f + resolver.getCastStats().getAccMultiplier() / 2.0f);
                        projectile.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, 0.0f);
                        maid.m_9236_().m_7967_((Entity)projectile);
                        castSuccess = true;
                    }
                    catch (Exception e) {
                        castSuccess = resolver.onCastOnEntity(data.getSpellBook(), (Entity)target, InteractionHand.MAIN_HAND);
                    }
                } else {
                    resolver.hitResult = new EntityHitResult((Entity)target, targetPos);
                    castSuccess = resolver.onCastOnEntity(data.getSpellBook(), (Entity)target, InteractionHand.MAIN_HAND);
                }
            } else {
                EntityHitResult entityHitResult;
                boolean isSensitive = data.getCurrentSpell().getBuffsAtIndex(0, (LivingEntity)maid, (AbstractAugment)AugmentSensitive.INSTANCE) > 0;
                HitResult result = SpellUtil.rayTrace((Entity)maid, (double)5.5, (float)0.0f, (boolean)isSensitive);
                if (result instanceof EntityHitResult && (entityHitResult = (EntityHitResult)result).m_82443_() instanceof LivingEntity) {
                    castSuccess = resolver.onCastOnEntity(data.getSpellBook(), entityHitResult.m_82443_(), InteractionHand.MAIN_HAND);
                } else if (result instanceof BlockHitResult) {
                    BlockHitResult blockHitResult = (BlockHitResult)result;
                    castSuccess = resolver.onCastOnBlock(blockHitResult);
                } else {
                    castSuccess = resolver.onCast(data.getSpellBook(), maid.m_9236_());
                }
            }
            if (castSuccess && data.getCurrentSpell().sound != null && data.getCurrentSpell().sound.sound != null) {
                maid.m_9236_().m_6263_(null, maid.m_20185_(), maid.m_20186_(), maid.m_20189_(), data.getCurrentSpell().sound.sound.getSoundEvent(), SoundSource.NEUTRAL, data.getCurrentSpell().sound.volume, data.getCurrentSpell().sound.pitch);
            }
        }
        catch (Exception exception) {
        }
        finally {
            data.resetCastingState();
        }
    }
}

