/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.CharacterSetting;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.NotNull;

public class SettingReader {
    private static final String SETTING_FOLDER_NAME = "settings";
    private static final Path SETTINGS_FOLDER = FMLPaths.CONFIGDIR.get().resolve("touhou_little_maid").resolve("settings");
    private static final Map<String, CharacterSetting> SETTINGS = Maps.newHashMap();
    private static final String YAML = ".yml";

    public static void clear() {
        SETTINGS.clear();
    }

    public static void reloadSettings() {
        if (!Files.exists(SETTINGS_FOLDER, new LinkOption[0])) {
            try {
                Files.createDirectories(SETTINGS_FOLDER, new FileAttribute[0]);
            }
            catch (IOException e) {
                TouhouLittleMaid.LOGGER.error("Failed to create settings folder", (Throwable)e);
            }
        }
        try {
            SettingReader.readConfigSetting(SETTINGS_FOLDER, 8);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to read settings file", (Throwable)e);
        }
    }

    public static void readCustomPack(Path rootPath, String domain) {
        Path folder = rootPath.resolve("assets").resolve(domain).resolve(SETTING_FOLDER_NAME);
        if (!folder.toFile().isDirectory()) {
            return;
        }
        try {
            SettingReader.readConfigSetting(folder, 1);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to read settings from {}", (Object)folder, (Object)e);
        }
    }

    public static void readCustomPack(ZipFile zipFile, String domain) {
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        String folder = String.format("assets/%s/%s/", domain, SETTING_FOLDER_NAME);
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || !entryName.startsWith(folder) || !entryName.endsWith(YAML)) continue;
            TouhouLittleMaid.LOGGER.debug("Loading settings from {}", (Object)entryName);
            try {
                InputStream inputStream = zipFile.getInputStream(entry);
                try {
                    CharacterSetting setting = new CharacterSetting(inputStream);
                    setting.getModelId().forEach(id -> SETTINGS.put((String)id, setting));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to read settings from {}", (Object)entryName, (Object)e);
            }
        }
    }

    private static void readConfigSetting(Path settingFolder, int maxDepth) throws IOException {
        Files.walkFileTree(settingFolder, EnumSet.noneOf(FileVisitOption.class), maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult visitFile(@NotNull Path file, @NotNull BasicFileAttributes attributes) throws IOException {
                String fileName = file.getFileName().toString();
                if (fileName.endsWith(SettingReader.YAML)) {
                    try {
                        CharacterSetting setting = new CharacterSetting(file.toFile());
                        setting.getModelId().forEach(id -> SETTINGS.put((String)id, setting));
                    }
                    catch (Exception e) {
                        TouhouLittleMaid.LOGGER.error("Failed to read settings from {}", (Object)file, (Object)e);
                    }
                }
                return super.visitFile(file, attributes);
            }
        });
    }

    public static Optional<CharacterSetting> getSetting(@NotNull String name) {
        return Optional.ofNullable(SETTINGS.get(name));
    }

    public static Set<String> getAllSettingKeys() {
        return SETTINGS.keySet();
    }

    public static Path getSettingsFolder() {
        return SETTINGS_FOLDER;
    }
}

