/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.service.llm;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ConfigProxySelector;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializableSite;
import com.github.tartaricacid.touhoulittlemaid.ai.service.SerializerRegister;
import com.github.tartaricacid.touhoulittlemaid.ai.service.ServiceType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Site;
import com.github.tartaricacid.touhoulittlemaid.ai.service.llm.LLMClient;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.http.HttpClient;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.Logger;

public interface LLMSite
extends Site {
    public static final HttpClient LLM_HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).proxy(new ConfigProxySelector(AIConfig.LLM_PROXY_ADDRESS)).version(HttpClient.Version.HTTP_1_1).build();

    public static Map<String, LLMSite> readSites(Path file) {
        HashMap output = Maps.newHashMap();
        try (BufferedReader reader = Files.newBufferedReader(file);){
            JsonObject root = GsonHelper.m_13859_((Reader)reader);
            for (String id : root.keySet()) {
                JsonElement value = root.get(id);
                if (!(value instanceof JsonObject)) continue;
                JsonObject jsonObject = (JsonObject)value;
                String apiType = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"api_type");
                SerializableSite<LLMSite> serializer = SerializerRegister.getLLMSerializer(apiType);
                if (serializer == null) {
                    TouhouLittleMaid.LOGGER.error("Unknown LLM site type: {}", (Object)apiType);
                    continue;
                }
                serializer.codec().decode((DynamicOps)JsonOps.INSTANCE, (Object)value).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).ifPresent(site -> output.put(id, (LLMSite)site.getFirst()));
            }
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to read sites", (Throwable)e);
        }
        return output;
    }

    public static void writeSites(Path file, Map<String, LLMSite> sites) {
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(file, new OpenOption[0]));){
            JsonObject root = new JsonObject();
            for (String id : sites.keySet()) {
                LLMSite site = sites.get(id);
                SerializableSite<LLMSite> serializer = SerializerRegister.getLLMSerializer(site.getApiType());
                JsonElement json = (JsonElement)serializer.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)site).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).orElseThrow();
                json.getAsJsonObject().addProperty("api_type", site.getApiType());
                root.add(id, json);
            }
            writer.setSerializeNulls(false);
            writer.setIndent("  ");
            GsonHelper.m_216207_((JsonWriter)writer, (JsonElement)root, (Comparator)KEY_COMPARATOR);
        }
        catch (IOException e) {
            TouhouLittleMaid.LOGGER.error("Failed to save sites", (Throwable)e);
        }
    }

    @Override
    public LLMClient client();

    @Override
    default public ServiceType getServiceType() {
        return ServiceType.LLM;
    }
}

