/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button;

import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadInfo;
import com.github.tartaricacid.touhoulittlemaid.client.download.pojo.DownloadStatus;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.FlatColorButton;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class PackInfoButton
extends FlatColorButton {
    private static final ResourceLocation BG = new ResourceLocation("touhou_little_maid", "textures/gui/download_background.png");
    private final DownloadInfo info;

    public PackInfoButton(int pX, int pY, DownloadInfo info, Button.OnPress onPress) {
        super(pX, pY, 268, 46, (Component)Component.m_237119_(), onPress);
        this.info = info;
        this.setTooltips(Lists.newArrayList((Object[])new Component[]{this.getI18nFormatDesc(info.getDesc()), this.getI18nFormatLicense(info.getLicense())}));
    }

    @Override
    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float pPartialTick) {
        int count;
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.isSelect) {
            graphics.m_280024_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -14774017, -14774017);
        } else if (this.info.getStatus() != DownloadStatus.DOWNLOADED) {
            graphics.m_280024_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -12369342, -12369342);
        }
        int downloadProgress = this.info.getDownloadProgress();
        if (this.info.getStatus() == DownloadStatus.DOWNLOADING && downloadProgress >= 0) {
            int widthProgress = this.f_93618_ * downloadProgress / 100;
            graphics.m_280024_(this.m_252754_(), this.m_252907_(), this.m_252754_() + widthProgress, this.m_252907_() + this.f_93619_, -43213, -43213);
        }
        if (this.info.getStatus() == DownloadStatus.NEED_UPDATE) {
            graphics.m_280218_(BG, this.m_252754_() + 240, this.m_252907_() + 15, 48, 16, 16, 16);
        }
        if (this.m_198029_()) {
            graphics.m_280024_(this.m_252754_(), this.m_252907_() + 1, this.m_252754_() + 1, this.m_252907_() + this.f_93619_ - 1, -790560, -790560);
            graphics.m_280024_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + 1, -790560, -790560);
            graphics.m_280024_(this.m_252754_() + this.f_93618_ - 1, this.m_252907_() + 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_ - 1, -790560, -790560);
            graphics.m_280024_(this.m_252754_(), this.m_252907_() + this.f_93619_ - 1, this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -790560, -790560);
        }
        if ((count = this.info.getTypeCount()) == 3) {
            graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 0, 96, 32, 32);
        } else if (count == 2) {
            if (!this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
                graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 64, 64, 32, 32);
            } else if (!this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
                graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 32, 64, 32, 32);
            } else {
                graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 0, 64, 32, 32);
            }
        } else if (this.info.hasType(DownloadInfo.TypeEnum.MAID)) {
            graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 0, 32, 32, 32);
        } else if (this.info.hasType(DownloadInfo.TypeEnum.CHAIR)) {
            graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 32, 32, 32, 32);
        } else {
            graphics.m_280218_(BG, this.m_252754_() + 7, this.m_252907_() + 7, 64, 32, 32, 32);
        }
        int i = this.getFGColor();
        this.m_280139_(graphics, minecraft.f_91062_, i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24);
        if (this.info.getStatus() == DownloadStatus.DOWNLOADED) {
            graphics.m_280024_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 2133008930, 2133008930);
        }
    }

    @Override
    public void m_280139_(GuiGraphics graphics, Font font, int pColor) {
        int startX = this.m_252754_() + 50;
        int startY = this.m_252907_() + 4;
        MutableComponent packName = Component.m_237115_((String)this.info.getName());
        graphics.m_280430_(font, (Component)packName, startX, startY, ChatFormatting.WHITE.m_126665_().intValue());
        graphics.m_280488_(font, this.getI18nFormatFileVersion(this.info.getVersion()), startX + 5 + font.m_92852_((FormattedText)packName), startY, ChatFormatting.GREEN.m_126665_().intValue());
        graphics.m_280430_(font, (Component)this.getI18nFormatFileSize(this.info.getFormatFileSize()), startX, startY + 10, ChatFormatting.GOLD.m_126665_().intValue());
        graphics.m_280430_(font, (Component)this.getI18nFormatAuthor(this.info.getAuthor()), startX, startY + 20, ChatFormatting.AQUA.m_126665_().intValue());
        graphics.m_280430_(font, (Component)this.getI18nFormatFileTime(this.info.getFormatData()), startX, startY + 30, ChatFormatting.GRAY.m_126665_().intValue());
    }

    private String getI18nFormatFileVersion(String version) {
        return "\u00a7nv" + version;
    }

    private MutableComponent getI18nFormatAuthor(List<String> authors) {
        String str = String.join((CharSequence)I18n.m_118938_((String)"gui.touhou_little_maid.resources_download.author.delimiter", (Object[])new Object[0]), authors);
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.author", (Object[])new Object[]{str});
    }

    private MutableComponent getI18nFormatFileSize(String size) {
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.file_size", (Object[])new Object[]{size});
    }

    private MutableComponent getI18nFormatFileTime(String time) {
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.upload_time", (Object[])new Object[]{time});
    }

    private MutableComponent getI18nFormatLicense(String license) {
        return Component.m_237110_((String)"gui.touhou_little_maid.resources_download.license", (Object[])new Object[]{license}).m_130940_(ChatFormatting.DARK_PURPLE).m_130940_(ChatFormatting.ITALIC);
    }

    private MutableComponent getI18nFormatDesc(String desc) {
        return Component.m_237115_((String)desc).m_130940_(ChatFormatting.GRAY);
    }
}

